﻿/**
ふるい・・・
*/
module nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(exceptiondialog) void main() {}

import std.conv;
import std.string;

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.negui.window.window;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.gui.window.dialog.selectdialog;
//import nemuxi.negui.proc.exceptionwnd.exceptionwnd;
import nemuxi.negui.window.dialog.system;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.label.label;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.treeview.treeview;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.draw.unit;
import nemuxi.negui.control.group;
import nemuxi.utility.simple.sysinfo;


package enum CTRL {
	WARNIG=1,
	MESSAGE,
	//ERRCODE,
	//DETAILS,
	WEB,
	CLOSE,
	COPY,
	FILE,
	UPLOAD,
	//SELECT_MSG,
	LIST
}
final scope class ExceptionDialog: SelectDialog {
	private {
		//Throwable Throwables;
		Throwable FirstThrowable;
		//Window Owner;
		
		Font MessageFont;
		Font CtrlFont;
		Font TreeFont;

		ControlGroup Msgs, Buttons;

		enum CTRL {
			WARNIG=1,
			MESSAGE,
			//ERRCODE,
			//DETAILS,
			WEB,
			CLOSE,
			COPY,
			FILE,
			UPLOAD,
			//SELECT_MSG,
			LIST
		}
	}
	package {
		IconLabel Warnig;
		EditBox Message;
		//EditBox ErrCode;
		Push Web, Close, Copy, File, UpLoad;
		//EditBox SelectMsg;
		TreeView List;

		
	}

	this(Window OwnerWindow, Throwable e) {
		FirstThrowable = e;
		GUIINFO NeGuiInfo;
		NeGuiInfo.Style        = WS_DLGFRAME | WS_CAPTION | WS_SYSMENU;
		NeGuiInfo.Style        |= WS_SIZEBOX;
		NeGuiInfo.Owner=OwnerWindow;

		super(&NeGuiInfo);
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 4;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 5;;
			super.adjustSize(&Size);

		defButton = Close;

		super.Center = CENTER.DESKTOP;
	}

//	private mixin Modal;
	
	override bool select() {
		/+
		try {
			if(Owner) {
				Owner.enable = false;
			}
			SIZE Size;
			Size.cx = GetSystemMetrics(SM_CXSCREEN) / 4;
			Size.cy = GetSystemMetrics(SM_CYSCREEN) / 6;;
			super.adjustSize(&Size);
			super.toCenter(CENTER.DESKTOP, null);
			super.setShow(SW.SHOW);
			SetOverAuto(Close);
			MessageBeep(MB_ICONEXCLAMATION);
			modal;

			return true;
		} catch(Exception e) {
			Logger.write(e);
			return false;
		} finally {
			if(Owner) {
				Owner.enable = true;
				Owner.foreGround();
				Owner.send(WM_NULL, NONE, NONE);
			}
		}
		+/
		try {
			MessageBeep(MB_ICONEXCLAMATION);
			
			return super.select();
		} catch(Throwable e) {
			Logger.write(e);
			return false;
		}
	}
	


	void commandWeb() {
	}
	void commandCopy() {
	}
	void commandFile() {
	}
	void commandUpLoad() {
	}

	protected override {
		void OnDestroy() {
			delete MessageFont;
			delete CtrlFont;
			delete TreeFont;
			
			super.OnDestroy();
		}
		/*
		History:
			1.00β11:
				メッセージ欄にシステム情報の書き出し。
				メッセージ欄のフォントをSYSFONT.MESSAGEへ変更。
		*/
		void OnCreate() {
			MessageFont = GetSystemFont(SYSFONT.MESSAGE);
			CtrlFont    = GetSystemFont(SYSFONT.MESSAGE);
			TreeFont    = GetSystemFont(SYSFONT.ICON);
			
			{ // コントロール
				//Warnig=new IconLabel(child(CTRL.WARNIG));
				Warnig=new IconLabel(this, CTRL.WARNIG);
				Warnig.image(GetSystemIcon(SYSICON.HAND, ICONSIZE.NORMAL));

				//Message=new TextLabel(child(CTRL.MESSAGE));
				//Message=new TextLabel(this, CTRL.MESSAGE);
				Message=new MultiEdit(this, CTRL.MESSAGE);

				//ErrCode  = new TextLabel(child(CTRL.ERRCODE));
				//ErrCode  = new EditBox(this, CTRL.ERRCODE);

				//
				/+
				Msgs = new ControlGroup(
					Message, ErrCode
				);
				Msgs.font = MessageFont;
				+/
				Message.font = MessageFont;

				/+
				Web    = new Push(child(CTRL.WEB));
				Close  = new Push(child(CTRL.CLOSE));
				Copy   = new Push(child(CTRL.COPY));
				File   = new Push(child(CTRL.FILE));
				UpLoad = new Push(child(CTRL.UPLOAD));
				+/
				Web    = new Push(this, (CTRL.WEB));
				Close  = new Push(this, (CTRL.CLOSE));
				Copy   = new Push(this, (CTRL.COPY));
				File   = new Push(this, (CTRL.FILE));
				UpLoad = new Push(this, (CTRL.UPLOAD));

				Buttons = new ControlGroup(
					Web, Close, Copy, File, UpLoad
				);
				Buttons.font = CtrlFont;
				Close.def = true;

				//SelectMsg = new EditBox(child(CTRL.SELECT_MSG));
				//SelectMsg = new EditBox(this, (CTRL.SELECT_MSG));
				//SelectMsg.font = CtrlFont;

				List = new TreeView(this, CTRL.LIST);
				List.clientEdge = true;
				List.button =true;
				List.rootLine = true;
				List.button = true;
				List.reLoad;
			}

			{ // 固定文字列の設定
				Web   .text = Text("Web");
				Close .text = Text("閉じる");
				Copy  .text = Text("コピー");
				File  .text = Text("出力");
				UpLoad.text = Text("アップロード");
			}

			{ // 未実装部分非表示
				Buttons.setShow(SHOW.HIDE);
				Close.setShow(SHOW.SHOWNORMAL);
			}

			{ // リスト構築
				
				/+
				//TreeInsertItem.item = TreeItem;
				auto n=List.insert(&TreeInsertItem);
				//TreeInsertItem.insertAfter=n;
				TreeInsertItem.item.text=Text(789);
				TreeInsertItem.parent=n;
				List.insert(&TreeInsertItem);
				TreeInsertItem.item.text=Text(100);
				TreeInsertItem.insertAfter(TREEINSERTITEM.ROOT);
				TreeInsertItem.parent=TREE_ITEM.init;
				List.insert(&TreeInsertItem);
				//List.checkBox=true;
				//TREEITEM.MASK.
				+/
				Throwable NowThrowable=FirstThrowable;
				string[] msgs;
				
				while(NowThrowable) {
					//TREE_ITEM Parent;
					TREEINSERTITEM TreeInsertItem;
					TreeInsertItem.item.mask = TREEITEM.MASK.TEXT | TREEITEM.MASK.HANDLE | TREEITEM.MASK.USERDATA;
					
					TreeInsertItem.insertAfter(TREEINSERTITEM.LAST);

					//Throwables ~= NowThrowable;
					
					invariant string[] Title   = [
						"File",
						"Line",
						"Code",
						"Time"
					];
					// 新規ツリー構築
					//o.classinfo.name
					//TreeInsertItem.item.text = Text(format("%s: %s", NowThrowable.classinfo.name, NowThrowable.msg));
					TreeInsertItem.item.text     = Text(NowThrowable.classinfo.name);
					TreeInsertItem.item.data = cast(void*)NowThrowable;
					TreeInsertItem.parent = List.insert(TreeInsertItem);

					// 詳細の出力
					TreeInsertItem.item.text = Text(NowThrowable.msg);
					List.insert(TreeInsertItem);
					
					if(auto ne=cast(NemuxiException)NowThrowable) {
						// ﾈﾑぃ例外
						// クラス判定(未実装)
						//TreeInsertItem.item.text     = Text(format("%s: %s", ExceptionName(ne), ne.msg));
						//TreeInsertItem.item.userData = cast(void*)NowThrowable;
						//TreeInsertItem.parent = List.insert(&TreeInsertItem);
						
						// 詳細の出力
						//TreeInsertItem.item.text = Text(NowThrowable);
						//List.insert(&TreeInsertItem);

						// ファイル・行出力
						invariant string[] Messages = [
							ne.file,
							to!(string)(ne.line),
							to!(string)(ne.code),
							ne.time
						];
						assert(Title.length == Messages.length);
						for(auto i=0; i < Title.length; i++) {
							Text msg = format("%s: %s", Title[i], Messages[i]);
							TreeInsertItem.item.text = msg;
							List.insert(TreeInsertItem);
						}
						/+
						TreeInsertItem.item.text = Text("File: ") ~ ne.file;
						List.insert(&TreeInsertItem);
						TreeInsertItem.item.text = Text("Line: ") ~ ne.line;
						List.insert(&TreeInsertItem);
						TreeInsertItem.item.text = Text("Code: ") ~ ne.code;
						List.insert(&TreeInsertItem);
						TreeInsertItem.item.text = Text("Time: ") ~ ne.time;
						List.insert(&TreeInsertItem);
						+/
					} else {
						// 通常例外(たぶん例外)
						////TreeInsertItem.item.text = Text(Text("Throwable: ") ~ NowThrowable.msg);
						//TreeInsertItem.parent = List.insert(&TreeInsertItem);
						//
						//// メッセージの出力
						//TreeInsertItem.item.text = Text(NowThrowable);
						//List.insert(&TreeInsertItem);

						// ファイル・行があれば出力

						if(NowThrowable.file) {
							Text file = format("%s: %s", Title[0], NowThrowable.file);
							TreeInsertItem.item.text = file;
							List.insert(TreeInsertItem);
							if(NowThrowable.line) {
								Text line = format("%s: %s", Title[1], NowThrowable.line);
								TreeInsertItem.item.text = line;
								List.insert(TreeInsertItem);
							}
						}
					}
					msgs ~= NowThrowable.msg;
					
					NowThrowable = NowThrowable.next;
				}
				//debug wl("> %s",FirstThrowable.toString);

				// 上位メッセージ設定。
				Message.text = Text(msgs.join(newline)) ~ newline ~ repeat("-", 50) ~ newline  ~ toStringInfo;
				Message.readOnly = true;
				//Message.softNewLine = true;

		
			}
			
		}
		
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			SIZE Padding=GetControlPadding();
			auto IconSize=GetIconSize(ICONSIZE.NORMAL);
			size_t SplitHeight=(Height - Padding.cy*2) / 10;
			auto CtrlHeight=GetDefaultControlHeight(CtrlFont);
			
			Warnig.move(Padding.cx, Padding.cy, IconSize, IconSize);
			Message.move(Padding.cx+IconSize+Padding.cx*2, Padding.cy, Width-IconSize-Padding.cx*2-Padding.cx, SplitHeight*4);


			Copy   .move(Padding.cx + Width/10*2 * 0, Padding.cy+SplitHeight*4+Padding.cy, Width/10*2 - Padding.cx, CtrlHeight);
			File   .move(Padding.cx + Width/10*2 * 1, Padding.cy+SplitHeight*4+Padding.cy, Width/10*2 - Padding.cx, CtrlHeight);
			UpLoad .move(Padding.cx + Width/10*2 * 2, Padding.cy+SplitHeight*4+Padding.cy, Width/10*2 - Padding.cx, CtrlHeight);
			Web    .move(Padding.cx + Width/10*2 * 3, Padding.cy+SplitHeight*4+Padding.cy, Width/10*2 - Padding.cx, CtrlHeight);
			Close  .move(Padding.cx + Width/10*2 * 4, Padding.cy+SplitHeight*4+Padding.cy, Width/10*2 - Padding.cx, CtrlHeight);

			List   .move(Padding.cx, Padding.cy+SplitHeight*4+Padding.cy*2 + CtrlHeight, Width - Padding.cx, Height-(Padding.cy+SplitHeight*4+Padding.cy*2 + CtrlHeight));
		}
		
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(MessageType == BN_CLICKED) {
				//mixin GetUserData;
				switch(Id) {
					case CTRL.WEB:
						commandWeb();
				return true;
					case CTRL.CLOSE:
						//exa.commandClose();
						destroy();
				return true;
					case CTRL.COPY:
						commandCopy();
				return true;
					case CTRL.FILE:
						commandFile();
				return true;
					case CTRL.UPLOAD:
						commandUpLoad();
				return true;
					default:
				return false;
					
				}
			} else {
				return false;
			}
		}
	}
}

void ShowExceptionDialog(Window Owner, Throwable e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
void ShowThrowables(T: Throwable)(Window Owner, T e) {
	scope Ed=new ExceptionDialog(Owner, e);
	Ed.select;
}
alias ShowThrowables ShowError;

alias ShowThrowables!(Error)     ShowErrorDialog;
alias ShowThrowables!(Exception) ShowExceptionDialog;


