﻿/**

*/
module nemuxi.gui.window.dialog.commanddialog.commanddialog;

debug import std.stdio: wl = writefln, pl = printf;
debug(commanddialog) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.items.item;
import nemuxi.file.items.items;
import nemuxi.file.items.itemfunc;
import nemuxi.negui.draw.unit;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.gui.control.titlebar;

class CommandDialog: ModelessDialog {
	private enum CTRL: ITEM_ID {
		TITLE = 1,
		INPUT,
	}
	private {
		TitleBar Titlebar;
		EditLine  Input;

		Font ControlFont;

		ItemList items;

		Application application;
	}
	this(NeWindow Owner, Application application) {
		this.application = application;
		
		GUIINFO NeGuiInfo;
		NeGuiInfo.Style        = WS_DLGFRAME | WS_SIZEBOX;
		NeGuiInfo.ExStyle      = WS_EX_DLGMODALFRAME | WS_EX_TOOLWINDOW;
		NeGuiInfo.Owner = Owner;
		
		super(&NeGuiInfo, MAINLOOP_KEY);

		/*
		items = new ItemList(application.itemBase, ShowIcon, ShowIcon ? application.AppData.exeCommandIcon: ICONSIZE.SMALL);
		*/
	}

	protected override {
		void OnActive(WA Active, bool NotSmall, HWND NextWnd) {
			super.OnActive(Active, NotSmall, NextWnd);

			Titlebar.onActive(Active);
		}
		void OnDrawItem(DRAWITEM* DrawItem) {
			switch(DrawItem.type) {
				case CONTROL_TYPE.BUTTON: // タイトルボタン
					assert(DrawItem.id == CTRL.TITLE);
					Titlebar.draw(DrawItem);
					break;
				default:
					assert(false);
			}
		}
		void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			Titlebar.onSize();

			auto InpouHeight=GetDefaultControlHeight(ControlFont);

			if(Titlebar.Position == TitleBar.POSITION.LEFT) {
				Input.move(Titlebar.getSize(), 0, Width - Titlebar.getSize(), InpouHeight);
			} else {
				assert(false);
			}
		}
		void OnDestroy() {
			delete ControlFont;
			delete items;
			
			super.OnDestroy();
		}
		void OnCreate() {
			super.OnCreate();

			ControlFont = application.AppData.exeCommandFont();
			
			Titlebar = new TitleBar(this, CTRL.TITLE);
			Titlebar.Position = TitleBar.POSITION.LEFT;
			
			Input  = new EditLine(this, CTRL.INPUT);
			Input.font = ControlFont;

			Input.text = Text("未実装");
		}
	}
}




