/**
アイテム入力特化。

すごくやっつけ、取り扱い注意。
*/
module nemuxi.gui.control.iteminput;

debug import std.stdio: wl = writefln, pl = printf;
debug(iteminput) void main() {}

import std.string;
import std.conv;
import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.negui.window.newindow;
public import nemuxi.file.items.item;
public import nemuxi.file.items.linkitem;
import nemuxi.negui.subclass;
public import nemuxi.negui.control.editbox.editbox;
public import nemuxi.gui.control.combobox;
import nemuxi.negui.control.control;
import nemuxi.negui.control.button.button;
import nemuxi.gui.control.editbox;
import nemuxi.negui.window.menu.popup;
import nemuxi.negui.control.updown.updown;
import nemuxi.negui.layout.panel.line;

/**
なんぞこれー

アイテムを持たせとく設計だったけどやめた。
*/
final class ItemAddress: Control {
	private {
		ITEM_ID Id;
		NeGui     Owner;
		Item.TYPE Type;
		
		//Item item;
		Item[] ItemList;
	}
	union {
		ItemAddress me;
		
		EditLine addr;
		EditLine uri;
		//EditLine multi;
		MultiInput multi;
		ItemComboBox link;
	}
	
	private ItemAddress MakeControl(Item.TYPE Type) {
		delete me;
		with(Item.TYPE) switch(Type) {
			case NORMAL:
				addr = new EditLine(Owner, Id);
				break;
			case URI:
				uri = new EditLine(Owner, Id);
				break;
			case MULTI:
				//multi = new EditLine(Owner, Id);
				multi = new MultiInput(Owner, Id);
				multi.setItemList = this.ItemList;
				break;
			case LINK:
				link = new ItemComboBox(Owner, Id);
				link.setItemList = this.ItemList;
				break;
			default:
				assert(false);
		}
		me.Type = Type;
		guiObject = me;
		return me;
	}
	private void SetText(in Item item) {
		if(item) with(Item.TYPE) switch(item.type) {
			case NORMAL:
				text = Text(item.address);
				break;
			case URI:
				text = Text(item.uri);
				break;
			case MULTI:
				//text = Text(join(item.multi, ","));
				multi.setItemId = item.multi;
				break;
			case LINK:
				if(item.link in link) {
					link.selectID(item.link.toText);
				} else {
					link.text = item.link.toText;
				}
				break;
			default:
				assert(false);
		} else  {
			if(Type == Item.TYPE.MULTI) {
				multi.setItemId = null;
			} else {
				text = Text.emptyText;
			}
			return;
		}
	}

	private this(in Item item) {
		MakeControl(item ? item.type: Item.TYPE.NORMAL);
		
		super(me());
		//this.guiObject = me;
		
		SetText(item);
	}
	/***/
	this(NeGui Owner, ITEM_ID Id, Item[] ItemList, in Item item) {
		this.Id        = Id;
		this.Owner     = Owner;
		this.ItemList  = ItemList;
		this(item);
	}

	override {
		const Font font() {
			if(Type == Item.TYPE.MULTI) {
				return multi.font();
			} else {
				return super.font();
			}
		}
		void font(in Font font) {
			if(Type == Item.TYPE.MULTI) {
				multi.font(font);
			} else {
				super.font(font);
			}
		}
		const Text text() {
			if(Type == Item.TYPE.MULTI) {
				return multi.text();
			} else {
				return super.text();
			}
		}
		bool text(in Text text) {
			return super.text(text);
		}
	}

	private void Change(lazy ItemAddress ItemAddressControl)
	out {
		assert(alive);
	}
	body {
		auto OldCtrl=this;

		auto ItemPoint = OldCtrl.clientPosition();
		auto ItemSize=OldCtrl.itemSize();
		auto CtrlFont = OldCtrl.font;
		
		OldCtrl.destroy();
		assert(!OldCtrl.alive);
		
		auto NewCtrl = ItemAddressControl;//new ItemAddress(OldCtrl.Owner, OldCtrl.Id, OldCtrl.ItemList, item);
		//this.item  = NewCtrl.item;
		this.hItem = NewCtrl.hItem;
		//this.ItemList = OldCtrl.ItemList;
		
		this.me = NewCtrl;
		//this.guiObject = NewCtrl.me;
		
		this.Type = NewCtrl.type;
		if(CtrlFont) {
			font = CtrlFont;
		}
		
		move(ItemPoint.x, ItemPoint.y, ItemSize.cx, ItemSize.cy);
	}

	void items(Item[] ItemList) {
		this.ItemList = ItemList;
		/+
		if(Type==Item.TYPE.LINK) {
			link.items = this.ItemList;
		}
		+/
	}

	/***/
	void setItem(in Item item) {
		//if((!this.item || !item ) || this.item != item) {
			//Change(new ItemAddress(Owner, Id, ItemList, item));
			//Change(new ItemAddress(Owner, Id, ItemList, item));
			Change(MakeControl(item ? item.type: Item.TYPE.NORMAL));
		//wl("%s",ItemList);
		//this.Type = item.type;
		SetText(item);
		//}
	}
	/+
	/// ditto
	Item getItem() {
		return item;
	}
	+/
	void changeType(Item.TYPE Type) {
		Change(MakeControl(Type));
		//wl("%s",ItemList);
		assert(this.Type == Type);
		SetText(null);
	}
	const Item.TYPE type() {
		return Type;
	}
}

/**
複数アイテム。

Bugs:
	非正常系未チェック。
*/
final class MultiInput: NeControl, IItemList {
	/+
	invariant() {
		wl("%s", NowItems.length);
	}
	+/
	private enum CTRL: ITEM_ID {
		PREV=999,
		NEXT,
		SPIN,
		COMMAND,
		ITEM_SELECT
	}
	private {
		//Push /+Prev, Next, +/Command;
		UpDown Spin;
		ItemComboBox ItemSelect;
	}
	private {
		//Item[] Itemlist;
		Item[] NowItems;
		size_t NowPos;
	}
	Item[] getItemList() {
		return ItemSelect.getItemList;
	}
	void setItemList(Item[] items) {
		ItemSelect.setItemList = items;
		nowItemList = null;
	}

	void nowItemList(Item[] items) {
		//wl("%s",items);
		//delete NowItems;
		//if(items.length)
		if(items.length) {
			auto list=ItemSelect.getItemList;
			Item[] temp;
			foreach(item; items) {
				if(item) foreach(n; list) {
					if(n.itemID == item.itemID) {
						temp ~= item;
						break;
					}
				}
			}
			items = temp;
		}
		NowItems = items;
		NowPos = 0;
		if(NowItems.length) {
			ItemSelect.selectItem = NowItems[NowPos];
		} else {
			ItemChange(0, ItemSelect.selectItem);
		}
		StateReLoad();
	}
	Item[] nowItemList() {
		return NowItems;
	}

	void setItemId(string[] Id) {
		if(!Id.length) {
			nowItemList = null;
			return;
		}
		
		auto items =new Item[Id.length];
		auto ItemList=ItemSelect.getItemList;

		for(auto i=0; i < items.length; i++) {
			foreach(j, item; ItemList) {
				if(item.itemID == Id[i]) {
					items[i] = item;
					//wl("%s", item.toString);
					break;
				}
			}
		}
		
		nowItemList = items;
	}
	const string[] getItemId() {
		string[] Ids;

		foreach(item; NowItems) {
			Ids ~= item.itemID;
		}

		return Ids;
	}
	
	this(NeGui Owner, ITEM_ID Id) {
		GUIINFO GuiInfo;
		GuiInfo.Owner = Owner;
		GuiInfo.Id    = Id;

		super(&GuiInfo);
	}
	private HFONT hFont;
	override {
		const Font font() {
			return new Font(hFont, false);
		}
		void font(in Font font) {
			hFont = font();
			auto Children=children;
			foreach(child; children) {
				child.font = font;
			}
		}
	}
	override {
		int minHeight() {
			return ItemSelect.minHeight;
		}
		int minContentHeight() {
			return ItemSelect.minContentHeight;
		}
	}
	int editerHeight() {
		return ItemSelect.editerHeight;
	}
	override {
		const Text text() {
			if(NowItems.length) {
				auto strs=new string[NowItems.length];
				for(auto i=0; i < strs.length; i++)
				if(NowItems[i])
				strs[i] = NowItems[i].itemID;
				else
				strs[i] = null;
				return format("%s", strs).toText;
			} else {
				return Text.emptyText;
			}
		}
	}
	protected override {
		void OnCreate() {
			/+
			Prev = new Push(this, CTRL.PREV);
			Next = new Push(this, CTRL.NEXT);
			//Command = new Push(this, CTRL.COMMAND);
			Prev.flat = true;
			Next.flat = true;
			//Command.flat = true;
			+/
			/+
			Prev.text = Text("<<");
			Next.text = Text(">>");
			+/
			Spin = new UpDown(this, CTRL.SPIN, UpDown.POSITION.HORIZON);
			Spin.range(0,1);
			ItemSelect = new ItemComboBox(this, CTRL.ITEM_SELECT);
			auto line=new Line(DIRECTION.HORIZON);
			line += Spin;
			line.sizeInfo(0).type = SIZEINFO.TYPE.PERCENT;
			line.sizeInfo(0).percent = 25;
			line += ItemSelect;
			line.sizeInfo(1).absolute = -1;
			layoutManager.basePanel=line;
			with(layoutManager.padding) {
				left = right = top = bottom = 0;
			}
			//startTimer(WM_APP+10, 2000);

		}
		
		version(none) void OnSize(SIZE_TYPE SizeType, int Width, int Height) {
			immutable Block=Width / 10;
			/+
			Prev.move(Block * 0, 0, Block, Height);
			Next.move(Block * 1, 0, Block, Height);
			+/
			Spin.move(0, 0, Block*2, Height);

			ItemSelect.move(Block * 2, 0, Block * 6, Height);
			//debug try
			//Command.move(Block * 8, 0, Block*2, Height);
			//catch(Object o) wl(o.toString);
		}
		bool OnPaint(Canvas canvas, ref const(RECT) Rect, bool BackReDraw) {
			canvas.fillRect(Rect, new Brush(Brush.STOCK.WHITE));
			return true;
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			/*if(Id == CTRL.PREV || Id == CTRL.NEXT) {
				if(MessageType == Button.EVENT.CLICKED) {
					//bool Prev = Id == CTRL.PREV;
					//if(NowPos != 0 && NowPos != NowItems.length-1) {
						/+
						if(Prev) {
							if(NowPos)
							NowPos--;
						} else if(NowItems.length) {
							if(NowPos != NowItems.length-1)
							NowPos++;
						}
						+/
					//}
					PositionChange(NowPos);
					return true;
				}
			} else *//+if(Id == CTRL.COMMAND) {
				if(MessageType == Button.EVENT.CLICKED) {
					enum COMMAND: COMMAND_ID {
						INSERT=1,
						ADD,
						DEL,
						ALL_DEL
					}
					scope menu=new PopUp();
					menu.insertText(COMMAND.ADD, Text("追加"));
					menu.insertSeparator();
					menu.insertText(COMMAND.DEL, Text("削除"));
					menu.insertText(COMMAND.ALL_DEL, Text("このアイテム以外削除"));
					if(auto id=menu.attach(this, Sender, PopUp.ATTACH.BOTTOM, PopUp.MESSAGE.NONE | PopUp.MESSAGE.RETURN)) {
						switch(id) {
							case COMMAND.ADD: {
								NowItems ~= ItemSelect.selectItem;
								NowPos = NowItems.length-1;
								StateReLoad();
								break;
							}
							case COMMAND.DEL: {
								if(NowItems.length != 1) {
									NowItems = NowItems[0..NowPos] ~ NowItems[NowPos+1 .. $];
								} else {
									NowItems = null;
								}
								nowItemList = NowItems;
								break;
							}
							case COMMAND.ALL_DEL: {
								nowItemList = [NowItems[NowPos]];
								break;
							}
							default:
								assert(false);
						}
					}
					return true;
				}
			} else +/if(Id == CTRL.ITEM_SELECT) {
				if(MessageType == ComboBox.EVENT.LISTCHANGE) {
		//wl("%s", ItemSelect.alive);
		//wl("%s", ItemSelect.getItemList);
					
					ItemChange(NowPos, ItemSelect.selectItem);
					return true;
				}
			}
			return false;
		}
		/+
		void OnDestroy() {
			auto Children=children;
			foreach(child; Children) {
				child.destroy();
			}
		}
		+/
		void OnContexMenu(NeGui CatchItem, int x, int y) {
			enum COMMAND: COMMAND_ID {
				INSERT=1,
				ADD,
				DEL,
				ALL_DEL
			}
			scope menu=new PopUp();
			menu.insertText(COMMAND.ADD, Text("追加"));
			menu.insertSeparator();
			menu.insertText(COMMAND.DEL, Text("削除"));
			menu.insertText(COMMAND.ALL_DEL, Text("このアイテム以外削除"));

			if(NowItems.length) {
				foreach(i, item; NowItems) {
					/+
					if(i) {
						menu.insertText(cast(COMMAND_ID)(COMMAND.max + 1 + i), item.toString.toText);
					} else {
					}
					+/
					MENUITEM MenuItems;
					MenuItems.initialize;
					auto Type = MENUITEM.TYPE.STRING;
					if(!i) {
						Type |= MENUITEM.TYPE.MENUBARBREAK;
					}
					MenuItems.type = Type;
					MenuItems.mask = MENUITEM.MASK.TYPE | MENUITEM.MASK.ID;
					MenuItems.id   = cast(COMMAND_ID)(COMMAND.max + 1 + i);
					MenuItems.text = item.toString.toText;
					menu.insert(MenuItems);
				}
				menu.radio(
					cast(COMMAND_ID)(COMMAND.max + 1),
					cast(COMMAND_ID)(COMMAND.max + 1 + NowItems.length),
					cast(COMMAND_ID)(COMMAND.max + 1 + NowPos)
				);
			}

			if(auto id=menu.attach(this, this, PopUp.ATTACH.BOTTOM, PopUp.MESSAGE.NONE | PopUp.MESSAGE.RETURN)) {
				switch(id) {
					case COMMAND.ADD: {
						NowItems ~= ItemSelect.selectItem;
						NowPos = NowItems.length-1;
						StateReLoad();
						break;
					}
					case COMMAND.DEL: {
						if(NowItems.length != 1) {
							if(NowPos == NowItems.length-1) {
								NowItems.length = NowItems.length-1;
							} else if(NowPos) {
								NowItems = NowItems[0..NowPos] ~ NowItems[NowPos+1 .. $];
							} else {
								NowItems = NowItems[1..$];
							}
						} else {
							NowItems = null;
						}
						nowItemList = NowItems;
						break;
					}
					case COMMAND.ALL_DEL: {
						nowItemList = [NowItems[NowPos]];
						break;
					}
						
					default:
						if(COMMAND.max + 1 <= id && COMMAND.max + 1 + NowItems.length) {
							//wl("%s",id - COMMAND.max - 1);
							PositionChange(id - COMMAND.max - 1);
						} else {
							assert(false);
						}
				}
			}
		}
		void OnScroll(DIRECTION Direction, SCROLL Scroll, int Position, NeGui Sender) {
			assert(Direction == DIRECTION.HORIZON);
			if(Scroll == SCROLL.THUMB_POSITION) {
				immutable TempPos=NowPos;
				
				if(Position == 0 && NowPos) {
					NowPos--;
				} else if(Position && NowPos != NowItems.length-1) {
					NowPos++;
				}
				
				if(TempPos != NowPos) {
					PositionChange(NowPos);
				}
			}
		}
		
	}
	private {
		void PositionChange(size_t Index)
		in {
			if(NowItems.length)
			assert(0 <= Index && Index < NowItems.length);
		}
		body {
			if(NowItems.length) {
				ItemSelect.selectItem = NowItems[Index];
				NowPos = Index;
			} else {
				NowPos = 0;
			}
			StateReLoad();
		}
		void ItemChange(size_t Index, Item item)
		in {
			assert(item);
		}
		body {
			//wll;
			if(NowItems.length) {
				NowItems[Index] = item;
				NowPos = Index;
			} else {
				NowItems = [item];
				NowPos = 0;
			}
		}
		void StateReLoad() {
			if(NowItems.length) {
				ItemSelect.selectItem = NowItems[NowPos];
				Spin.enable = NowItems.length != 1;
			} else {
				Spin.enable = false;
			}
		}
	}
}


