﻿/**

*/
module nemuxi.gui.control.itemcontrol;

debug import std.stdio: wl = writefln, pl = printf;
debug(itemcontrol) void main() {}

public import nemuxi.base;
public import nemuxi.gui.gui;
public import nemuxi.file.items.item;

interface IItemList {
	void setItemList(Item[] items);
	Item[] getItemList();
}
interface IItemSelect {
	void setItemList(Item[] items);
	Item[] getItemList();
	
	void selectID(in Text ItemID);
	Text selectID();
	void selectItem(in Item);
	Item selectItem();
}
alias MixInItemList TItemList;
template MixInItemList() {
	protected {
		Item[] list;
		Item[string] hash;
	}

	void setItemList(Item[] items) {
		list = items;
		clear;
			hash   = null;
		if(list) {
			foreach(item; list) {
				hash[item.itemID] = item;
				add(Text(item));
			}
			select = 0;
			enable = true;
		} else {
			enable = false;
		}
	}
	Item[] getItemList() {
		return list;
	}

	bool opIn_r(in string Id) {
		return cast(bool)(Id in hash);
	}
	
	void selectID(in Text ItemID) {
		selectItem=hash[cast(string)ItemID.toString];
		/+
		foreach(i, item; list) {
			wl(item.itemID);
			if(ItemID == item.itemID) {
				super.select = i;
				return;
			}
		}
		+/
		//throw new NemuxiGuiException(ItemID);
		/+
		if(auto n=search(ItemID, 0)) {
			select = n;
		} else {
			throw new NemuxiGuiException(ItemID);
		}
		+/
	}
	Text selectID() {
		auto n=super.select();
		if(n < list.length) {
			return Text(list[n].itemID);
		} else {
			throw new NemuxiGuiException("内部リストの整合性が合わない");
		}
	}
	void selectItem(in Item item) {
		foreach(i, value; list) {
			if(value == item) {
				super.select(i);
				return;
			}
		}
		//throw new NemuxiGuiException("みつかんない");
		super.select = -1;
	}
	Item selectItem() {
		auto n=super.select();
		if(n < list.length) {
			return list[n];
		} else {
			//throw new NemuxiGuiException("内部リストの整合性が合わない");
			return null;
		}
	}
}

