/**
機能限定コンボボックス。
*/
module nemuxi.gui.control.combobox;

debug import std.stdio: wl = writefln, pl = printf;

import std.string;
import std.conv;

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.window.window;
import nemuxi.system.application;
import nemuxi.system.raii;
import nemuxi.negui.negui;
import nemuxi.file.app;
import nemuxi.file.items.item;
import nemuxi.file.items.itemfunc;
import nemuxi.file.items.items;
import nemuxi.negui.draw.imagelist;
public import nemuxi.negui.control.combobox.combobox;
import nemuxi.gui.control.itemcontrol;
import nemuxi.negui.keyboard.keyboard;

abstract class LimitedComboBox(T): ComboBox, IInitialize {
	invariant() {
		assert(ValueString.length);
	}
	private string[] ValueString;
	
	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id, TYPE.DROPLIST);
	}
	
	abstract protected int Convert(T Value);
	abstract protected T   Convert(int Value);

	///
	override void initialize() {
		super.clear();
		super.add(Texts(ValueString));
		super.select = 0;
	}
	///
	override T select() {
		return Convert(super.select());
	}
	///
	T select(T Value) {
		return Convert(super.select(Convert(Value)));
	}
	override int select(int Value) {
		throw new NemuxiGuiException("hidden!");
	}
}

final class ShowComboBox: LimitedComboBox!(SHOW) {
	this(NeGui Owner, ITEM_ID Id) {
		super.ValueString = [
			"通常表示",
			"最小化",
			"最大化",
			"通常表示(非アクティブ)",
			"最小化(非アクティブ)"//,
			//"非指定"
		];
		super(Owner, Id);
	}
	protected override int Convert(SHOW Value) {
		switch(Value) {
			case SHOW.SHOWNORMAL:      return 0;
			case SHOW.SHOWMINIMIZED:   return 1;
			case SHOW.SHOWMAXIMIZED:   return 2;
			case SHOW.SHOWNOACTIVATE:  return 3;
			case SHOW.SHOWMINNOACTIVE: return 4;
//			case SHOW.NONE:            return 5;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", Value));
				return Convert(SHOW.SHOWNORMAL);
		}
	}
	protected override SHOW Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return SHOW.SHOWNORMAL;
			case 1: return SHOW.SHOWMINIMIZED;
			case 2: return SHOW.SHOWMAXIMIZED;
			case 3: return SHOW.SHOWNOACTIVATE;
			case 4: return SHOW.SHOWMINNOACTIVE;
//			case 5: return SHOW.NONE;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", ValueNumber));
				return Convert(0);
		}
	}
}

///
final class TypeComboBox: LimitedComboBox!(Item.TYPE) {
	this(NeGui Owner, ITEM_ID Id) {
		super.ValueString = [
			"通常",
			"URI",
			"複数",
			"リンク"
		];
		
		super(Owner, Id);
	}
	
	protected override int Convert(Item.TYPE Value) {
		switch(Value) {
			case Item.TYPE.NORMAL: return 0;
			case Item.TYPE.URI:    return 1;
			case Item.TYPE.MULTI:  return 2;
			case Item.TYPE.LINK:   return 3;
			default:
				Logger.write(format("[%s]は指定値以外のためItem.TYPE.NORMALへ", Value));
				return Convert(Item.TYPE.NORMAL);
		}
	}
	protected override Item.TYPE Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return Item.TYPE.NORMAL;
			case 1: return Item.TYPE.URI;
			case 2: return Item.TYPE.MULTI;
			case 3: return Item.TYPE.LINK;
			default:
				Logger.write(format("[%s]は指定値以外のため通常表示へ", ValueNumber));
				return Convert(0);
		}
	}
}

/***/
final class WindowPosComboBox: LimitedComboBox!(App.POSITION) {
	this(NeGui Owner, ITEM_ID Id) {
		super.ValueString = [
			"左部",
			"上部",
			"右部",
			"下部",
			"フロート"
			//"非表示"
		];
		
		super(Owner, Id);
	}
	protected override int Convert(App.POSITION Value) {
		switch(Value) {
			case App.POSITION.LEFT:   return 0;
			case App.POSITION.TOP:    return 1;
			case App.POSITION.RIGHT:  return 2;
			case App.POSITION.BOTTOM: return 3;
			case App.POSITION.FLOAT:  return 4;
			case App.POSITION.SMALL:  return 5;
			default:
				Logger.write(format("[%s]は指定値以外のためApp.POSITION.FLOATへ", Value));
				return Convert(App.POSITION.FLOAT);
		}
	}
	protected override App.POSITION Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0: return App.POSITION.LEFT;
			case 1: return App.POSITION.TOP;
			case 2: return App.POSITION.RIGHT;
			case 3: return App.POSITION.BOTTOM;
			case 4: return App.POSITION.FLOAT;
			case 5: return App.POSITION.SMALL;
			default:
				Logger.write(format("[%s]は指定値以外のため4へ", ValueNumber));
				return Convert(4);
		}
	}
}

/***/
final class KeyComboBox: LimitedComboBox!(KEY) {
	this(NeGui Owner, ITEM_ID Id) {
		foreach(Key; KEY.A .. KEY.Z + 1) {
			super.ValueString ~= to!(string)(cast(KEY)Key);
		}
		
		super(Owner, Id);
	}
	
	protected override int Convert(KEY Value) {
		switch(Value) {
			case KEY.A:
			..
			case KEY.Z:
				return Value - KEY.A;

			default:
				Logger.write(format("[%s]は指定値以外のためKEY.Aへ", Value));
				return Convert(KEY.A);
		}
	}
	protected override KEY Convert(int ValueNumber) {
		switch(ValueNumber) {
			case 0:
			..
			case 27:
			return cast(KEY)(ValueNumber + KEY.A);
			default:
				Logger.write(format("[%s]は指定値以外のため0へ", ValueNumber));
				return Convert(0);
		}
	}
}

/**
あまりのやる気の無さにやっつけ仕事。
*/
final class ItemComboBox: ComboBox, IItemList, IItemSelect {
	this(NeGui Owner, ITEM_ID Id) {
		super(Owner, Id, TYPE.DROPLIST);
	}
	mixin TItemList;
}

