﻿/**

*/
module nemuxi.file.items.items;

debug import std.stdio: wl = writefln, pl = printf;
debug(items) void main() {}

import str = std.string;
import std.utf;

import std.contracts;

import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.system.timer;
import nemuxi.file.items.item;
import nemuxi.file.items.linkitem;
import nemuxi.file.items.itemfunc;
import nemuxi.system.application;
import nemuxi.image.icon;


/**
アイテムとアイコンのリスト。
wchar-wstringを信じる。
*/
class ItemList {
	/+
	invariant() {
		if(!ShowIcon)
			assert(!icons);
	}
	+/
	private {
		Icon[string] icons;
		//bool ShowIcon;
		ICONSIZE IconSize;
		Tree tree;
	}
	private class Tree {
		Tree[wchar] Next;
		C_ITEM[]    CItems;

		~this() {
			if(Next) {
				scope Nexts=new Tree[Next.length];
				foreach(i, key; Next.keys) {
					Nexts[i] = Next[key];
				}
				Next = null;
				foreach(next; Nexts) {
					delete next;
				}
			}
			CItems = null;
		}

		/// 長！
		private bool Set(C_ITEM.TYPE Type, Item item, size_t Index, string s, out wchar Key, ref Item[] NextItems, lazy Kareha ItemBase=null)
		in {
			assert(item);
			assert(s.length);
		}
		body {
			
			auto value=toUTF32(s);
			if(value.length > Index) {
				C_ITEM CItem;
				CItem.item = item;
				CItem.type = Type;
				CItem.typeString = s;

				bool copy=true;
				foreach(ref ci; CItems) {
					if(ci == CItem) {
						copy=false;
						break;
					}
				}
				if(copy) {
					if(!(CItem.item.itemID in icons)) {
						assert(ItemBase);
						icons[CItem.item.itemID] = GetIcon(CItem.item, IconSize, ItemBase);
					}
					CItem.icon = icons[CItem.item.itemID];
					CItems ~= CItem;
				}
				if(value.length != Index) {
					NextItems ~= item;
					Key = cast(wchar)value[Index];
					enforce(Key == value[Index], new NemuxiException(Text("index-"d ~ value[Index])));
				}
				
				return true;
			}

			return false;
		}
		void set(C_ITEM.TYPE Type, Item[] ItemList, size_t Index, lazy Kareha ItemBase=null)
		in {
			assert(ItemList.length);
		}
		body {
			foreach(item; ItemList) {
				Item[] NextItems;
				C_ITEM CItem;
				wchar Key;
				wchar[] Keys;
				switch(Type) {
					case C_ITEM.TYPE.ID:
						Set(Type, item, Index, item.itemID(), Key, NextItems, ItemBase);
						break;
					case C_ITEM.TYPE.NAME:
						if(item.name().length) {
							if(item.itemID != item.name())
							Set(Type, item, Index, item.name(), Key, NextItems, ItemBase);
						}
						break;
					case C_ITEM.TYPE.TAG: {
						auto tags=item.tags();
						Keys = new wchar[tags.length];
						foreach(i, tag; tags) {
							Set(Type, item, Index, tag, Keys[i], NextItems, ItemBase);
						}
						break;
					}
					default:
						assert(false);
				}
				if(NextItems) {
					if(Keys) {
						assert(Key == Key.init);
						foreach(key; Keys) {
							if(!(key in Next)) {
								Next[key] = new Tree();
							}
							Next[key].set(Type, NextItems, Index+1, ItemBase);
						}
					} else {
						assert(Key != Key.init);
						if(!(Key in Next)) {
							Next[Key] = new Tree();
						}
						Next[Key].set(Type, NextItems, Index+1, ItemBase);
					}
				}
			}
		}
	}
	
	this(Kareha ItemBase, ICONSIZE IconSize)
	in {
		assert(ItemBase);
	}
	body {
		this.IconSize = IconSize;
		auto items=new Item[ItemBase.length];
		tree = new Tree();
		foreach(i, key; ItemBase.keys) {
			items[i] = new Item(key, ItemBase);
		}
		for(C_ITEM.TYPE i=C_ITEM.TYPE.min; i < C_ITEM.TYPE.max+1; i++) {
			tree.set(i, items, 0, ItemBase);
		}
	}
	
	~this() {
		delete tree;
		if(icons) {
			scope Icons=new Icon[icons.length];
			foreach(i, key; icons.keys) {
				Icons[i] = icons[key];
			}
			icons = null;
			foreach(icon; Icons) {
				delete icon;
			}
		}
	}

	C_ITEM[] find(wstring s, bool Exactness=false) {
		Tree Loop=tree;
		foreach(i, c; s) {
			if(s[i] in Loop.Next) {
				if(s.length-1 > i) {
					Loop = Loop.Next[s[i]];
					continue;
				} else if(i > 0 && s.length-1 == i) {
					return Loop.CItems;
				}
				
				return Loop.Next[s[i]].CItems;
			}
		}
		return tree.CItems;
	}
	C_ITEM[] find(wstring s, C_ITEM.TYPE Type) {
		auto CItems=this.find(s);
		
		if(!CItems.length) {
			return null;
		}
		
		C_ITEM[] List;
		foreach(ref CItem; CItems) {
			if(CItem.type == Type) {
				List ~= CItem;
			}
		}

		return List;
	}
	bool isIcon(string key) {
		return cast(bool)(key in icons);
	}
	Icon icon(string key) {
		assert(key.length);
		return icons[key];
	}
	ICONSIZE iconSize() {
		return IconSize;
	}
	int iconPx() {
		return GetIconSize(this.iconSize());
	}

	//C_ITEM
	
	debug(items) unittest {
		auto a=MakeApplication();
		//auto show= a.AppData.exeCommandIconUse;
		scope dt=new DTimer;
		//foreach(n; 1..300){
			scope l=new ItemList(a.itemBase(), a.AppData.exeCommandIcon());
			foreach(c; l.find("")){
				wl("%s",c);
			}
		//}
	};
}

