﻿/**
ランチャ的なアイテム。

時期を見てからmixinの予定。
*/
module nemuxi.file.items.item;

debug import std.stdio: wl = writefln, pl = printf;

debug(item) void main() {}

import std.file;
import std.string;
//public import std.date: Date;
import std.conv;
import std.contracts;
version(unittest) static import std.regexp;
// import kareki.kareki;

import nemuxi.base;
import nemuxi.system.timer;
import nemuxi.file.file;
import nemuxi.file.data;
import nemuxi.file.app;
import nemuxi.negui.negui;
import nemuxi.image.icon;
import nemuxi.utility.convert.env;
public import nemuxi.file.items.itemfunc;

/+
class NemuxiItemException: NemuxiException {
	mixin NemuxiExceptionClass;
}
+/

/**
とりあえず登録アイテムにアクセスするにはこいつを使う。

TYPE.LINKはいろいろ存在しない可能性あり。
*/
class Item: Data {
	invariant() {
		assert(ItemID.length);
		assert(isID(ItemID), ItemID);
		//assert(ItemIdType(ItemID) == ITEM_ID_TYPE.ITEM);
		
		assert(ks[ITEM.NAME]);
		assert(ks[ITEM.TYPE].have());
		auto Type=cast(TYPE)ks[ITEM.TYPE].get!(Integer);
		if(cast(TYPE)ks[ITEM.TYPE].get!(Integer) != TYPE.MULTI) {
			assert(ks[ITEM.ADDRESS].type() == HAGATA.String);
		} else {
			assert(ks[ITEM.ADDRESS].type() == HAGATA.TSV_String, ItemID);
		}
		if(Type != TYPE.LINK) {
			assert(ks[ITEM.WORKFOLDER].type() == HAGATA.String);
			assert(ks[ITEM.OPTION].type() == HAGATA.String);
			assert(ks[ITEM.ICON_ADDRESS].type() == HAGATA.String);
			//assert(ks[ITEM.ICON_INDEX].type() == HAGATA.Integer);
			assert(ks[ITEM.ICON_INDEX].get!(Integer) >= 0);
			assert(ks[ITEM.SHOW].type() == HAGATA.Integer);
			assert(SHOW.min <= ks[ITEM.SHOW].get!(Integer) && ks[ITEM.SHOW].get!(Integer) <= SHOW.max);
			assert(ks[ITEM.TAGS].type() == HAGATA.TSV_String);
			assert(ks[ITEM.KEY].type() == HAGATA.Integer);
			assert(ks[ITEM.HISTORY_WORKFOLDERS].type() == HAGATA.TSV_String);
			assert(ks[ITEM.HISTORY_OPTIONS].type() == HAGATA.TSV_String);
			assert(KEY.A <= ks[ITEM.KEY].unSafe!(Integer) && ks[ITEM.KEY].unSafe!(Integer) <= KEY.Z);
		}
		assert(ks[ITEM.HISTORY_REGIST].type() == HAGATA.String);
		assert(ks[ITEM.HISTORY_LAST].type() == HAGATA.String);
		assert(ks[ITEM.HISTORY_USE].type() == HAGATA.Integer);
	}

	private static enum ITEM {
		NAME,
		TYPE,
		ADDRESS,
		WORKFOLDER,
		OPTION,
		ICON_ADDRESS,
		ICON_INDEX,
		SHOW,
		TAGS,
		KEY,
		HISTORY_WORKFOLDERS,
		HISTORY_OPTIONS,
		HISTORY_REGIST,
		HISTORY_LAST,
		HISTORY_USE,
	}
	/+
	private static struct TREE: string {
		TYPE                = "Type",
		ADDRESS             = "Address",
		WORKFOLDER          = "WorkFolder",
		OPTION              = "Option",
		ICON                = "Icon",
		ICON_ADDRESS        = "Address",
		ICON_INDEX          = "Index",
		SHOW                = "Show",
		TAGS                = "Tags",
		HISTORY             = "History",
		HISTORY_WORKFOLDERS = "WorkFolders",
		HISTORY_OPTIONS     = "Options",
		HISTORY_REGIST      = "Regist",
		HISTORY_LAST        = "Last",
		HISTORY_USE         = "Use",
	}
	+/
	static invariant struct TREE {
		string TYPE                = "Type";
		string ADDRESS             = "Address";
		string WORKFOLDER          = "WorkFolder";
		string OPTION              = "Option";
		string ICON                = "Icon";
		string ICON_ADDRESS        = "Address";
		string ICON_INDEX          = "Index";
		string SHOW                = "Show";
		string TAGS                = "Tags";
		string KEY                 = "Key";
		string HISTORY             = "History";
		string HISTORY_WORKFOLDERS = "WorkFolders";
		string HISTORY_OPTIONS     = "Options";
		string HISTORY_REGIST      = "Regist";
		string HISTORY_LAST        = "Last";
		string HISTORY_USE         = "Use";
	}
	/// アイテムの種類。
	static enum TYPE {
		NORMAL, /// 通常アイテム。
		URI,    /// アイテムはURI(なんでもあり)。
		MULTI,  /// 複数アイテム。
		LINK,   /// アイテムへのリンク。
	}
	/// タイプに関連する文字列の取得。
	static string typeToString(TYPE Type) {
		switch(Type) {
			case TYPE.NORMAL: return "n";//Lng.itemType()[0];
			case TYPE.URI:    return "u";//Lng.itemType()[1];
			case TYPE.MULTI:  return "m";//Lng.itemType()[2];
			case TYPE.LINK:   return "l";//Lng.itemType()[3];
			default:          assert(false);
		}
	}
	
	static {
		immutable NOID = " .,\t";
		bool isID(dchar c) {
			return !Convert.isNameChar(c)
			&& c != NOID[0]//' '
			&& c != NOID[1]//'.'
			&& c != NOID[2]//','
			&& c != NOID[3];//'\t';
		}
		bool isID(string Id) {
			return Id.length
			&& indexOf(Id, NOID[0]) == -1  //indexOf(Id, ' ') == -1
			&& indexOf(Id, NOID[1]) == -1  //indexOf(Id, '.') == -1
			&& indexOf(Id, NOID[2]) == -1  //indexOf(Id, ',') == -1
			&& indexOf(Id, NOID[3]) == -1 //indexOf(Id, '\t') == -1
			&& Convert.isTree(Id);
		}
	}
	
	private string ItemID;
	
	/**
	コンストラクタ。
	
	ツリーは完全構築される。
	
	Params:
		ItemID = アイテム自体の識別名。
		         Items/[ItemID]

		ItemBase = 基底ツリー。
	*/
	this(in string ItemID, Kareha ItemBase)
	in {
		assert(ItemID);
		assert(ItemBase);
	}
	body {
		enforce(isID(ItemID), new ItemException(ItemID));
		this.ItemID = ItemID;
		
		ks.length = ITEM.max + 1;

		auto item=ItemBase[ItemID];

		// そのまんま
		ks[ITEM.NAME] = item;

		// アイテム形式
		/+
		if(item(TREE.TYPE)) {
			ks[ITEM.TYPE] = item[TREE.TYPE];
		} else {
			item.plus(TREE.TYPE, new Kareha(TYPE.NORMAL));
			ks[ITEM.TYPE] = item[TREE.TYPE];
		}
		if(
			!ks[ITEM.TYPE].have()
			|| ks[ITEM.TYPE].type() != HAGATA.Integer
			|| (ks[ITEM.TYPE].get!(Integer) < TYPE.min || ks[ITEM.TYPE].unSafe!(Integer) > TYPE.max)
		) {
			ks[ITEM.TYPE] = TYPE.NORMAL;
		}
		+/
		/+
		Regist!(TYPE.NORMAL)(
			item,
			TREE.TYPE,
			ITEM.TYPE,
			!ks[ITEM.TYPE].have()
			|| ks[ITEM.TYPE].type() != HAGATA.Integer
			|| (ks[ITEM.TYPE].get!(Integer) < TYPE.min || ks[ITEM.TYPE].unSafe!(Integer) > TYPE.max)
		);
		+/
		RegistEx!(TYPE.NORMAL)(
			item,
			TREE.TYPE,
			ITEM.TYPE,
			ks[ITEM.TYPE].have()
			&& ks[ITEM.TYPE].type() == HAGATA.Integer
			&& (TYPE.min <= ks[ITEM.TYPE].get!(Integer) && ks[ITEM.TYPE].unSafe!(Integer) <= TYPE.max)
		);
		invariant auto Type=cast(TYPE)ks[ITEM.TYPE].unSafe!(Integer);
		invariant auto NotLink = Type != TYPE.LINK;

		// アドレス
		if(!(TREE.ADDRESS in item)) {
			item.plus(TREE.ADDRESS, Type != TYPE.MULTI ? super.EmptyString(): super.EmptyTsvString());
			if(item[TREE.ADDRESS].type() == HAGATA.String) {
				item[TREE.ADDRESS] = string.init;
			} else {
				item[TREE.ADDRESS] = (string[]).init;
			}
		}
		ks[ITEM.ADDRESS] = item[TREE.ADDRESS];
		if(
			!ks[ITEM.ADDRESS].have()
			|| !(ks[ITEM.ADDRESS].type() == HAGATA.String || ks[ITEM.ADDRESS].type() == HAGATA.TSV_String)
		) {
			ks[ITEM.ADDRESS] = string.init;
		}

		// アイコン＠履歴＠ブロック外でも使うので先にやっておく
		if(!(TREE.ICON in item)) {
			item.plus(TREE.ICON, super.Empty());
		}
		if(item[TREE.ICON].have()) {
			item[TREE.ICON].fileKill();
		}
		auto icon=item[TREE.ICON];
		
		if(!(TREE.HISTORY in item)) {
			item.plus(TREE.HISTORY, super.Empty());
		}
		if(item[TREE.HISTORY].have()) {
			item[TREE.HISTORY].fileKill();
		}
		auto history=item[TREE.HISTORY];

		//-------------------------------------------------------------

		/+
		// 作業フォルダ
		if(!item(TREE.WORKFOLDER)) {
			item.plus(TREE.WORKFOLDER, super.EmptyString());
		}
		ks[ITEM.WORKFOLDER] = item[TREE.WORKFOLDER];
		if(
			!ks[ITEM.WORKFOLDER].have()
			|| ks[ITEM.WORKFOLDER].type() != HAGATA.String
		) {
			ks[ITEM.WORKFOLDER] = string.init;
		}
		+/
		/+
		Regist!(string.init)(
			item,
			TREE.WORKFOLDER,
			ITEM.WORKFOLDER,
			!ks[ITEM.WORKFOLDER].have()
			|| ks[ITEM.WORKFOLDER].type() != HAGATA.String,
			NotLink
		);
		+/
		RegistEx!(string.init)(
			item,
			TREE.WORKFOLDER,
			ITEM.WORKFOLDER,
			ks[ITEM.WORKFOLDER].have()
			&& ks[ITEM.WORKFOLDER].type() == HAGATA.String,
			NotLink
		);
	
		// オプション
		/+
		if(!item(TREE.OPTION)) {
			item.plus(TREE.OPTION, super.EmptyString());
		}
		ks[ITEM.OPTION] = item[TREE.OPTION];
		if(
			!ks[ITEM.OPTION].have()
			|| ks[ITEM.OPTION].type() != HAGATA.String
		) {
			ks[ITEM.OPTION] = string.init;
		}
		+/
		/+
		Regist!(string.init)(
			item,
			TREE.OPTION,
			ITEM.OPTION,
			!ks[ITEM.OPTION].have()
			|| ks[ITEM.OPTION].type() != HAGATA.String,
			NotLink
		);
		+/
		RegistEx!(string.init)(
			item,
			TREE.OPTION,
			ITEM.OPTION,
			ks[ITEM.OPTION].have()
			&& ks[ITEM.OPTION].type() == HAGATA.String,
			NotLink
		);
	

		// アドレス
		/+
		if(!icon(TREE.ICON_ADDRESS)) {
			icon.plus(TREE.ICON_ADDRESS, super.EmptyString());
		}
		ks[ITEM.ICON_ADDRESS] = icon[TREE.ICON_ADDRESS];
		if(
			!ks[ITEM.ICON_ADDRESS].have()
			|| ks[ITEM.ICON_ADDRESS].type() != HAGATA.String
		) {
			icon[TREE.ICON_ADDRESS] = string.init;
		}
		+/
		/+
		Regist!(string.init)(
			icon,
			TREE.ICON_ADDRESS,
			ITEM.ICON_ADDRESS,
			!ks[ITEM.ICON_ADDRESS].have()
			|| ks[ITEM.ICON_ADDRESS].type() != HAGATA.String,
			NotLink
		);
		+/
		RegistEx!(string.init)(
			icon,
			TREE.ICON_ADDRESS,
			ITEM.ICON_ADDRESS,
			ks[ITEM.ICON_ADDRESS].have()
			&& ks[ITEM.ICON_ADDRESS].type() == HAGATA.String,
			NotLink
		);
		// インデックス
		/+
		if(!icon(TREE.ICON_INDEX)) {
			icon.plus(TREE.ICON_INDEX, super.EmptyInteger());
		}
		ks[ITEM.ICON_INDEX] = icon[TREE.ICON_INDEX];
		if(
			!ks[ITEM.ICON_INDEX].have()
			|| ks[ITEM.ICON_INDEX].type() != HAGATA.Integer
			|| ks[ITEM.ICON_INDEX].type() != HAGATA.Integer
		) {
			ks[ITEM.ICON_INDEX] = 0;
		}
		+/
		/+
		Regist!(0)(
			icon,
			TREE.ICON_INDEX,
			ITEM.ICON_INDEX,
			!ks[ITEM.ICON_INDEX].have()
			|| ks[ITEM.ICON_INDEX].get!(Integer) < 0,
			NotLink
		);
		+/
		RegistEx!(0)(
			icon,
			TREE.ICON_INDEX,
			ITEM.ICON_INDEX,
			ks[ITEM.ICON_INDEX].have()
			&& ks[ITEM.ICON_INDEX].get!(Integer) >= 0,
			NotLink
		);

		// 表示方法
		/+
		if(!item(TREE.SHOW)) {
			item.plus(TREE.SHOW, super.EmptyInteger(SHOW.SHOW));
		}
		ks[ITEM.SHOW] = item[TREE.SHOW];
		if(
			!ks[ITEM.SHOW].have()
			|| ks[ITEM.SHOW].type() != HAGATA.Integer
			|| (ks[ITEM.SHOW].get!(Integer) < SHOW.min || ks[ITEM.SHOW].get!(Integer) > SHOW.max)
		) {
			ks[ITEM.SHOW] = cast(Integer)SHOW.SHOW;
		}
		+/
		/+
		Regist!(cast(Integer)NeGui.SW.SHOW)(
			item,
			TREE.SHOW,
			ITEM.SHOW,
			!ks[ITEM.SHOW].have()
			|| ks[ITEM.SHOW].type() != HAGATA.Integer
			|| (ks[ITEM.SHOW].get!(Integer) < NeGui.SW.min || ks[ITEM.SHOW].get!(Integer) > NeGui.SW.max),
			NotLink
		);
		+/
		RegistEx!(cast(Integer)SHOW.SHOWNORMAL)(
			item,
			TREE.SHOW,
			ITEM.SHOW,
			ks[ITEM.SHOW].have()
			&& SHOW.min <= ks[ITEM.SHOW].get!(Integer) && ks[ITEM.SHOW].get!(Integer) <= SHOW.max,
			NotLink
		);

		// タグ
		/+
		if(!item(TREE.TAGS)) {
			item.plus(TREE.TAGS, super.EmptyTsvString());
		}
		ks[ITEM.TAGS] = item[TREE.TAGS];
		if(
			!ks[ITEM.TAGS].have()
			|| ks[ITEM.TAGS].type() != HAGATA.TSV_String
		) {
			ks[ITEM.TAGS] = (string[]).init;
		}
		+/
		/+
		Regist!((string[]).init)(
			item,
			TREE.TAGS,
			ITEM.TAGS,
			!ks[ITEM.TAGS].have()
			|| ks[ITEM.TAGS].type() != HAGATA.TSV_String,
			true//NotLink
		);
		+/
		RegistEx!((string[]).init)(
			item,
			TREE.TAGS,
			ITEM.TAGS,
			ks[ITEM.TAGS].have()
			&& ks[ITEM.TAGS].type() == HAGATA.TSV_String,
			true//NotLink
		);

		// 試験＠キー
		/+
		Regist!(Integer.min)(
			item,
			TREE.KEY,
			ITEM.KEY,
			!ks[ITEM.KEY].have()
			|| ks[ITEM.KEY].type() != HAGATA.Integer
			|| ks[ITEM.KEY].get!(Integer) != Integer.min,
			true//NotLink
		);
		+/
		RegistEx!(KEY.A)(
			item,
			TREE.KEY,
			ITEM.KEY,
			ks[ITEM.KEY].have()
			&& ks[ITEM.KEY].type() == HAGATA.Integer
			&& KEY.A <= ks[ITEM.KEY].unSafe!(Integer) && ks[ITEM.KEY].unSafe!(Integer) <= KEY.Z,
			true//NotLink
		);


		// 作業フォルダ
		/+
		if(!history(TREE.HISTORY_WORKFOLDERS)) {
			history.plus(TREE.HISTORY_WORKFOLDERS, super.EmptyTsvString());
		}
		ks[ITEM.HISTORY_WORKFOLDERS] = history[TREE.HISTORY_WORKFOLDERS];
		if(
			!ks[ITEM.HISTORY_WORKFOLDERS].have()
			|| ks[ITEM.HISTORY_WORKFOLDERS].type() != HAGATA.TSV_String
		) {
			history[TREE.HISTORY_WORKFOLDERS] = (string[]).init;
		}
		+/
		/+
		Regist!((string[]).init)(
			history,
			TREE.HISTORY_WORKFOLDERS,
			ITEM.HISTORY_WORKFOLDERS,
			!ks[ITEM.HISTORY_WORKFOLDERS].have()
			|| ks[ITEM.HISTORY_WORKFOLDERS].type() != HAGATA.TSV_String,
			NotLink
		);
		+/
		RegistEx!((string[]).init)(
			history,
			TREE.HISTORY_WORKFOLDERS,
			ITEM.HISTORY_WORKFOLDERS,
			ks[ITEM.HISTORY_WORKFOLDERS].have()
			&& ks[ITEM.HISTORY_WORKFOLDERS].type() == HAGATA.TSV_String
		);
		
		// オプション
		/+
		if(!history(TREE.HISTORY_OPTIONS)) {
			history.plus(TREE.HISTORY_OPTIONS, super.EmptyTsvString());
		}
		ks[ITEM.HISTORY_OPTIONS] = history[TREE.HISTORY_OPTIONS];
		if(
			!ks[ITEM.HISTORY_OPTIONS].have()
			|| ks[ITEM.HISTORY_OPTIONS].type() != HAGATA.TSV_String
		) {
			ks[ITEM.HISTORY_OPTIONS] = (string[]).init;
		}
		+/
		/+
		Regist!((string[]).init)(
			history,
			TREE.HISTORY_OPTIONS,
			ITEM.HISTORY_OPTIONS,
			!ks[ITEM.HISTORY_OPTIONS].have()
			|| ks[ITEM.HISTORY_OPTIONS].type() != HAGATA.TSV_String,
			NotLink
		);
		+/
		RegistEx!((string[]).init)(
			history,
			TREE.HISTORY_OPTIONS,
			ITEM.HISTORY_OPTIONS,
			ks[ITEM.HISTORY_OPTIONS].have()
			&& ks[ITEM.HISTORY_OPTIONS].type() == HAGATA.TSV_String
		);
		
		//-------------------------------------------------------------
		
		// 登録日時
		/+
		if(!history(TREE.HISTORY_REGIST)) {
			history.plus(TREE.HISTORY_REGIST, super.EmptyString());
		}
		ks[ITEM.HISTORY_REGIST] = history[TREE.HISTORY_REGIST];
		if(
			!ks[ITEM.HISTORY_REGIST].have()
			|| ks[ITEM.HISTORY_REGIST].type() != HAGATA.String
		) {
			ks[ITEM.HISTORY_REGIST] = string.init;
		}
		+/
		/+
		Regist!(string.init)(
			history,
			TREE.HISTORY_REGIST,
			ITEM.HISTORY_REGIST,
			!ks[ITEM.HISTORY_REGIST].have()
			|| ks[ITEM.HISTORY_REGIST].type() != HAGATA.String
		);
		+/
		RegistEx!(string.init)(
			history,
			TREE.HISTORY_REGIST,
			ITEM.HISTORY_REGIST,
			ks[ITEM.HISTORY_REGIST].have()
			&& ks[ITEM.HISTORY_REGIST].type() == HAGATA.String
		);
		// 最終使用日
		/+
		if(!history(TREE.HISTORY_LAST)) {
			history.plus(TREE.HISTORY_LAST, super.EmptyString());
		}
		ks[ITEM.HISTORY_LAST] = history[TREE.HISTORY_LAST];
		if(
			!ks[ITEM.HISTORY_LAST].have()
			|| ks[ITEM.HISTORY_LAST].type() != HAGATA.String
		) {
			ks[ITEM.HISTORY_LAST] = string.init;
		}
		+/
		/+
		Regist!(string.init)(
			history,
			TREE.HISTORY_LAST,
			ITEM.HISTORY_LAST,
			!ks[ITEM.HISTORY_LAST].have()
			|| ks[ITEM.HISTORY_LAST].type() != HAGATA.String
		);
		+/
		RegistEx!(string.init)(
			history,
			TREE.HISTORY_LAST,
			ITEM.HISTORY_LAST,
			ks[ITEM.HISTORY_LAST].have()
			&& ks[ITEM.HISTORY_LAST].type() == HAGATA.String
		);
		// 使用回数
		/+
		if(!history(TREE.HISTORY_USE)) {
			history.plus(TREE.HISTORY_USE, super.EmptyString());
		}
		ks[ITEM.HISTORY_USE] = history[TREE.HISTORY_USE];
		if(
			!ks[ITEM.HISTORY_USE].have()
			|| ks[ITEM.HISTORY_USE].type() != HAGATA.Integer
			|| ks[ITEM.HISTORY_USE].unSafe!(Integer) < 0
		) {
			ks[ITEM.HISTORY_USE] = 0;
		}
		+/
		/+
		Regist!(0)(
			history,
			TREE.HISTORY_USE,
			ITEM.HISTORY_USE,
			!ks[ITEM.HISTORY_USE].have()
			|| ks[ITEM.HISTORY_USE].type() != HAGATA.Integer
			|| ks[ITEM.HISTORY_USE].unSafe!(Integer) < 0
		);
		+/
		RegistEx!(0)(
			history,
			TREE.HISTORY_USE,
			ITEM.HISTORY_USE,
			ks[ITEM.HISTORY_USE].have()
			&& ks[ITEM.HISTORY_USE].type() == HAGATA.Integer
			&& ks[ITEM.HISTORY_USE].unSafe!(Integer) >= 0
		);
	}

	/**
	アイテムの種類を取得。

	Return:
		現在のアイテムの種類を返す。
	*/
	const TYPE type() {
		return cast(TYPE)ks[ITEM.TYPE].unSafe!(Integer);
	}

	/**
	*/
	const string itemID() {
		return ItemID;
	}

	override string toString() {
		if(name.length) {
			return format("%s(%s)[%s]", name, itemID, typeToString(type));
		} else {
			return format("(%s)[%s]", itemID, typeToString(type));
		}
	}

	/**
	*/
	const string name() {
		return ks[ITEM.NAME].unSafe!(string);
	}
	void name(in string Name) {
		ks[ITEM.NAME] = Name;
	}

	/**
	アイテムのコメントを取得。

	Return:
		アイテムに設定されているコメント。
	*/
	const string information() {
		return ks[ITEM.NAME].comment;
	}
	void information(in string Information) {
		ks[ITEM.NAME].comment = Information;
	}

	/**
	ファイルアドレスを取得。

	TYPE.NORMALであることが強制される。

	Return:
		ファイルアドレス。
	*/
	const string address() {
		assert(this.type() == TYPE.NORMAL);

		return ks[ITEM.ADDRESS].unSafe!(string);
	}
	void address(string Address) {
		ks[ITEM.TYPE]    = TYPE.NORMAL;
		ks[ITEM.ADDRESS] = Address;
	}
	/**
	登録アイテムがURIの場合にURIを取得。

	TYPE.URIであることが強制される。
	
	Return:
		URI。
	*/
	const string uri() {
		assert(this.type() == TYPE.URI);
		
		return ks[ITEM.ADDRESS].unSafe!(string);
	}
	void uri(string URI) {
		ks[ITEM.TYPE]    = TYPE.URI;
		ks[ITEM.ADDRESS] = URI;
	}
	/**
	*/
	const string[] multi() {
		assert(this.type() == TYPE.MULTI);
		
		return ks[ITEM.ADDRESS].get!(string[]);
	}
	void multi(string[] Multi) {
		ks[ITEM.TYPE]    = TYPE.MULTI;
		ks[ITEM.ADDRESS] = Multi;
	}

	/**
	*/
	const string link() {
		assert(this.type() == TYPE.LINK, ItemID);
		
		return ks[ITEM.ADDRESS].unSafe!(string);
	}
	void link(string Link) {
		ks[ITEM.TYPE]    = TYPE.LINK;
		ks[ITEM.ADDRESS] = Link;
	}

	/**
	作業フォルダ取得。

	Return:
		作業フォルダ。
	*/
	const string workFolder() {
		return ks[ITEM.WORKFOLDER].unSafe!(string);
	}
	void workFolder(string Path) {
		if(ks[ITEM.WORKFOLDER]) {
			ks[ITEM.WORKFOLDER] = Path;
		} else {
			ks[ITEM.NAME].plus(TREE.WORKFOLDER, new Kareha(Path));
			ks[ITEM.WORKFOLDER] = ks[ITEM.NAME][TREE.WORKFOLDER];
		}
	}
	const bool haveWorkFolder() {
		return ks[ITEM.WORKFOLDER] !is null;
	}

	/**
	オプション取得。

	Return:
		オプション。
	*/
	const string option() {
		return ks[ITEM.OPTION].unSafe!(string);
	}
	void option(string Option) {
		if(ks[ITEM.OPTION]) {
			ks[ITEM.OPTION] = Option;
		} else {
			ks[ITEM.NAME].plus(TREE.OPTION, new Kareha(Option));
			ks[ITEM.OPTION] = ks[ITEM.NAME][TREE.OPTION];
		}
	}
	const bool haveOption() {
		return ks[ITEM.OPTION] !is null;
	}

	/**
	アイコンアドレス取得。

	Return:
		アイコンアドレス。
	*/
	const string iconAddress() {
		return ks[ITEM.ICON_ADDRESS].unSafe!(string);
	}
	void iconAddress(string Path) {
		if(ks[ITEM.ICON_ADDRESS]) {
			ks[ITEM.ICON_ADDRESS] = Path;
		} else {
			ks[ITEM.NAME].plus(TREE.ICON, Empty);
			ks[ITEM.NAME][TREE.ICON].plus(TREE.ICON_ADDRESS, new Kareha(Path));
			ks[ITEM.ICON_ADDRESS] = ks[ITEM.NAME][TREE.ICON][TREE.ICON_ADDRESS];
		}
		//ks[ITEM.ICON_ADDRESS] = Path;
	}
	const bool haveIconAddress() {
		return ks[ITEM.ICON_ADDRESS] !is null;
	}
	
	/**
	アイコンインデックス取得。

	Return:
		アイコンインデックス。
	*/
	const Integer iconIndex() {
		return ks[ITEM.ICON_INDEX].unSafe!(Integer);
	}
	void iconIndex(Integer Index) {
		if(ks[ITEM.ICON_INDEX]) {
			ks[ITEM.ICON_INDEX] = Index;
		} else {
			ks[ITEM.NAME].plus(TREE.ICON, Empty);
			ks[ITEM.NAME][TREE.ICON].plus(TREE.ICON_INDEX, new Kareha(Index));
			ks[ITEM.ICON_INDEX] = ks[ITEM.NAME][TREE.ICON][TREE.ICON_INDEX];
		}
		//ks[ITEM.ICON_INDEX] = Index;
	}
	const bool haveIconIndex() {
		return ks[ITEM.ICON_INDEX] !is null;
	}

	/**
	表示方法取得。

	Return:
		表示方法。
	*/
	const SHOW show() {
		//assert(this.type() != TYPE.MULTI);
		return cast(SHOW)ks[ITEM.SHOW].unSafe!(Integer);
	}
	void show(SHOW Show) {
		//ks[ITEM.SHOW] = Show;
		if(ks[ITEM.SHOW]) {
			ks[ITEM.SHOW] = Show;
		} else {
			ks[ITEM.NAME].plus(TREE.SHOW, new Kareha(Show));
			ks[ITEM.SHOW] = ks[ITEM.NAME][TREE.SHOW];
		}
	}
	const bool haveShow() {
		return ks[ITEM.SHOW] !is null;
	}
	
	/**
	タグ取得。

	Return:
		タグ。
	*/
	const string[] tags() {
		return ks[ITEM.TAGS].unSafe!(string[]);
	}
	void tags(string[] Tags) {
		ks[ITEM.TAGS] = Tags;
	}

	/**
	*/
	const KEY key() {
		return cast(KEY)ks[ITEM.KEY].unSafe!(Integer);
	}
	void key(KEY Key) {
		ks[ITEM.KEY] = cast(Integer)Key;
	}

	/**
	作業フォルダ履歴取得。

	Return:
		作業フォルダ履歴。
	*/
	const string[] historyWorkFolders() {
		//assert(this.type() != TYPE.MULTI);
		return ks[ITEM.HISTORY_WORKFOLDERS].unSafe!(string[]);
	}
	void historyWorkFolders(string[] Paths) {
		ks[ITEM.HISTORY_WORKFOLDERS] = Paths;
	}
	const bool haveHistoryWorkFolders() {
		return ks[ITEM.HISTORY_WORKFOLDERS] !is null;
	}

	/**
	オプション履歴取得。

	Return:
		オプション履歴。
	*/
	const string[] historyOptions() {
		// assert(this.type() != TYPE.MULTI);
		return ks[ITEM.HISTORY_OPTIONS].unSafe!(string[]);
	}
	void historyOptions(string[] Options) {
		return ks[ITEM.HISTORY_OPTIONS] = Options;
	}
	const bool haveHistoryOptions() {
		return ks[ITEM.HISTORY_OPTIONS] !is null;
	}
	
	/**
	登録日時取得。

	Return:
		登録日時。
	*/
	/+
	const string historyResist() {
		return ks[ITEM.HISTORY_REGIST].unSafe!(string);
	}
	void historyResist(string date) {
		ks[ITEM.HISTORY_REGIST] = date;
	}
	+/
	const DateTime historyResist() {
		try {
			return new ItemDateTime(ks[ITEM.HISTORY_REGIST].unSafe!(string));
		} catch(ItemException e) {
			Logger.write(e);
			return null;
		}
	}
	void historyResist(DateTime date) {
		ks[ITEM.HISTORY_REGIST] = date.toString();
	}
	
	/**
	最終使用日時取得。

	Return:
		最終使用日時。
	*/
	const DateTime historyLast() {
		try {
			return new ItemDateTime(ks[ITEM.HISTORY_LAST].unSafe!(string));
		} catch(ItemException e) {
			Logger.write(e);
			return null;
		}
	}
	void historyLast(DateTime date) {
		ks[ITEM.HISTORY_LAST] = date.toString();
	}

	/**
	使用回数取得。

	Return:
		使用回数。
	*/
	const Integer historyUse() {
		return ks[ITEM.HISTORY_USE].unSafe!(Integer);
	}
	/**
	使用回数設定。

	Params:
		value = 設定値。
		        0未満ならInteger.initに設定される。
	*/
	void historyUse(Integer value) {
		if(value < 0)
			value = Integer.init;
		ks[ITEM.HISTORY_USE] = value;
	}
	
	override bool opEquals(Object obj) {
		auto item=cast(Item)obj;
		return ItemID == item.ItemID;
	}

	debug const Text toText() {
		string[] s;
		for(auto i=ITEM.min; i <= ITEM.max; i++) {
			s ~= format("%20s > %s", to!(string)(cast(ITEM)i), ks[i]);
		}
		return join(s, "\n").toText;
	}

}

debug(item) unittest {
	Item item;

	auto aki=newItem();
	
	item=new Item("ie", aki[`Items`]);
	item=new Item("test", aki[`Items`]);
	//assert(cast(SHOW)aki[`Items/test`]["Show"].unSafe!(Integer) == SHOW.SHOW);
	assert(aki[`Items/test`]["Address"].unSafe!(string) == "");
	assert(aki[`Items/test`]["Tags"].unSafe!(string[]) == null);
	item=new Item("link", aki[`Items`]);
	//wl("%s",(new Item("ie", aki[`Items`])).toText);
}
debug AkiDocument newItem() {
	return new AkiDocument(`
;The
;Internet
;Explorer
Items/ie\Internet Explorer
Items/ie/Type:0
Items/ie/Address\C:\\Program Files\\Internet Explorer\\iexplore.exe
Items/ie/WorkFolder\C:\\Program Files\\Internet Explorer\\
Items/ie/Option\\e
Items/ie/Icon/Address\C:\\Program Files\\Internet Explorer\\iexplore.exe
Items/ie/Icon/Index:0
Items/ie/Show:5
Items/ie/Tags$\e
Items/ie/History/WorkFolders$\e
Items/ie/History/Options$\e
Items/ie/History/Regist\2007/01/01
Items/ie/History/Last\2008/01/01
Items/ie/History/Use:0

;Baka!
Items/test\Test!!
Items/test/Address/DUMMY\あああ
Items/test/Tags/DUMMY\あああ

;uri
Items/URI\ゆーあーるあい
Items/URI/Type:1
Items/URI/Address\\"C:\\Program Files\\Internet Explorer\\iexplore.exe" -test

		
;まるち
Items/MULTI\MULTI
Items/MULTI/Type:2
Items/MULTI/Address$ie	test	ie	link	link

;リンク
Items/link\LINKKK!
Items/link/Type:3
Items/link/Address\ie
Items/link/WorkFolder\aaa
		
;リンク
Items/eeee\eeee
Items/eeee/Type:3
Items/eeee/Address\eeee
Items/eeee/WorkFolder\aaa
;リンク
Items/ffff\ffff
Items/ffff/Type:3
Items/ffff/Address\eeee
Items/ffff/WorkFolder\aaa
		
;まるち
Items/333\３
Items/333/Type:2
Items/333/Address$test	URI	MULTI	link	333

	`.splitlines);
}

/**
ボタン・メニューアイテム作成用構造体。

特に保持せずモジュールが一番適した形に加工して使用。
*/
struct BM_ITEM {
	
	Item item; /// アイテム。
	Text name; /// アイテム名称。
	Icon icon; /// アイコン。
	bool live; /// アイテム選択可不可。
	wchar key; /// アクセスキー。

	deprecated static BM_ITEM noItem(bool ShowIcon, SYSICON SysIcon, ICONSIZE IconSize) {
		static BM_ITEM BMItem=void;
		
		if(ShowIcon) {
			BMItem.icon = GetSystemIcon(SYSICON.EXCLAMATION, IconSize);
		}

		return BMItem;
	}
}

/**
ID > NAME > TAG
*/
struct C_ITEM {
	///
	Item item;
	///
	Icon icon;

	///
	static enum TYPE {
		ID,/// 
		NAME, /// 
		TAG, /// 
	}

	
	///
	TYPE type;

	string typeString;

	debug static pure nothrow TypeToString(TYPE Type) {
		switch(Type) {
			case TYPE.ID:   return "<I>";
			case TYPE.NAME: return "<N>";
			case TYPE.TAG:  return "<T>";
			default:        assert(false);
		}
	}

	debug string toString() {
		return format("%s:%s", TypeToString(type), item.itemID);
	}

	/+
	int find(string s) {
		int index=str.find(item.itemID(), s);
		if(index != -1) {
			return index;
		} else {
			index = str.find(item.name(), s);
			if(index != -1) {
				return index;
			} else {
				foreach(tag; item.tags()) {
					index = str.find(tag, s);
					if(index != -1) {
						return index;
					}
				}
			}
		}
		
		return -1;
	}
	+/
}

/**
ボタン・メニュー表示項目作成。

最低限の項目を作るだけ。
コマンド型はタグとかもあるんで一応外す。

Params:
	item = アイテム。

	ShowIcon = アイコンを表示させるか。

	IconSize = アイコンの大きさ。
	           ShowIconが偽の場合はどうでもいい。

Return:
	項目。
	
*/
BM_ITEM ItemToButtonMenuItem(Item item, bool ShowIcon, ICONSIZE IconSize)
in {
	assert(item);
}
out(r) {
	if(ShowIcon)
		assert(r.icon);
	else
		assert(!r.icon);
}
body {
	BM_ITEM BMItem;
	BMItem.item = item;
	
	switch(item.type()) {
		case Item.TYPE.NORMAL: {
			Text Address=item.address();
			BMItem.live = FILE.isExistence(Address);

			if(ShowIcon) {
				Text IconAddress=toPlain(Text(item.iconAddress()));
				if(!FILE.isExistence(IconAddress)) {
					if(BMItem.live) {
						IconAddress = Address;
					} else {
						IconAddress = IconAddress.emptyText();
					}
				}
				if(IconAddress.length) {
					BMItem.icon = GetFileIcon(IconAddress, item.iconIndex(), IconSize);
				} else {
					BMItem.icon = GetSystemIcon(SYSICON.EXCLAMATION, IconSize);
				}
			}

			if(BMItem.live) {
				BMItem.name = item.name.length
					? item.name
					: item.itemID;
			} else {
				BMItem.name = item.itemID;
			}
			
			break;
		}
		case Item.TYPE.URI, Item.TYPE.MULTI: {
			if(item.type() == Item.TYPE.URI) {
				BMItem.live = true;
			} else {
				BMItem.live = item.multi().length != 0 ? true: false;
			}
			
			if(ShowIcon) {
				Text IconAddress=toPlain(Text(item.iconAddress()));
				if(FILE.isExistence(IconAddress)) {
					BMItem.icon = GetFileIcon(IconAddress, item.iconIndex(), IconSize);
				} else {
					BMItem.icon = GetSystemIcon(item.type() == Item.TYPE.URI ? SYSICON.URI:SYSICON.MULTI, IconSize);
				}
			}
			BMItem.name = item.name.length ? item.name: item.itemID();
			
			break;
		}
		default:
			assert(false, item.name);
	}
	
	return BMItem;
}
debug(item) unittest {
	auto aki=newItem();
	auto item=new Item("ie", aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, ICONSIZE.SMALL).live);
	item=new Item("test", aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, ICONSIZE.SMALL).live);
	item=new Item("URI", aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, ICONSIZE.SMALL).live);
	item=new Item("MULTI", aki[`Items`]);
	//wl(ItemToButtonMenuItem(item, true, ICONSIZE.SMALL).live);

}
/***/
struct OverrideInfo {
	enum MASK {
		NONE   = 0b0000,
		WORK   = 0b0001,
		OPTION = 0b0010,
		SHOW   = 0b0100,
	}
	MASK Mask;
	
	string WorkFolder;
	string Option;
	SHOW Show;
}




