﻿/**

*/
module nemuxi.file.items.group;

debug import std.stdio: wl = writefln, pl = printf;

public import etc.kareki.kareki;

import nemuxi.base;
import nemuxi.system.application;
import nemuxi.file.data;
import nemuxi.file.items.item;
import nemuxi.file.items.linkitem;
import nemuxi.image.icon;


///
abstract class Group: Data {
	invariant() {
		assert(ks[GROUP].type == HAGATA.TSV_String);
	}
	private static invariant auto GROUP = 0;
	
	/**
	コンストラクタ。
	
	Params:
		group = グループ。
		        こいつがなくちゃ表明違反。
	*/
	this(Kareha group)
	in {
		assert(group);
	}
	body {
		ks = new Kareha[GROUP+1];

		// グループ設定。
		ks[GROUP] = group;
		if(!(ks[GROUP].have() && ks[GROUP].type == HAGATA.TSV_String)) {
			ks[GROUP] = (string[]).init;
		}

	}

	/**
	子グループ数取得。

	設計ミスった。
	何故に子グループ。

	Return:
		子グループ数。
	*/
	size_t length() {
		return ks[GROUP].children().length;
	}

	/**
	グループの順序を取得。

	Returns:
		順に並んだ現在グループ。
	*/
	string[] opCall() {
		return ks[GROUP].get!(string[]);
	}

	/**
	指定子グループは存在するか。

	Params:
		group = 子グループ名。

	Retuen:
		存在すればtrue、存在しなければfalseを返す。
	*/
	bool opIn_r(string group) {
		return group in ks[GROUP];
	}
	
	/**
	指定子グループ取得。

	Params:
		group = 子グループ名。

	Retuen:
		指定したグループ。
	*/
	Kareha opIndex(string group) {
		return ks[GROUP][group];
	}

	/**
	子グループをすべて取得。

	Return:
		子グループ。
	*/
	Kareha[string] opSlice() {
		return ks[GROUP].children();
	}
}
///
class Main: Group {
	///
	this(Kareha MainGroup) {
		super(MainGroup);
	}

	/**
	サブアイテムを直接生成。

	Params:
		MainName = 生成するサブアイテムの名前。
	*/
	Sub subGroup(in string MainName) {
		return new Sub(this, opIndex(MainName));
	}
}
///
class Sub: Group {
	private Main MainGroup;
	///
	this(Main MainGroup, Kareha SubGroup)
	in {
		assert(MainGroup);
	}
	body {
		super(SubGroup);
		this.MainGroup = MainGroup;
	}

	/// 自身の親御さんを取得。
	Main mainGroup() {
		return MainGroup;
	}
}


debug(group) import std.string, nemuxi.file.items.item;
debug(group) unittest {
	auto aki=new AkiDocument("
Group$test1	test2	test5	test4	test3
Group/test1$c	a	b
Group/test2$A	B	C
Group/test3$あ	い	う
Group/test4$い	ろ	は
Group/test5$X	Y	Z
Group/test1/a$item-1-1-1	item-1-1-2	item-1-1-3
Group/test1/b$item-1-2-1	item-1-2-2	item-1-2-3
Group/test1/c$ie	<NEMUXI>	URI
	".splitlines);
	auto main=new Main(aki["Group"]);
	assert(main() == ["test1", "test2", "test5", "test4", "test3"]);
	assert(main.length == 5);
	assert("test1" in main);
	assert(!("test6" in main));
	assert(main[].keys == ["test1", "test2", "test3", "test4", "test5"]);
	assert(main["test1"] == aki["Group/test1"]);

	auto sub=new Sub(main, main["test1"]);
	assert(sub() == ["c", "a", "b"]);
	assert(sub.length == 3);
	assert(!("d" in sub));
	assert(sub[].keys.sort == ["a", "b", "c"]);
	assert(sub["a"] == aki["Group/test1/a"]);

	auto sub2 = main.subGroup("test1");

	assert(sub.ks[0] == sub2.ks[0]);

	auto s=sub[`a`].get!(string[]);
	wl("%s", s);

	auto n=ButtonMenuGroupItems(sub, "c", newItem()["Items"], true, ICONSIZE.SMALL);
}


/**
指定サブグループからボタン型・メニュー型アイテムの一覧を取得。

久しぶりに見たら引数大混乱。

Params:
	SubGroup = サブグループオブジェクト。

	SubGroupName = SubGroupから該当するサブグループ名。

	Items = SubGroupNameが所持しているアイテムツリーのベース部分。

	ShowIcon = アイコンを取得するか。

	IconSize = アイコンの大きさ。

Return:
	どばー。
*/
BM_ITEM[] ButtonMenuGroupItems(Sub SubGroup, string SubGroupName, Kareha Items, bool ShowIcon, ICONSIZE IconSize)
in {
	assert(SubGroup);
	assert(SubGroupName.length);
	assert(Items);
}
body {
	if(SubGroupName in SubGroup) {
		BM_ITEM[] BMItems;
		auto ItemList=SubGroup[SubGroupName];
		
		foreach(ItemName; ItemList.get!(string[])) {
			if(ItemName in Items) {
				Item item=new Item(ItemName, Items);
				BMItems ~= ItemToButtonMenuItem(item.type() != Item.TYPE.LINK ? item: new LinkItem(item, Items), ShowIcon, IconSize);
			} /+else {
				// 表示名を考えねば
				SYSICON SysIcon=void;
				with(ITEM_ID_TYPE) switch(ItemIdType(ItemName)) {
					case NEMUXI:
						SysIcon  = SYSICON.NEMUXI;
						ItemName = "ﾈﾑぃ";
						break;
					case SYSTEM:
						SysIcon  = SYSICON.SYSTEM;
						ItemName = "システム";
						break;
					default:
						BMItems ~= BM_ITEM.noItem(ShowIcon, SysIcon, IconSize);
						continue;
				}
				BM_ITEM BMItem;
				BMItem.name = ItemName;
				BMItem.live = true;
				if(ShowIcon) {
					BMItem.icon = GetSystemIcon(SysIcon, IconSize);
				}
				BMItems ~= BMItem;
				debug wl(ItemName);
				// システムをなくしたので消滅。
			}
			+/
		}

		return BMItems;
	}
	
	return null;
}

