﻿/**

*/
module nemuxi.file.folder;

debug import std.stdio: wl = writefln, pl = printf;

debug(folder) void main() {}

import win32.shlobj;
import win32.shellapi;
import win32.winerror;
//import win32.shlwapi;
import win32.objbase;
//import win32.objidl;

import win32.core;

import nemuxi.base;
import nemuxi.file.file;


enum {
	CSIDL_DESKTOP                 = 0x0000, /// 「デスクトップ」（ネームスペースのルートを表す仮想フォルダ）
	CSIDL_INTERNET                = 0x0001, /// 「Internet Explorer」（仮想フォルダ）
	CSIDL_PROGRAMS                = 0x0002, /// 「プログラム」（ファイルシステムディレクトリ）
	CSIDL_CONTROLS                = 0x0003, /// 「コントロール パネル」（仮想フォルダ）
	CSIDL_PRINTERS                = 0x0004, /// 「プリンタ」（仮想フォルダ）
	CSIDL_PERSONAL                = 0x0005, /// 「マイ ドキュメント」（ファイルシステムディレクトリ）
	CSIDL_FAVORITES               = 0x0006, /// 「お気に入り」（ファイルシステムディレクトリ）
	CSIDL_STARTUP                 = 0x0007, /// 「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_RECENT                  = 0x0008, /// 「最近使ったファイル」（ファイルシステムディレクトリ）
	CSIDL_SENDTO                  = 0x0009, /// 「SendTo」（ファイルシステムディレクトリ）
	CSIDL_BITBUCKET               = 0x000a, /// 「ごみ箱」（仮想フォルダ）
	CSIDL_STARTMENU               = 0x000b, /// 「スタートメニュー」（ファイルシステムディレクトリ）
	CSIDL_MYMUSIC                 = 0x000d, /// 「マイ ミュージック」（ファイルシステムディレクトリ）
	CSIDL_DESKTOPDIRECTORY        = 0x0010, /// 「デスクトップ」上のファイルオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_DRIVES                  = 0x0011, /// 「マイ コンピュータ」（仮想フォルダ）
	CSIDL_NETWORK                 = 0x0012, /// 「ネットワークコンピュータ」（仮想フォルダ）
	CSIDL_NETHOOD                 = 0x0013, /// 「NetHood」（ファイルシステムディレクトリ）
	CSIDL_FONTS                   = 0x0014, /// 「Fonts」（フォントを含む仮想フォルダ）
	CSIDL_TEMPLATES               = 0x0015, /// ドキュメントテンプレートが格納されるフォルダ（ファイルシステムディレクトリ）
	CSIDL_COMMON_STARTMENU        = 0x0016, /// AllUsers の「スタートメニュー」（ファイルシステムディレクトリ）
	CSIDL_COMMON_PROGRAMS         = 0x0017, /// AllUsers の「プログラム」（ファイルシステムディレクトリ）
	CSIDL_COMMON_STARTUP          = 0x0018, /// AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_DESKTOPDIRECTORY = 0x0019, /// AllUsers の「デスクトップ」（ファイルシステムディレクトリ）
	CSIDL_APPDATA                 = 0x001a, /// Version 4.71 以降： 「Application Data」（ファイルシステムディレクトリ）
	CSIDL_PRINTHOOD               = 0x001b, /// 「プリンタ」仮想フォルダにおかれるリンクオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_LOCAL_APPDATA           = 0x001c, /// Version 5.0 以降： 「Application Data」（ファイルシステムディレクトリ）
	CSIDL_ALTSTARTUP              = 0x001d, /// 非ローカル版の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_ALTSTARTUP       = 0x001e, /// 非ローカル版の AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	CSIDL_COMMON_FAVORITES        = 0x001f, /// AllUsers の「お気に入り」（NT系のみ）（ファイルシステムディレクトリ）
	CSIDL_INTERNET_CACHE          = 0x0020, /// Version 4.72 以降： インターネット一時ファイルを格納するフォルダ（ファイルシステムディレクトリ）
	CSIDL_COOKIES                 = 0x0021, /// 「Cookies」（ファイルシステムディレクトリ）
	CSIDL_HISTORY                 = 0x0022, /// 「履歴」（ファイルシステムディレクトリ）
	CSIDL_COMMON_APPDATA          = 0x0023, /// Version 5.0 以降： AllUsers の「Application Data」（ファイルシステムディレクトリ）
	CSIDL_WINDOWS                 = 0x0024, /// Version 5.0 以降： Windows ディレクトリ
	CSIDL_SYSTEM                  = 0x0025, /// Version 5.0 以降： Windows System ディレクトリ
	CSIDL_PROGRAM_FILES           = 0x0026, /// Version 5.0 以降： Program Files フォルダ
	CSIDL_MYPICTURES              = 0x0027, /// Version 5.0 以降： My Pictures フォルダ（ファイルシステムディレクトリ）
	CSIDL_PROFILE                 = 0x0028, /// Version 5.0 以降： profile フォルダ
	CSIDL_PROGRAM_FILES_COMMON    = 0x002b, /// Version 5.0 以降；Windows 2000/XP： Program Files\Common
	CSIDL_COMMON_TEMPLATES        = 0x002d, /// Windows NT/2000/XP： AllUsers のドキュメントテンプレートが格納されるディレクトリ
	CSIDL_COMMON_DOCUMENTS        = 0x002e, /// Shfolder.dll： AllUsers のドキュメントテンプレートが格納されるディレクトリ（Windows NT 系および Shfolder.dll がインストールされた Windows 9x）
	CSIDL_COMMON_ADMINTOOLS       = 0x002f, /// Version 5.0 以降： AllUsers の管理ツールディレクトリ
	CSIDL_ADMINTOOLS              = 0x0030, /// Version 5.0 以降： 管理ツールディレクトリ
}

///システムフォルダ。
enum SYS_FOLDER { // なんか古いんでhttp://yokohama.cool.ne.jp/chokuto/urawaza/prm/CSIDL.htmlから直値
	DESKTOP                 = CSIDL_DESKTOP,                 /// 「デスクトップ」（ネームスペースのルートを表す仮想フォルダ）
	INTERNET                = CSIDL_INTERNET,                /// 「Internet Explorer」（仮想フォルダ）
	PROGRAMS                = CSIDL_PROGRAMS,                /// 「プログラム」（ファイルシステムディレクトリ）
	CONTROLS                = CSIDL_CONTROLS,                /// 「コントロール パネル」（仮想フォルダ）
	PRINTERS                = CSIDL_PRINTERS,                /// 「プリンタ」（仮想フォルダ）
	PERSONAL                = CSIDL_PERSONAL,                /// 「マイ ドキュメント」（ファイルシステムディレクトリ）
	FAVORITES               = CSIDL_FAVORITES,               /// 「お気に入り」（ファイルシステムディレクトリ）
	STARTUP                 = CSIDL_STARTUP,                 /// 「スタートアップ」（ファイルシステムディレクトリ）
	RECENT                  = CSIDL_RECENT,                  /// 「最近使ったファイル」（ファイルシステムディレクトリ）
	SENDTO                  = CSIDL_SENDTO,                  /// 「SendTo」（ファイルシステムディレクトリ）
	BITBUCKET               = CSIDL_BITBUCKET,               /// 「ごみ箱」（仮想フォルダ）
	STARTMENU               = CSIDL_STARTMENU,               /// 「スタートメニュー」（ファイルシステムディレクトリ）
	MYMUSIC                 = CSIDL_MYMUSIC,                 /// 「マイ ミュージック」（ファイルシステムディレクトリ）
	DESKTOPDIRECTORY        = CSIDL_DESKTOPDIRECTORY,        /// 「デスクトップ」上のファイルオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	DRIVES                  = CSIDL_DRIVES,                  /// 「マイ コンピュータ」（仮想フォルダ）
	NETWORK                 = CSIDL_NETWORK,                 /// 「ネットワークコンピュータ」（仮想フォルダ）
	NETHOOD                 = CSIDL_NETHOOD,                 /// 「NetHood」（ファイルシステムディレクトリ）
	FONTS                   = CSIDL_FONTS,                   /// 「Fonts」（フォントを含む仮想フォルダ）
	TEMPLATES               = CSIDL_TEMPLATES,               /// ドキュメントテンプレートが格納されるフォルダ（ファイルシステムディレクトリ）
	COMMON_STARTMENU        = CSIDL_COMMON_STARTMENU,        /// AllUsers の「スタートメニュー」（ファイルシステムディレクトリ）
	COMMON_PROGRAMS         = CSIDL_COMMON_PROGRAMS,         /// AllUsers の「プログラム」（ファイルシステムディレクトリ）
	COMMON_STARTUP          = CSIDL_COMMON_STARTUP,          /// AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	COMMON_DESKTOPDIRECTORY = CSIDL_COMMON_DESKTOPDIRECTORY, /// AllUsers の「デスクトップ」（ファイルシステムディレクトリ）
	APPDATA                 = CSIDL_APPDATA,                 /// Version 4.71 以降： 「Application Data」（ファイルシステムディレクトリ）
	PRINTHOOD               = CSIDL_PRINTHOOD,               /// 「プリンタ」仮想フォルダにおかれるリンクオブジェクトを格納するフォルダ（ファイルシステムディレクトリ）
	LOCAL_APPDATA           = CSIDL_LOCAL_APPDATA,           /// Version 5.0 以降： 「Application Data」（ファイルシステムディレクトリ）
	ALTSTARTUP              = CSIDL_ALTSTARTUP,              /// 非ローカル版の「スタートアップ」（ファイルシステムディレクトリ）
	COMMON_ALTSTARTUP       = CSIDL_COMMON_ALTSTARTUP,       /// 非ローカル版の AllUsers の「スタートアップ」（ファイルシステムディレクトリ）
	COMMON_FAVORITES        = CSIDL_COMMON_FAVORITES,        /// AllUsers の「お気に入り」（NT系のみ）（ファイルシステムディレクトリ）
	INTERNET_CACHE          = CSIDL_INTERNET_CACHE,          /// Version 4.72 以降： インターネット一時ファイルを格納するフォルダ（ファイルシステムディレクトリ）
	COOKIES                 = CSIDL_COOKIES,                 /// 「Cookies」（ファイルシステムディレクトリ）
	HISTORY                 = CSIDL_HISTORY,                 /// 「履歴」（ファイルシステムディレクトリ）
	COMMON_APPDATA          = CSIDL_COMMON_APPDATA,          /// Version 5.0 以降： AllUsers の「Application Data」（ファイルシステムディレクトリ）
	WINDOWS                 = CSIDL_WINDOWS,                 /// Version 5.0 以降： Windows ディレクトリ
	SYSTEM                  = CSIDL_SYSTEM,                  /// Version 5.0 以降： Windows System ディレクトリ
	PROGRAM_FILES           = CSIDL_PROGRAM_FILES,           /// Version 5.0 以降： Program Files フォルダ
	MYPICTURES              = CSIDL_MYPICTURES,              /// Version 5.0 以降： My Pictures フォルダ（ファイルシステムディレクトリ）
	PROFILE                 = CSIDL_PROFILE,                 /// Version 5.0 以降： profile フォルダ
	PROGRAM_FILES_COMMON    = CSIDL_PROGRAM_FILES_COMMON,    /// Version 5.0 以降；Windows 2000/XP： Program Files\Common
	COMMON_TEMPLATES        = CSIDL_COMMON_TEMPLATES,        /// Windows NT/2000/XP： AllUsers のドキュメントテンプレートが格納されるディレクトリ
	COMMON_DOCUMENTS        = CSIDL_COMMON_DOCUMENTS,        /// Shfolder.dll： AllUsers のドキュメントテンプレートが格納されるディレクトリ（Windows NT 系および Shfolder.dll がインストールされた Windows 9x）
	COMMON_ADMINTOOLS       = CSIDL_COMMON_ADMINTOOLS,       /// Version 5.0 以降： AllUsers の管理ツールディレクトリ
	ADMINTOOLS              = CSIDL_ADMINTOOLS,              /// Version 5.0 以降： 管理ツールディレクトリ
}

/**SHGetFolderPath
システムフォルダアドレス取得。

Params:
	Folder = 取得するフォルダ。

	PathSize = 取得するフォルダのアドレスをどの長さまでサポートするか。

Return:
	取得したフォルダアドレス。

Exception:
	取得に失敗すればNemuxiExceptionを投げる。
	アドレスが無いやつとか。
*/
Text GetSystemFolder(SYS_FOLDER Folder, size_t PathSize=MY_MAX_PATH)
in {
	assert(PathSize);
}
body {
	auto path=new wchar[PathSize+1];
	LPITEMIDLIST ItemID;

	if(SHGetSpecialFolderLocation(null, Folder, &ItemID) == S_OK) {
		if(SHGetPathFromIDList(ItemID, path.ptr) == FALSE) {
			throw new NemuxiFolderException("GetSystemFolder:SHGetPathFromIDList");
		}
		CoTaskMemFree(ItemID);
	} else {
		throw new NemuxiFolderException("GetSystemFolder:SHGetSpecialFolderLocation");
	}

	return Text(path.ptr);
}
/+
debug(folder) unittest {
	//Dim bAddress[ELM(MAX_PATH)] As Byte,
	wchar[MAX_PATH] bAddress;
	void* PIDL;// As VoidPtr
	SHELLEXECUTEINFO sShell;

	sShell.cbSize = SHELLEXECUTEINFO.sizeof;
	sShell.hwnd = GetDesktopWindow();
	sShell.nShow = SW_SHOW;
//	Let sShell.lpVerb = gpoMain->getDir();

	SHGetSpecialFolderLocation(null,SYS_FOLDER.DRIVES,cast(ITEMIDLIST**)&PIDL);
	SHGetPathFromIDList(cast(ITEMIDLIST*)PIDL,bAddress.ptr);

	sShell.fMask = SEE_MASK_DOENVSUBST | SEE_MASK_IDLIST;
	sShell.lpIDList = PIDL;
	ShellExecuteEx(&sShell);
	CoTaskMemFree(PIDL);
Err.show;

}
+/

__EOF__;
import win32.windows;
import nemuxi.file.items.item;
void OpenSystemFolder(SYS_FOLDER Folder, Item OpenItem=null, size_t PathSize=MY_MAX_PATH) {
	auto path=new wchar[PathSize+1];
	LPITEMIDLIST PIDL;
	SHELLEXECUTEINFO sShell;

	//ZeroMemory(VarPtr(sShell),SizeOf(SHELLEXECUTEINFO))

	sShell.cbSize = sShell.sizeof;//SizeOf(SHELLEXECUTEINFO)
	sShell.hwnd = GetDesktopWindow();
	sShell.nShow = SW_SHOWNORMAL;
	sShell.lpVerb = Text("OPEN").ptr;

		SHGetSpecialFolderPath(NULL,path.ptr,Folder,0);
		SHGetSpecialFolderLocation(null,Folder,&PIDL);
		SHGetPathFromIDList(PIDL,path.ptr);
		sShell.fMask = SEE_MASK_DOENVSUBST | SEE_MASK_IDLIST;
	sShell.lpIDList = PIDL;
		ShellExecuteEx(&sShell);
		CoTaskMemFree(PIDL);
}
debug(folder) unittest {
	OpenSystemFolder(SYS_FOLDER.DRIVES);
}

