﻿/**
ファイル検索。

Phobosはちっと使わない。
*/
module nemuxi.file.find;

debug import std.stdio: wl = writefln, pl = printf;

debug(find) void main() {}

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;

///
struct FILEITEM {
	WIN32_FIND_DATA info;

	/// ファイル属性。
	static enum ATTRIBUTE {
		READONLY      = FILE_ATTRIBUTE_READONLY      , /// 読み取り専用属性を持ちます。この属性を持つファイルは読み込むことができますが書き込んだり削除したりすることはできません。この属性を持つディレクトリを削除することはできません。
		HIDDEN        = FILE_ATTRIBUTE_HIDDEN        , /// 隠しファイル属性を持ちます。
		SYSTEM        = FILE_ATTRIBUTE_SYSTEM        , /// システム属性を持ちます。
		DIRECTORY     = FILE_ATTRIBUTE_DIRECTORY     , /// ディレクトリです。
		ARCHIVE       = FILE_ATTRIBUTE_ARCHIVE       , /// アーカイブ属性を持ちます。
		ENCRYPTED     = FILE_ATTRIBUTE_ENCRYPTED     , /// 暗号化属性を持ちます。この属性を持つファイルはデータが暗号化されていることを示します。この属性を持つディレクトリは、このディレクトリの中に新しく作成されるファイルやサブディレクトリがデフォルトで暗号化属性を持つことを示します。
		NORMAL        = FILE_ATTRIBUTE_NORMAL        , /// ほかのどの属性も設定されていません。
		TEMPORARY     = FILE_ATTRIBUTE_TEMPORARY     , /// 一時記憶領域として利用されているファイルです。
		SPARSE_FILE   = FILE_ATTRIBUTE_SPARSE_FILE   , /// スパースファイルです。
		REPARSE_POINT = FILE_ATTRIBUTE_REPARSE_POINT , /// 関連付けられたリパースポイントを持ちます。
		COMPRESSED    = FILE_ATTRIBUTE_COMPRESSED    , /// 圧縮属性を持ちます。この属性を持つファイルはデータが圧縮されていることを示します。この属性を持つディレクトリは、このディレクトリの中に新しく作成されるファイルやサブディレクトリがデフォルトで圧縮属性を持つことを示します。
		OFFLINE       = FILE_ATTRIBUTE_OFFLINE       , /// ファイルは直接利用することができません。この属性は、ファイルがオフラインストレージに移動されたものであることを示します。アプリケーションはこの属性を変更するべきではありません。
	}
	/// ファイル属性。
	const ATTRIBUTE attributes() {
		return cast(ATTRIBUTE)info.dwFileAttributes;
	}
	/+
	/// ditto;
	void attributes(ATTRIBUTE Attributes) {
		info.dwFileAttributes = Attributes;
	}
	+/

	/// 時間。てけとう。
	alias info.ftCreationTime   createTime;
	/// ditto
	alias info.ftLastAccessTime lastAccessTime;
	/// ditto
	alias info.ftLastWriteTime  lastWriteTime;

	const ulong size() {
		return info.nFileSizeHigh * DWORD.max + info.nFileSizeLow;
	}

	/*
	bool reparsePoint() {
		return info.dwReserved0;
	}
	*/

	/// ファイル名。
	Text fileName() {
		return Text(info.cFileName.ptr);
	}
	/// 8.3文字ファイル名。
	Text shortFileName() {
		return Text(info.cAlternateFileName.ptr);
	}

	bool isFolder() {
		return (info.dwFileAttributes & ATTRIBUTE.DIRECTORY) == ATTRIBUTE.DIRECTORY
			? true
			: false;
	}
}

/**
ファイル検索。
*/
class Finder: Raii {
	protected HBRUSH hFind;
	mixin KillResource!("ファイル検索", hFind, FindClose, 0);

	private bool NextFind;

	protected wchar* FilePattern;
	protected size_t Count;
	
	this(in Text FilePattern) {
		super(false);
		this.FilePattern = FilePattern.ptr;
	}

	void newPattern(in Text FilePattern) {
		Kill();
		
		super.Suicide    = true;
		NextFind         = false;
		hFind            = null;
		Count            = 0;
		this.FilePattern = FilePattern.ptr;
	}

	bool find(ref FILEITEM FileItem) {
		if(NextFind) {
			if(FindNextFile(hFind, &FileItem.info)) {
				Count++;
				return true;
			} else {
				NextFind=false;
				return false;
			}
		} else {
			auto FileFind=FindFirstFile(FilePattern, &FileItem.info);
			if(FileFind == INVALID_HANDLE_VALUE) {
				super.Suicide = false;
				return false;
			} else {
				super.Suicide = true;
				NextFind = true;
				hFind = FileFind;
				Count++;
				return true;
			}
		}
	}

	const size_t count() {
		return Count;
	}
}







