﻿/**

*/
module nemuxi.file.app;

debug import std.stdio: wl = writefln, pl = printf;

debug(app) void main() {}

debug import std.string;
import std.uni;
debug import std.conv;

import win32.windows;

import nemuxi.base;
import nemuxi.file.data;
import nemuxi.file.exec;
import nemuxi.negui.draw.color;
import nemuxi.image.icon;
import nemuxi.image.font;
import nemuxi.negui.window.adtb;
//import nemuxi.negui.proc.proc;
import nemuxi.negui.negui;
import nemuxi.negui.keyboard.keyboard;


private enum {
	COMMAND_FONT_SIZE = 7,
}
/**
アプリケーションの設定データ。
*/
class App: Data {
	debug invariant() {
		assert(ks[ITEM.WINDOW].get!(Integer) >= POSITION.min && ks[ITEM.WINDOW].get!(Integer) <= POSITION.max);
		assert(ks[ITEM.WINDOW_FRONT].type == HAGATA.Integer);

		assert(ks[ITEM.WINDOW_LEFT].get!(Integer)   >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_TOP].get!(Integer)    >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_RIGHT].get!(Integer)  >= MIN_SIZE);
		assert(ks[ITEM.WINDOW_BOTTOM].get!(Integer) >= MIN_SIZE);
		
		assert(ks[ITEM.WINDOW_FLOAT_POS].get!(Integer[]).length == 2);
		assert(ks[ITEM.WINDOW_FLOAT_SIZE].get!(Integer[]).length == 2);
		foreach(n; ks[ITEM.WINDOW_FLOAT_SIZE].get!(Integer[])) {
			assert(n >= MIN_SIZE);
		}
		assert(ks[ITEM.FOLDER].get!(Integer) >= FOLDER.min && ks[ITEM.FOLDER].get!(Integer) <= FOLDER.max);
		assert(ks[ITEM.FOLDER_PROGRAM].type() == HAGATA.String);
		//assert(ks[ITEM.FOLDER_PROGRAM_OPTION].type() == HAGATA.String);

		assert(ks[ITEM.LAUNCHER_HISTORY].get!(Integer) >= 0);

		assert(ks[ITEM.LAUNCHER_BUTTON_TEXT].type() == HAGATA.Integer);
		assert(ks[ITEM.LAUNCHER_BUTTON_LIST].type() == HAGATA.Integer);
		if(super.GetBool(ITEM.LAUNCHER_BUTTON_LIST)) {
			assert(super.GetBool(ITEM.LAUNCHER_BUTTON_TEXT));
		}
		assert(ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer) <= ICONSIZE.max, to!(string)(ks[ITEM.LAUNCHER_BUTTON_ICON].get!(Integer)));
		
		assert(ks[ITEM.LAUNCHER_MENU_TEXT].get!(Integer) >= 0);
		assert(ks[ITEM.LAUNCHER_MENU_ICON].get!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_MENU_ICON].get!(Integer) <= ICONSIZE.max);
		assert(ks[ITEM.LAUNCHER_MENU_DESKTOP].type() == HAGATA.Integer);
		
		assert(ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() == HAGATA.String);
		assert(ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].type() == HAGATA.Integer);

		assert(ks[ITEM.LAUNCHER_COMMAND_ICON].get!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_COMMAND_ICON].get!(Integer) <= ICONSIZE.max);
		
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_NORMAL].tsvLength == 2);
		/+
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ITEM].tsvLength == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS].tsvLength == 2);
		+/
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_ID].tsvLength     == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME].tsvLength   == 2);
		assert(ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG].tsvLength    == 2);
		
		assert(ks[ITEM.LAUNCHER_COMMAND_TIMER].get!(Integer) == Integer.min || ks[ITEM.LAUNCHER_COMMAND_TIMER].get!(Integer) >= -1);
	}
	private static enum ITEM {
		WINDOW,
		WINDOW_FRONT,
		WINDOW_LEFT,
		WINDOW_TOP,
		WINDOW_RIGHT,
		WINDOW_BOTTOM,
		WINDOW_FLOAT_POS,
		WINDOW_FLOAT_SIZE,
		
		FOLDER,
		FOLDER_PROGRAM,
		//FOLDER_PROGRAM_OPTION,
		
		LAUNCHER_HISTORY,
		
		LAUNCHER_BUTTON_TEXT,
		LAUNCHER_BUTTON_LIST,
		LAUNCHER_BUTTON_ICON,
		
		LAUNCHER_MENU_TEXT,
		LAUNCHER_MENU_ICON,
		LAUNCHER_MENU_DESKTOP,

		LAUNCHER_COMMAND_KEYS,
		LAUNCHER_COMMAND_ICON,
		LAUNCHER_COMMAND_FONT_NAME,
		LAUNCHER_COMMAND_FONT_SIZE,
		LAUNCHER_COMMAND_COLOR_NORMAL,
		/+
		LAUNCHER_COMMAND_COLOR_ITEM,
		LAUNCHER_COMMAND_COLOR_ADDRESS,
		+/
		LAUNCHER_COMMAND_COLOR_ID,
		LAUNCHER_COMMAND_COLOR_NAME,
		LAUNCHER_COMMAND_COLOR_TAG,
		LAUNCHER_COMMAND_TIMER,
		
	}
	/+
	private enum TREE: string {
		WINDOW = "Window",
		WINDOW_FRONT  = "Front",
		WINDOW_LEFT   = "Left",
		WINDOW_TOP    = "Top",
		WINDOW_RIGHT  = "Right",
		WINDOW_BOTTOM = "Bottom",
		WINDOW_FLOAT  = "Float",
		WINDOW_FLOAT_POS  = "Pos",
		WINDOW_FLOAT_SIZE = "Size",
		
		FOLDER = "Folder",
		FOLDER_PROGRAM = "Program",
		//FOLDER_PROGRAM_OPTION = "Option",
		
		HOTKEY = "HotKey",
		HOTKEY_KEYS = "Keys",
		
		
		LAUNCHER = "Launcher",
		
		LAUNCHER_BUTTON = "Button",
		LAUNCHER_BUTTON_TEXT = "Text",
		LAUNCHER_BUTTON_LIST = "List",
		LAUNCHER_BUTTON_ICON = "Icon",
		
		LAUNCHER_MENU = "Menu",
		LAUNCHER_MENU_TEXT = "Text",
		LAUNCHER_MENU_ICON = "Icon",
		
		LAUNCHER_COMMAND = "Command",
		LAUNCHER_COMMAND_FONT = "Font",
		LAUNCHER_COMMAND_FONT_NAME = "Name",
		LAUNCHER_COMMAND_FONT_SIZE = "Size",
		LAUNCHER_COMMAND_COLOR = "Color",
		LAUNCHER_COMMAND_COLOR_NORMAL  = "Normal",
		LAUNCHER_COMMAND_COLOR_ITEM    = "Item",
		LAUNCHER_COMMAND_COLOR_ADDRESS = "Address",
		LAUNCHER_COMMAND_TIMER = "Timer",
	
	}
	+/
	static invariant struct TREE {
		string WINDOW = "Window";
		string WINDOW_FRONT  = "Front";
		string WINDOW_LEFT   = "Left";
		string WINDOW_TOP    = "Top";
		string WINDOW_RIGHT  = "Right";
		string WINDOW_BOTTOM = "Bottom";
		string WINDOW_FLOAT  = "Float";
		string WINDOW_FLOAT_POS  = "Pos";
		string WINDOW_FLOAT_SIZE = "Size";
		
		string FOLDER = "Folder";
		string FOLDER_PROGRAM = "Program";
		//string FOLDER_PROGRAM_OPTION = "Option";
		
		string LAUNCHER = "Launcher";
		
		string LAUNCHER_HISTORY = "History";
		
		string LAUNCHER_BUTTON = "Button";
		string LAUNCHER_BUTTON_TEXT = "Text";
		string LAUNCHER_BUTTON_LIST = "List";
		string LAUNCHER_BUTTON_ICON = "Icon";
		
		string LAUNCHER_MENU = "Menu";
		string LAUNCHER_MENU_TEXT = "Text";
		string LAUNCHER_MENU_ICON = "Icon";
		string LAUNCHER_MENU_DESKTOP = "Desktop";
		
		string LAUNCHER_COMMAND = "Command";
		string LAUNCHER_COMMAND_KEYS = "Keys";
		string LAUNCHER_COMMAND_ICON = "Icon";
		string LAUNCHER_COMMAND_FONT = "Font";
		string LAUNCHER_COMMAND_FONT_NAME = "Name";
		string LAUNCHER_COMMAND_FONT_SIZE = "Size";
		string LAUNCHER_COMMAND_COLOR = "Color";
		string LAUNCHER_COMMAND_COLOR_NORMAL = "Normal";
		string LAUNCHER_COMMAND_COLOR_ID     = "ID";
		string LAUNCHER_COMMAND_COLOR_NAME   = "Name";
		string LAUNCHER_COMMAND_COLOR_TAG    = "Tag";
		/+
		string LAUNCHER_COMMAND_COLOR_ITEM    = "Item";
		string LAUNCHER_COMMAND_COLOR_ADDRESS = "Address";
		+/
		string LAUNCHER_COMMAND_TIMER = "Timer";
	
	}

	///
	static enum POSITION {
		LEFT   = ApplicationDesktopToolBar.ABE.LEFT,
		TOP    = ApplicationDesktopToolBar.ABE.TOP,
		RIGHT  = ApplicationDesktopToolBar.ABE.RIGHT,
		BOTTOM = ApplicationDesktopToolBar.ABE.BOTTOM,
		FLOAT,
		SMALL,
	}

	/// 最低サイズ
	static invariant MIN_SIZE = 16;

	/**
	生成と構築！
	*/
	this(Kareha data)
	in {
		assert(data);
	}
	body {
		ks = new Kareha[ITEM.max + 1];

		// ウィンドウ表示方法
		/+
		if(!data(TREE.WINDOW)) {
			data.plus(TREE.WINDOW, super.EmptyInteger(cast(Integer)POSITION.FLOAT));
		}
		ks[ITEM.WINDOW] = data[TREE.WINDOW];
		if(
			!ks[ITEM.WINDOW].have()
			|| ks[ITEM.WINDOW].type() != HAGATA.Integer
			|| (ks[ITEM.WINDOW].unSafe!(Integer) < POSITION.min || ks[ITEM.WINDOW].unSafe!(Integer) > POSITION.max)
			|| ks[ITEM.WINDOW].unSafe!(Integer) < MIN_SIZE
		) {
			ks[ITEM.WINDOW] = cast(Integer)POSITION.FLOAT;
		}
		+/
		RegistEx!(POSITION.FLOAT)(
			data,
			TREE.WINDOW,
			ITEM.WINDOW,
			ks[ITEM.WINDOW].have()
			&& ks[ITEM.WINDOW].type() == HAGATA.Integer
			&& (POSITION.min <= ks[ITEM.WINDOW].unSafe!(Integer) && ks[ITEM.WINDOW].unSafe!(Integer) <= POSITION.max)
		);

		// 前面表示方法
		if(!(TREE.WINDOW_FRONT in ks[ITEM.WINDOW])) {
			ks[ITEM.WINDOW].plus(TREE.WINDOW_FRONT, super.EmptyInteger());
		}
		ks[ITEM.WINDOW_FRONT] = ks[ITEM.WINDOW][TREE.WINDOW_FRONT];
		if(
			!ks[ITEM.WINDOW_FRONT].have
			|| ks[ITEM.WINDOW_FRONT].type() != HAGATA.Integer
		) {
			ks[ITEM.WINDOW_FRONT] = 0;
		}

		{ // 上下左右の判定と保持・修正
			auto Trees = [TREE.WINDOW_LEFT, TREE.WINDOW_TOP, TREE.WINDOW_RIGHT, TREE.WINDOW_BOTTOM];
			auto Items = [ITEM.WINDOW_LEFT, ITEM.WINDOW_TOP, ITEM.WINDOW_RIGHT, ITEM.WINDOW_BOTTOM];

			for(auto i=0; i < Trees.length; i++) {
				if(!(Trees[i] in ks[ITEM.WINDOW])) {
					ks[ITEM.WINDOW].plus(Trees[i], super.EmptyInteger(1));
				}
				ks[Items[i]] = ks[ITEM.WINDOW][Trees[i]];
				if(
					!ks[Items[i]].have()
					|| ks[Items[i]].type() != HAGATA.Integer
					|| ks[Items[i]].unSafe!(Integer) < MIN_SIZE
				) {
					ks[Items[i]] = MIN_SIZE;
				}
			}
		}
		{ // フロート表示
			auto Trees = [TREE.WINDOW_FLOAT_POS, TREE.WINDOW_FLOAT_SIZE];
			auto Items = [ITEM.WINDOW_FLOAT_POS, ITEM.WINDOW_FLOAT_SIZE];

			if(!(TREE.WINDOW_FLOAT in ks[ITEM.WINDOW])) {
				ks[ITEM.WINDOW].plus(TREE.WINDOW_FLOAT, super.Empty());
			}
			auto Float=ks[ITEM.WINDOW][TREE.WINDOW_FLOAT];

			// 座標・サイズ
			for(auto i=0; i < Trees.length; i++) {
				// 座標
				if(!(Trees[i] in Float)) {
					Float.plus(Trees[i], super.EmptyTsvInteger());
				}
				ks[Items[i]] = Float[Trees[i]];
				if(
					!ks[Items[i]].have()
					|| ks[Items[i]].type() != HAGATA.TSV_Integer
					|| ks[Items[i]].tsvLength() != 2
				) {
					if(!i) {
						ks[Items[i]] = [0, 0];
					} else {
						ks[Items[i]] = [MIN_SIZE , MIN_SIZE];
					}
				}
				ks[Items[i]].tsvLength = 2;
				if(i) foreach(ref n; ks[Items[i]].get!(Integer[])) {
					if(n < MIN_SIZE) {
						n = MIN_SIZE;
					}
				}
			}
		}

		// フォルダオープン動作
		if(!(TREE.FOLDER in data)) {
			data.plus(TREE.FOLDER, super.EmptyInteger(0));
		}
		ks[ITEM.FOLDER] = data[TREE.FOLDER];
		if(
			!ks[ITEM.FOLDER].have()
			|| ks[ITEM.FOLDER].type() != HAGATA.Integer
			|| (ks[ITEM.FOLDER].unSafe!(Integer) < FOLDER.min || ks[ITEM.FOLDER].unSafe!(Integer) > FOLDER.max)
		) {
			ks[ITEM.FOLDER] = cast(Integer)FOLDER.NORMAL;
		}

		// フォルダをプラグラムから開く
		if(!(TREE.FOLDER_PROGRAM in ks[ITEM.FOLDER])) {
			ks[ITEM.FOLDER].plus(TREE.FOLDER_PROGRAM, super.EmptyString());
		}
		ks[ITEM.FOLDER_PROGRAM] = ks[ITEM.FOLDER][TREE.FOLDER_PROGRAM];
		if(
			!ks[ITEM.FOLDER_PROGRAM].have()
			|| ks[ITEM.FOLDER_PROGRAM].type() != HAGATA.String
		) {
			ks[ITEM.FOLDER_PROGRAM] = string.init;
		}
		/+
		// オプション
		super.Regist!(string.init)(
			ks[ITEM.FOLDER_PROGRAM],
			TREE.FOLDER_PROGRAM_OPTION,
			ITEM.FOLDER_PROGRAM_OPTION,
			!ks[ITEM.FOLDER_PROGRAM_OPTION].have
			|| ks[ITEM.FOLDER_PROGRAM_OPTION].type() != HAGATA.String
		);
		+/

		{ // ランチャー
			if(!(TREE.LAUNCHER in data)) {
				data.plus(TREE.LAUNCHER, super.Empty());
			}
			auto Launcher=data[TREE.LAUNCHER];

			// 履歴数
			RegistEx!(MIN_SIZE)(
				Launcher,
				TREE.LAUNCHER_HISTORY,
				ITEM.LAUNCHER_HISTORY,
				ks[ITEM.LAUNCHER_HISTORY].have
				&& ks[ITEM.LAUNCHER_HISTORY].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_HISTORY].get!(Integer) >= 0
			);
			
			
			// ボタン
			if(!(TREE.LAUNCHER_BUTTON in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_BUTTON, super.Empty());
			}
			auto Button=Launcher[TREE.LAUNCHER_BUTTON];

			// ボタンテキスト
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_TEXT,
				ITEM.LAUNCHER_BUTTON_TEXT,
				!ks[ITEM.LAUNCHER_BUTTON_TEXT].have
				|| ks[ITEM.LAUNCHER_BUTTON_TEXT].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_TEXT,
				ITEM.LAUNCHER_BUTTON_TEXT,
				ks[ITEM.LAUNCHER_BUTTON_TEXT].have
				&& ks[ITEM.LAUNCHER_BUTTON_TEXT].type() == HAGATA.Integer
			);
			
			// リスト表示
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_LIST,
				ITEM.LAUNCHER_BUTTON_LIST,
				!ks[ITEM.LAUNCHER_BUTTON_LIST].have
				|| ks[ITEM.LAUNCHER_BUTTON_LIST].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_LIST,
				ITEM.LAUNCHER_BUTTON_LIST,
				ks[ITEM.LAUNCHER_BUTTON_LIST].have
				&& ks[ITEM.LAUNCHER_BUTTON_LIST].type() == HAGATA.Integer
			);
			
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_ICON,
				ITEM.LAUNCHER_BUTTON_ICON,
				!ks[ITEM.LAUNCHER_BUTTON_ICON].have
				|| ks[ITEM.LAUNCHER_BUTTON_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) < ICONSIZE.min || ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) > ICONSIZE.max)
			);
			+/
			super.RegistEx!(0)(
				Button,
				TREE.LAUNCHER_BUTTON_ICON,
				ITEM.LAUNCHER_BUTTON_ICON,
				ks[ITEM.LAUNCHER_BUTTON_ICON].have
				&& ks[ITEM.LAUNCHER_BUTTON_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer) <= ICONSIZE.max
			);
			// メニュー
			if(!(TREE.LAUNCHER_MENU in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_MENU, super.Empty());
			}
			auto Menu=Launcher[TREE.LAUNCHER_MENU];
			// ボタンテキスト
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_TEXT,
				ITEM.LAUNCHER_MENU_TEXT,
				!ks[ITEM.LAUNCHER_MENU_TEXT].have
				|| ks[ITEM.LAUNCHER_MENU_TEXT].type() != HAGATA.Integer
				|| ks[ITEM.LAUNCHER_MENU_TEXT].unSafe!(Integer) < 0
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_TEXT,
				ITEM.LAUNCHER_MENU_TEXT,
				ks[ITEM.LAUNCHER_MENU_TEXT].have
				&& ks[ITEM.LAUNCHER_MENU_TEXT].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_MENU_TEXT].get!(Integer) >= 0
			);
			
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_ICON,
				ITEM.LAUNCHER_MENU_ICON,
				!ks[ITEM.LAUNCHER_MENU_ICON].have
				|| ks[ITEM.LAUNCHER_MENU_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) < ICONSIZE.min || ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) > ICONSIZE.max)
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_ICON,
				ITEM.LAUNCHER_MENU_ICON,
				ks[ITEM.LAUNCHER_MENU_ICON].have
				&& ks[ITEM.LAUNCHER_MENU_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer) <= ICONSIZE.max
			);
			// アイコンサイズ
			/+
			super.Regist!(0)(
				Menu,
				TREE.LAUNCHER_MENU_DESKTOP,
				ITEM.LAUNCHER_MENU_DESKTOP,
				!ks[ITEM.LAUNCHER_MENU_DESKTOP].have
				|| ks[ITEM.LAUNCHER_MENU_DESKTOP].type() != HAGATA.Integer
			);
			+/
			super.RegistEx!(0)(
				Menu,
				TREE.LAUNCHER_MENU_DESKTOP,
				ITEM.LAUNCHER_MENU_DESKTOP,
				ks[ITEM.LAUNCHER_MENU_DESKTOP].have
				&& ks[ITEM.LAUNCHER_MENU_DESKTOP].type() == HAGATA.Integer
			);
			
			// コマンド
			if(!(TREE.LAUNCHER_COMMAND in Launcher)) {
				Launcher.plus(TREE.LAUNCHER_COMMAND, super.Empty());
			}
			auto Command=Launcher[TREE.LAUNCHER_COMMAND];

			// キー
			/+
			super.Regist!([cast(Integer)MOD.ALT, KEY.N])(
				Command,
				TREE.LAUNCHER_COMMAND_KEYS,
				ITEM.LAUNCHER_COMMAND_KEYS,
				!ks[ITEM.LAUNCHER_COMMAND_KEYS].have
				|| ks[ITEM.LAUNCHER_COMMAND_KEYS].type() != HAGATA.TSV_Integer
				|| ks[ITEM.LAUNCHER_COMMAND_KEYS].tsvLength >= 2
			);
			+/
			super.RegistEx!([cast(Integer)MOD.ALT, KEY.N])(
				Command,
				TREE.LAUNCHER_COMMAND_KEYS,
				ITEM.LAUNCHER_COMMAND_KEYS,
				ks[ITEM.LAUNCHER_COMMAND_KEYS].have
				&& ks[ITEM.LAUNCHER_COMMAND_KEYS].type() == HAGATA.TSV_Integer
				&& ks[ITEM.LAUNCHER_COMMAND_KEYS].tsvLength >= 2
			);
			
			// アイコン

			// アイコンサイズ
			/+
			super.Regist!(0)(
				Command,
				TREE.LAUNCHER_COMMAND_ICON,
				ITEM.LAUNCHER_COMMAND_ICON,
				!ks[ITEM.LAUNCHER_COMMAND_ICON].have
				|| ks[ITEM.LAUNCHER_COMMAND_ICON].type() != HAGATA.Integer
				|| (ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) < ICONSIZE.min || ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) > ICONSIZE.max)
			);
			+/
			super.RegistEx!(0)(
				Command,
				TREE.LAUNCHER_COMMAND_ICON,
				ITEM.LAUNCHER_COMMAND_ICON,
				ks[ITEM.LAUNCHER_COMMAND_ICON].have
				&& ks[ITEM.LAUNCHER_COMMAND_ICON].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) >= ICONSIZE.min && ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer) <= ICONSIZE.max
			);


			// フォント
			if(!(TREE.LAUNCHER_COMMAND_FONT in Command)) {
				Command.plus(TREE.LAUNCHER_COMMAND_FONT, super.Empty());
			}
			auto Font=Command[TREE.LAUNCHER_COMMAND_FONT];
			// フォント名
			/+
			super.Regist!(string.init)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_NAME,
				ITEM.LAUNCHER_COMMAND_FONT_NAME,
				!ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].have()
				|| ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() != HAGATA.String
			);
			+/
			super.RegistEx!(string.init)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_NAME,
				ITEM.LAUNCHER_COMMAND_FONT_NAME,
				ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].have()
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_NAME].type() && HAGATA.String
			);
			// フォントサイズ
			super.RegistEx!(Integer.min)(
				Font,
				TREE.LAUNCHER_COMMAND_FONT_SIZE,
				ITEM.LAUNCHER_COMMAND_FONT_SIZE,
				ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].have()
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].type() == HAGATA.Integer
				&& ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].unSafe!(Integer) >= COMMAND_FONT_SIZE
			);
			
			{// 色
				if(!(TREE.LAUNCHER_COMMAND_COLOR in Command)) {
					Command.plus(TREE.LAUNCHER_COMMAND_COLOR, super.Empty());
				}
				auto Colors=Command[TREE.LAUNCHER_COMMAND_COLOR];
				/+
				auto Trees = [TREE.LAUNCHER_COMMAND_COLOR_NORMAL, TREE.LAUNCHER_COMMAND_COLOR_ITEM, TREE.LAUNCHER_COMMAND_COLOR_ADDRESS];
				auto Items = [ITEM.LAUNCHER_COMMAND_COLOR_NORMAL, ITEM.LAUNCHER_COMMAND_COLOR_ITEM, ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS];
				+/
				auto Trees = [TREE.LAUNCHER_COMMAND_COLOR_NORMAL, TREE.LAUNCHER_COMMAND_COLOR_ID, TREE.LAUNCHER_COMMAND_COLOR_NAME, TREE.LAUNCHER_COMMAND_COLOR_TAG];
				auto Items = [ITEM.LAUNCHER_COMMAND_COLOR_NORMAL, ITEM.LAUNCHER_COMMAND_COLOR_ID, ITEM.LAUNCHER_COMMAND_COLOR_NAME, ITEM.LAUNCHER_COMMAND_COLOR_TAG];
				
				for(auto i=0; i < Trees.length; i++) {
					super.RegistEx!((Binary[]).init)(
						Colors,
						Trees[i],
						Items[i],
						ks[Items[i]].have()
						&& ks[Items[i]].type() == HAGATA.TSV_Binary
						&& ks[Items[i]].tsvLength() >= 2
					);
					ks[Items[i]].tsvLength = 2;
				}
			}
			// 消滅タイマー
			super.RegistEx!(0)(
				Command,
				TREE.LAUNCHER_COMMAND_TIMER,
				ITEM.LAUNCHER_COMMAND_TIMER,
				ks[ITEM.LAUNCHER_COMMAND_TIMER].have()
				&& ks[ITEM.LAUNCHER_COMMAND_TIMER].type() == HAGATA.Integer
				&& (/*ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer) != Integer.min ||*/ ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer) > -1)
			);
		}

		// 正規化
		if(!super.GetBool(ITEM.LAUNCHER_BUTTON_TEXT) && super.GetBool(ITEM.LAUNCHER_BUTTON_LIST)) {
			Logger.write("ボタン型テキスト表示設定が不正");
			ks[ITEM.LAUNCHER_BUTTON_LIST] = 0;
		}
	}
	debug(app) unittest {
		auto app=newApp;
	}

	/// 表示位置
	const POSITION position() {
		return cast(POSITION)ks[ITEM.WINDOW].unSafe!(Integer);
	}
	/// ditto
	void position(POSITION Pos) {
		ks[ITEM.WINDOW] = Pos;
	}

	/// 最前面表示
	const bool front() {
		return GetBool(ITEM.WINDOW_FRONT);
	}
	/// ditto
	void front(bool Front) {
		ks[ITEM.WINDOW_FRONT] = Front;
	}

	/// バー状態のサイズ
	const Integer barSize(POSITION Pos)
	out(r) {
		assert(r > 0);
	}
	body {
		with(POSITION) switch(Pos) {
			case LEFT:   return ks[ITEM.WINDOW_LEFT].unSafe!(Integer);
			case TOP:    return ks[ITEM.WINDOW_TOP].unSafe!(Integer);
			case RIGHT:  return ks[ITEM.WINDOW_RIGHT].unSafe!(Integer);
			case BOTTOM: return ks[ITEM.WINDOW_BOTTOM].unSafe!(Integer);
			default:     assert(false, "だめ");
		}
	}
	/// ditto
	void barSize(POSITION Pos, Integer Size)
	in {
		assert(Size > 0);
	}
	body {
		with(POSITION) switch(Pos) {
			case LEFT:   ks[ITEM.WINDOW_LEFT]   = Size; break;
			case TOP:    ks[ITEM.WINDOW_TOP]    = Size; break;
			case RIGHT:  ks[ITEM.WINDOW_RIGHT]  = Size; break;
			case BOTTOM: ks[ITEM.WINDOW_BOTTOM] = Size; break;
			default:     assert(false, "だめだって");
		}
	}

	/// フロートサイズ
	const SIZE floatSize() {
		SIZE Size=void;
		
		auto size=ks[ITEM.WINDOW_FLOAT_SIZE].unSafe!(Integer[]);
		Size.cx = size[0];
		Size.cy = size[1];
		
		return Size;
	}
	/// ditto
	void floatSize(SIZE Size) {
		if(Size.cx < MIN_SIZE) Size.cx = MIN_SIZE;
		if(Size.cy < MIN_SIZE) Size.cy = MIN_SIZE;
		ks[ITEM.WINDOW_FLOAT_SIZE] = [Size.cx, Size.cy];
	}
	
	/// フロート位置
	const POINT floatPos() {
		POINT Pos=void;
		
		auto pos=ks[ITEM.WINDOW_FLOAT_POS].unSafe!(Integer[]);
		Pos.x = pos[0];
		Pos.y = pos[1];
		
		return Pos;
	}
	/// ditto
	void floatPos(POINT Pos) {
		ks[ITEM.WINDOW_FLOAT_POS] = [Pos.x, Pos.y];
	}

	/// フォルダ表示方法
	const FOLDER folder() {
		return cast(FOLDER)ks[ITEM.FOLDER].get!(Integer);
	}
	/// ditto
	void folder(FOLDER Folder) {
		ks[ITEM.FOLDER] = Folder;
	}

	/// フォルダ表示プログラム
	const string folderProgram() {
		return ks[ITEM.FOLDER_PROGRAM].unSafe!(string);
	}
	/// ditto
	void folderProgram(string Program) {
		ks[ITEM.FOLDER_PROGRAM] = Program;
	}
	/+
	/// フォルダ表示オプション。
	string folderOption() {
		return ks[ITEM.FOLDER_PROGRAM_OPTION].unSafe!(string);
	}
	/// ditto
	void folderOption(string Option) {
		ks[ITEM.FOLDER_PROGRAM_OPTION] = Option;
	}
	+/


	// 履歴数
	const Integer historyMax() {
		return ks[ITEM.LAUNCHER_HISTORY].unSafe!(Integer);
	}

	/// ボタン型の文字列表示。
	const bool exeButtonText() {
		return GetBool(ITEM.LAUNCHER_BUTTON_TEXT);
	}
	/// ditto
	void exeButtonText(bool ShowText) {
		ks[ITEM.LAUNCHER_BUTTON_TEXT] = ShowText;
	}
	///
	const bool exeButtonList() {
		return GetBool(ITEM.LAUNCHER_BUTTON_LIST);
	}
	///
	void exeButtonList(bool ListStyle) {
		ks[ITEM.LAUNCHER_BUTTON_LIST] = ListStyle;
	}
	
	/// ボタン型アイコンサイズ。
	const ICONSIZE exeButtonIcon() {
		return cast(ICONSIZE)ks[ITEM.LAUNCHER_BUTTON_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeButtonIcon(ICONSIZE IconSize) {
		ks[ITEM.LAUNCHER_BUTTON_ICON] = IconSize;
	}

	/// メニュー型表示文字列長。
	const Integer exeMenuText()
	out(r) {
		assert(r >= 0);
	}
	body {
		return ks[ITEM.LAUNCHER_MENU_TEXT].unSafe!(Integer);
	}
	/// ditto
	void exeMenuText(Integer TextLength)
	in {
		assert(TextLength >= 0);
	}
	body {
		ks[ITEM.LAUNCHER_MENU_TEXT] = TextLength;
	}
	/// メニュー型アイコンサイズ。
	const ICONSIZE exeMenuIcon() {
		return cast(ICONSIZE)ks[ITEM.LAUNCHER_MENU_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeMenuIcon(ICONSIZE IconSize) {
		ks[ITEM.LAUNCHER_MENU_ICON] = IconSize;
	}
	const bool exeMenuDeskTop() {
		return GetBool(ITEM.LAUNCHER_MENU_DESKTOP);
	}

	///  コマンド型ホットキー。
	const Integer[] exeCoomandHotkey() {
		return ks[ITEM.LAUNCHER_COMMAND_KEYS].unSafe!(Integer[]);
	}
	/// ditto
	void exeCoomandHotkey(Integer[] Keys)
	in {
		assert(Keys.length >= 2);
	}
	body {
		ks[ITEM.LAUNCHER_COMMAND_KEYS] = Keys;
	}

	/// コマンド型アイコンサイズ。
	const ICONSIZE exeCommandIcon() {
		return cast(ICONSIZE)ks[ITEM.LAUNCHER_COMMAND_ICON].unSafe!(Integer);
	}
	/// ditto
	void exeCommandIcon(ICONSIZE IconSize) {
		ks[ITEM.LAUNCHER_COMMAND_ICON] = IconSize;
	}

	/// コマンド型使用フォント。
	const Font exeCommandFont() {
		auto font=GetSystemFont(SYSFONT.MESSAGE);
		
		auto text=GetText(ITEM.LAUNCHER_COMMAND_FONT_NAME);
		if(text.length) {
			font.faceName = text;
		}
		auto height=ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE].unSafe!(Integer);
		if(height >= COMMAND_FONT_SIZE) {
			font.height   = height;
		}

		return font;
	}
	/// ditto
	void exeCommandFont(Font font) {
		if(font) {
			ks[ITEM.LAUNCHER_COMMAND_FONT_NAME] = font.faceName.toString();
			ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE] = font.height;
		} else {
			ks[ITEM.LAUNCHER_COMMAND_FONT_NAME] = string.init;
			ks[ITEM.LAUNCHER_COMMAND_FONT_SIZE] = Integer.min;
		}
	}

	/// コマンド型文字色
	static enum COMMANDCOLOR {
		//NORMAL,  /// 通常。
		/+
		ITEM,    /// アイテム。
		ADDRESS, /// アドレス。
		+/
		ID,      /// ID。
		NAME,    /// 名前
		TAG,     /// タグ
	}
	///
	const COLOR[] exeCommandColor(COMMANDCOLOR color)
	out(r) {
		assert(r.length >= 2);
	}
	body {
		Binary[] RawColors;
		switch(color) {
			//case COMMANDCOLOR.NORMAL:  return ks[ITEM.LAUNCHER_COMMAND_COLOR_NORMAL].unSafe!(Binary[]);
			/+
			case COMMANDCOLOR.ITEM:    return ks[ITEM.LAUNCHER_COMMAND_COLOR_ITEM].unSafe!(Binary[]);
			case COMMANDCOLOR.ADDRESS: return ks[ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS].unSafe!(Binary[]);
			+/
			case COMMANDCOLOR.ID:      RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_ID].unSafe!(Binary[]);   break;
			case COMMANDCOLOR.NAME:    RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME].unSafe!(Binary[]); break;
			case COMMANDCOLOR.TAG:     RawColors = ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG].unSafe!(Binary[]);  break;
			default: assert(false);
		}
		return [
			RawColors[0].length ? COLOR(RawColors[0]): cast(COLOR)SYSTEMCOLOR.WindowText,
			RawColors[1].length ? COLOR(RawColors[1]): cast(COLOR)SYSTEMCOLOR.WindowBack
		];
	}
	/// ditto
	void exeCommandColor(COMMANDCOLOR color, COLOR*[] Colors)
	in {
		assert(Colors.length >= 2);
	}
	body {
		Kareha ColorTree;
		switch(color) {
			//case COMMANDCOLOR.NORMAL:  ks[ITEM.LAUNCHER_COMMAND_COLOR_NORMAL]  = Colors;
			/+
			case COMMANDCOLOR.ITEM:    ks[ITEM.LAUNCHER_COMMAND_COLOR_ITEM]    = Colors;
			case COMMANDCOLOR.ADDRESS: ks[ITEM.LAUNCHER_COMMAND_COLOR_ADDRESS] = Colors;
			+/
			case COMMANDCOLOR.ID:      ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_ID];   break;
			case COMMANDCOLOR.NAME:    ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_NAME]; break;
			case COMMANDCOLOR.TAG:     ColorTree = ks[ITEM.LAUNCHER_COMMAND_COLOR_TAG];  break;
			default: assert(false);
		}
		ColorTree = cast(Binary[])[
			Colors[0] ? Colors[0].toRGBArray: null,
			Colors[1] ? Colors[1].toRGBArray: null
		];
	}
	
	///
	const Integer exeCommandTimer()
	out(r) {
		assert(r >= -1);
	}
	body {
		return ks[ITEM.LAUNCHER_COMMAND_TIMER].unSafe!(Integer);
	}
	/// ditto
	void exeCommandTimer(Integer Time)
	in {
		assert(Time >= -1);
	}
	body {
		ks[ITEM.LAUNCHER_COMMAND_TIMER] = Time;
	}
}

debug AkiDocument newApp() {
	return new AkiDocument(`
;ウィンドウ表示方法
Window:0
;前面表示
Window/Front:0
;左部サイズ
Window/Left:1
;上部サイズ
Window/Top:1
;右部サイズ
Window/Right:1
;下部サイズ
Window/Bottom:-1
;XY座標
Window/Float/Pos=0	0
;ウィンドウの大きさ
Window/Float/Size=1	1

;フォルダを開く方法
Folder:0
;↑の指定プログラム(アイテム)
Folder/Program\\e
;↑のオプション
Folder/Program/Option\\e

;ホットキーの使用フラグ
;[0] 使用しない(未指定)
;[1] 使用する
HotKey:0
;キー
;[第一要素] キー
;[第二要素] 修飾キー
HotKey/Keys=*


;ボタン型の文字列は表示させるか
;[0] 表示させない(通常)
;[1] 表示させる
Launcher/Button/Text:0
;ボタン型のアイコンサイズ
;[0] 16*16(通常)
;[1] 32*32
Launcher/Button/Icon:0

;メニュー型のテキスト文字数(0ですべて表示)
Launcher/Menu/Text:0
;メニュー型のアイコンサイズ
;[0] 16*16(通常)
;[1] 32*32
Launcher/Menu/Icon:0

;コマンド型のアイコンサイズ
;[*] 非表示
;[0] 16*16(通常)
;[1] 32*32
Launcher/Command/Icon:0
;コマンド型で使用するフォント名
;空でシステム
Launcher/Command/Font/Name\\e
;コマンド型で使用するフォントサイズ
;空でシステム
Launcher/Command/Font/Size:*
;コマンド型リスト表示における通常の前背景色(空ならシステム色)
Launcher/Command/Color/Normal!*	*
;コマンド型リスト表示におけるアイテムの場合の前背景色(空ならシステム色)
Launcher/Command/Color/Item!000000	ffffff
;コマンド型リスト表示におけるパスの場合の前背景色(空ならシステム色)
Launcher/Command/Color/Address!000000	ffffff
;コマンド入力ウィンドウが非アクティブになってから非表示までの秒数
;msで指定。(0なら即消滅)
Launcher/Command/Timer:200

			
		`.splitlines);
}


