﻿/**
ﾈﾑぃで使用する専用DLL。

D Interfaceで統一。

History:
	1.00β11:
		moduleをnemuxidllからpluginに変更。
		packageをnemuxi.dllからnemuxi.dll.pluginへ移動。
*/
module nemuxi.dll.plugin.plugin;

debug import std.stdio: wl = writefln, pl = printf;
debug(plugin) void main() {}

import core.memory;

import win32.windows;

import nemuxi.base;
import nemuxi.file.data;
import nemuxi.dll.dll;
public import nemuxi.dll.plugin.dllinterface;

/// rt.dmain2
private extern(C) {
	alias void  function(void*) gcSetFn;
	alias void  function()      gcClrFn;

	void* gc_getProxy();
}

abstract class NemuxiDLL: DLL {
	private {
		typedef void function(ref DLLINFOS) GetDllInfosType;
		GetDllInfosType GetDllInfos;
	}
	protected {
		DLLINFOS DllInfos;
	}
	override protected void Kill() {
		if(auto gcClr = address!(gcClrFn)(Text("gc_clrProxy"))) {
			gcClr();
		}
		
		super.Kill();
	}
	override this(in Text Path) {
		super(Path);

		if(auto gcSet = address!(gcSetFn)(Text("gc_setProxy"))) {
			gcSet(gc_getProxy());
		}

		DLLINFOS DllInfos;
		GetDllInfos = address!(GetDllInfosType)(Text("D12dllinterface12DllToolInfosFKS12dllinterface8DLLINFOSZv"));
		GetDllInfos(DllInfos);
	}

}






