﻿/**
フック用
*/
module nemuxi.dll.plugin.hooker.hooker;

debug import std.stdio: wl = writefln, pl = printf;
debug(hooker) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.dll.plugin.plugin;
import nemuxi.utility.controller;
import nemuxi.negui.window.newindow;


/// フック用定数
enum HOOK {
	CALLWNDPROC     = WH_CALLWNDPROC     , /// システムが目的のウィンドウプロシージャへ送信したメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 CallWndProc フックプロシージャの説明を参照してください。
	CALLWNDPROCRET  = WH_CALLWNDPROCRET  , /// 目的のウィンドウプロシージャが処理したばかりのメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 CallWndRetProc フックプロシージャの説明を参照してください。
	CBT             = WH_CBT             , /// コンピュータを利用したトレーニング（CBT）アプリケーションに有用な通知を受け取る 1 個のフックプロシージャをインストールします。詳細については、 CBTProc フックプロシージャの説明を参照してください。
	DEBUG           = WH_DEBUG           , /// ほかのフックプロシージャのデバッグに有用な 1 個のフックプロシージャをインストールします。詳細については、 DebugProc フックプロシージャの説明を参照してください。
	FOREGROUNDIDLE  = WH_FOREGROUNDIDLE  , /// アプリケーションのフォアグラウンドスレッドがアイドル状態になろうとしているときに呼び出される、1 個のフックプロシージャをインストールします。アイドル時に優先順位の低いタスクを実行する場合、このフックは役に立ちます。詳細については、 ForegroundIdleProc フックプロシージャの説明を参照してください。
	GETMESSAGE      = WH_GETMESSAGE      , /// メッセージキューへポストされたメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 GetMsgProc フックプロシージャの説明を参照してください。
	JOURNALPLAYBACK = WH_JOURNALPLAYBACK , /// WH_JOURNALRECORDフックプロシージャが既に記録したメッセージをポストする 1 個のフックプロシージャをインストールします。詳細については、 JournalPlaybackProc フックプロシージャの説明を参照してください。
	JOURNALRECORD   = WH_JOURNALRECORD   , /// システムメッセージキューへポストされた入力メッセージを記録する 1 個のフックプロシージャをインストールします。マクロを記録する際に、このフックは役立ちます。詳細については、 JournalRecordProc フックプロシージャの説明を参照してください。
	KEYBOARD        = WH_KEYBOARD        , /// キーストロークメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 KeyboardProc フックプロシージャの説明を参照してください。
	KEYBOARD_LL     = WH_KEYBOARD_LL     , /// Windows NT/2000：低水準のキーボード入力イベントを監視する 1 個のフックプロシージャをインストールします。詳細については、 LowLevelKeyboardProc フックプロシージャの説明を参照してください。
	MOUSE           = WH_MOUSE           , /// マウスメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 MouseProc フックプロシージャの説明を参照してください。
	MOUSE_LL        = WH_MOUSE_LL        , /// Windows NT/2000：低水準のマウス入力イベントを監視する 1 個のフックプロシージャをインストールします。詳細については、 LowLevelMouseProc フックプロシージャの説明を参照してください。
	MSGFILTER       = WH_MSGFILTER       , /// ダイアログボックス、メッセージボックス、メニュー、スクロールバーのいずれかへの入力イベントの結果として生成されたメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 MessageProc フックプロシージャの説明を参照してください。
	SHELL           = WH_SHELL           , /// シェルアプリケーションにとって有用な通知を受け取る 1 個のフックプロシージャをインストールします。詳細については、 ShellProc フックプロシージャの説明を参照してください。
	SYSMSGFILTER    = WH_SYSMSGFILTER    , /// ダイアログボックス、メッセージボックス、メニュー、スクロールバーのいずれかへの入力イベントの結果として生成されたメッセージを監視する 1 個のフックプロシージャをインストールします。このフックプロシージャは、呼び出し側スレッドと同じデスクトップ内のすべてのアプリケーションを対象とするこれらのメッセージを監視します。詳細については、 SysMsgProc フックプロシージャの説明を参照してください。
}

struct HOOKDATA {
	UINT Code;
	WPARAM wParam;
	LPARAM lParam;
	bool Chain; /// とりあえずtrue。
}

final class HookerDLL: NemuxiDLL, IController {
	static immutable WM_HOOKER=WM_APP + 0xB000;
	typedef HHOOK function(HWND hWnd, HOOK Hook, UINT Message) RegistHookType;
	typedef bool function() UnRegistHookType;
	//UnRegistHook
	private {
		RegistHookType   RegistHook;
		UnRegistHookType UnRegistHook;
	}

	private {
		HWND hWnd;
		HHOOK hHook;
	}
	
	
	this(in NeWindow window)
	in {
		assert(window.alive);
	}
	body {
		super(StaticData.dllHooker);

		RegistHook   = address!(RegistHookType)  (Text("D8hookfunc10RegistHookFT5win325winnt6HANDLEE7hookdef4HOOKkZT5win327winuser5HHOOK"));
		UnRegistHook = address!(UnRegistHookType)(Text("D8hookfunc12UnRegistHookFZb"));

		hWnd = window();
	}

	bool start() {
		enforce(hHook = RegistHook(hWnd, HOOK.MOUSE_LL, WM_HOOKER), new NemuxiException(Err.toString));
		return true;
	}
	bool stop() {
		bool Ret;

		if(hHook) {
			Ret = UnRegistHook();
		}
		hHook = HHOOK.init;
		
		return Ret;
	}
	const bool isRunning() {
		return cast(bool)hHook;
	}
}


