﻿/**

History:
	1.00β11:
		packageをnemuxi.utilityからnemuxi.dllへ移動。
*/
module nemuxi.dll.dll;

debug import std.stdio: wl = writefln, pl = printf;
debug(dll) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.base;
import nemuxi.system.raii;

/**
*/
class DLL: Raii {
	protected HMODULE hDLL;
	mixin KillResource!("DLL", hDLL, FreeLibrary, 0);

	this(in Text Path) {
		enforce(hDLL = LoadLibrary(Path.ptr), new NemuxiException(Path));
		super(true);
	}

	final const HMODULE opCall() {
		return hDLL;
	}

	RET address(RET, T)(in T Address) const {
		static if(is(T == Text)) {
			return cast(RET)GetProcAddress(hDLL, Address.toStringz);
		} else static if(is(T == int)) {
			return cast(RET)GetProcAddress(hDLL, cast(LPCSTR)Address);
		} else {
			pragma(msg, "oh!");
			static assert(false, T.stringof);
		}
	}
}

