﻿/**

*/
module nemuxi.base;

debug(base) void main() {}

debug import std.string;

import win32.windows;
import win32.commctrl;

invariant auto MY_MAX_NAME = 255 + 1;
invariant auto MY_MAX_PATH = 32767 + MY_MAX_NAME + 1;
debug(base) unittest {
	assert(!(MY_MAX_NAME % 4));
	assert(!(MY_MAX_PATH % 4));
}

public import nemuxi.system.text;
public import nemuxi.system.log;
public import nemuxi.system.nemuxierrors;
public import nemuxi.system.err;
public import nemuxi.system.staticdata;
import nemuxi.file.file;
import nemuxi.utility.name;
import nemuxi.system.timer;

debug void wll(string file=__FILE__, int line=__LINE__) {
	wl("%s(%s)", file,line);
}

/**
History:
	1.00β11:
		いらない子。

Deprecated:
	nemuxi.file.file.PATH.myPath, nemuxi.file.file.PATH.myFolder
*/
deprecated Text MyPath(bool Folder=false) {
	// 最悪だ
	debug(nemuxi) {
		auto text=new wchar[MY_MAX_PATH];

		if(!GetModuleFileName(GetModuleHandle(null), text.ptr, MY_MAX_PATH)) {
			throw new NemuxiException("自分の居場所さえ分からない", EC.NEMUXI_MYPATH);
		}
		//Text Path = text.ptr;
		if(Folder) {
			//return FolderName(Text(text.ptr));
			return PATH.getOwnerFolder(Text(text.ptr));
		}
		
		return Text(text.ptr);
	} else debug{
		return Text(`Z:\nemuxi\nemuxi\` ~ (Folder ? "": "nemuxi.exe"));
	} else {
		auto text=new wchar[MY_MAX_PATH];

		if(!GetModuleFileName(GetModuleHandle(null), text.ptr, MY_MAX_PATH)) {
			throw new NemuxiException("自分の居場所さえ分からない", EC.NEMUXI_MYPATH);
		}

		if(Folder) {
			return PATH.getOwnerFolder(Text(text.ptr));
		}
		
		return Text(text.ptr);
	}
}
/**
History:
	1.00β11, 2009/08/24:
		いらない子。

Deprecated:
	StaticData.dataFolder
*/
deprecated Text GetUserFolder() {
	auto DatFolder = MyPath(true) ~ `data\`;
	return DatFolder ~ UserName();
}

debug(base) unittest {
	auto e=new NemuxiException("asd");
	try{
		throw e;
	} catch(Exception e) {
		wl(e.toString);
	}
}

