﻿/**
*/
module hooker;

/*
 * MyDll D言語DLLの書き方デモ
 */

import std.c.stdio;
import core.runtime;
import std.c.stdlib;
//import std.string;
import std.c.windows.windows;

import importmodule;

HINSTANCE   g_hInst;

extern(C) {
	void gc_setProxy(void* p);
	void gc_clrProxy();
}

extern (Windows) BOOL DllMain(HINSTANCE hInstance, ULONG ulReason, LPVOID pvReserved) {
	switch (ulReason) {
		case DLL_PROCESS_ATTACH:
			Runtime.initialize();
			break;

		case DLL_PROCESS_DETACH:
			Runtime.terminate();
			break;

		case DLL_THREAD_ATTACH:
			std.c.stdio._fcloseallp = null; // 標準入出力を閉じないように
			return false;

		case DLL_THREAD_DETACH:
			return false;
	
		default:
	}
	
	g_hInst = hInstance;
	
	return true;
}

export void MyDLL_Initialize(void* gc) {
	gc_setProxy(gc);
}

export void MyDLL_Terminate() {
	gc_clrProxy();
}

