﻿/***/
module hookdef;

import win32.windows;

/// フック用定数
enum HOOK {
	CALLWNDPROC     = WH_CALLWNDPROC     , /// システムが目的のウィンドウプロシージャへ送信したメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 CallWndProc フックプロシージャの説明を参照してください。
	CALLWNDPROCRET  = WH_CALLWNDPROCRET  , /// 目的のウィンドウプロシージャが処理したばかりのメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 CallWndRetProc フックプロシージャの説明を参照してください。
	CBT             = WH_CBT             , /// コンピュータを利用したトレーニング（CBT）アプリケーションに有用な通知を受け取る 1 個のフックプロシージャをインストールします。詳細については、 CBTProc フックプロシージャの説明を参照してください。
	DEBUG           = WH_DEBUG           , /// ほかのフックプロシージャのデバッグに有用な 1 個のフックプロシージャをインストールします。詳細については、 DebugProc フックプロシージャの説明を参照してください。
	FOREGROUNDIDLE  = WH_FOREGROUNDIDLE  , /// アプリケーションのフォアグラウンドスレッドがアイドル状態になろうとしているときに呼び出される、1 個のフックプロシージャをインストールします。アイドル時に優先順位の低いタスクを実行する場合、このフックは役に立ちます。詳細については、 ForegroundIdleProc フックプロシージャの説明を参照してください。
	GETMESSAGE      = WH_GETMESSAGE      , /// メッセージキューへポストされたメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 GetMsgProc フックプロシージャの説明を参照してください。
	JOURNALPLAYBACK = WH_JOURNALPLAYBACK , /// WH_JOURNALRECORDフックプロシージャが既に記録したメッセージをポストする 1 個のフックプロシージャをインストールします。詳細については、 JournalPlaybackProc フックプロシージャの説明を参照してください。
	JOURNALRECORD   = WH_JOURNALRECORD   , /// システムメッセージキューへポストされた入力メッセージを記録する 1 個のフックプロシージャをインストールします。マクロを記録する際に、このフックは役立ちます。詳細については、 JournalRecordProc フックプロシージャの説明を参照してください。
	KEYBOARD        = WH_KEYBOARD        , /// キーストロークメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 KeyboardProc フックプロシージャの説明を参照してください。
	KEYBOARD_LL     = WH_KEYBOARD_LL     , /// Windows NT/2000：低水準のキーボード入力イベントを監視する 1 個のフックプロシージャをインストールします。詳細については、 LowLevelKeyboardProc フックプロシージャの説明を参照してください。
	MOUSE           = WH_MOUSE           , /// マウスメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 MouseProc フックプロシージャの説明を参照してください。
	MOUSE_LL        = WH_MOUSE_LL        , /// Windows NT/2000：低水準のマウス入力イベントを監視する 1 個のフックプロシージャをインストールします。詳細については、 LowLevelMouseProc フックプロシージャの説明を参照してください。
	MSGFILTER       = WH_MSGFILTER       , /// ダイアログボックス、メッセージボックス、メニュー、スクロールバーのいずれかへの入力イベントの結果として生成されたメッセージを監視する 1 個のフックプロシージャをインストールします。詳細については、 MessageProc フックプロシージャの説明を参照してください。
	SHELL           = WH_SHELL           , /// シェルアプリケーションにとって有用な通知を受け取る 1 個のフックプロシージャをインストールします。詳細については、 ShellProc フックプロシージャの説明を参照してください。
	SYSMSGFILTER    = WH_SYSMSGFILTER    , /// ダイアログボックス、メッセージボックス、メニュー、スクロールバーのいずれかへの入力イベントの結果として生成されたメッセージを監視する 1 個のフックプロシージャをインストールします。このフックプロシージャは、呼び出し側スレッドと同じデスクトップ内のすべてのアプリケーションを対象とするこれらのメッセージを監視します。詳細については、 SysMsgProc フックプロシージャの説明を参照してください。
}

struct HOOKDATA {
	UINT Code;
	WPARAM wParam;
	LPARAM lParam;
	bool Chain; /// 次へ移す場合はtrue。
}
