﻿/**
キーボード用文字列。

History:
	1.051:
		新規作成。
*/
module nemuxi.utility.filter.key;

debug import std.stdio: wl = writefln, pl = printf;
debug(key) void main() {}

import nemuxi.negui.system.base;
public import nemuxi.utility.filter.filter;
debug import nemuxi.negui.input.keyboard.keyboard;

/**
History:
	1.051:
		新規作成。
*/
Text toKeyText(in Text text)
out(r) {
	debug foreach(c; r.text) {
		assert(toKey(c)!= KEY.NONE);
	}
}
body {
	immutable Pattern=
		`A-Z`w
		`a-z`
		`0-9`
	;
	
	return ErasePattern(text, Pattern.toText.quot("[^", "]"));
}
debug(key) unittest {
	Text t;

	t = "a b c";
	assert(toKeyText(t) == "abc");

	t = "123$%&789";
	assert(toKeyText(t) == "123789");

	t = "";
	assert(toKeyText(t) == "");

	t = "あいうえお";
	assert(toKeyText(t) == "");
	
	t = "aあい@うえ;おB";
	assert(toKeyText(t) == "aB");
}

