﻿/**
抽出モジュール。

文字列から特定の語句を抜き取る。
変換と何が違うんだろうと思うけど違うったら違うんだ。
*/
module nemuxi.utility.filter.filter;

debug import std.stdio: wl = writefln, pl = printf;
debug(filter) void main() {}

import std.regex;
/+
//import nemuxi.system.nemuxierrors;
import nemuxi.negui.system.text;
//import nemuxi.system.text;
import nemuxi.system.exception;
+/
import nemuxi.negui.system.base;
import nemuxi.system.exception;

///
//mixin(ThrowableClasses("Filter"));
///
class FilterException: NemuxiException {
	mixin MixInNemuxiException;
}

///
typedef void function(in Text) FilterFunctionType;
///
typedef void delegate(in Text) FilterDelegateType;


Text ErasePattern(in Text Target, in Text Pattern) {
	auto reg=regex(Pattern.toString, "g");
	return replace(Target.toString, reg, "").toText;
}
debug(filter) unittest {
	Text t;
	
	t = "123.456.789";
	assert(ErasePattern(t, Text(`\.`)) == "123456789");
	assert(ErasePattern(t, Text(`\d`)) == "..");
	assert(ErasePattern(t, Text(`[1-8]`)) == "..9");
	assert(ErasePattern(t, Text(`[^1-8]`)) == "12345678");
}


