﻿/**

*/
module nemuxi.utility.convert.item;

debug import std.stdio: wl = writefln, pl = printf;

import std.uni;
import std.contracts;

/+
import nemuxi.base;
import nemuxi.negui.file.file;
import nemuxi.file.items.item;
public import nemuxi.utility.convert.convert;
import nemuxi.utility.filter.item;
public import nemuxi.negui.input.keyboard.keyboard;
+/

import nemuxi.file.items.item;
import nemuxi.utility.filter.item;
import nemuxi.negui.system.base;
import nemuxi.negui.file.file;
public import nemuxi.utility.convert.convert;
import nemuxi.negui.input.keyboard.keyboard;
import nemuxi.utility.filter.key;

/**
アドレスからIDを取得。
*/
Text GetIdFromFileAddress(in Text Address)
out(r) {
	assert(Item.isID(r));
}
body {
	enforce(Address.length, new ConvertException("ファイルアドレス未入力"));

	Text SafeName;
	auto FileName = PATH.getName(Address);
	if(FileName.length) {
		// ファイル？
		if(Item.isID(FileName)) {
			SafeName = FileName;
		} else {
			SafeName = SafeId(FileName);
		}
	} else {
		// ファイルアドレス以外
		SafeName = SafeId(Address);
	}
	enforce(SafeName.length, new ConvertException("変換文字列長不正"));

	return SafeName;
}

/**
アドレスから名前を取得。

History:
	1.00β12:
		新規作成。
*/
Text GetNameFromFileAddress(in Text Address) {
	enforce(Address.length, new ConvertException("アドレスが未入力"));

	auto Name=PATH.getName(Address);

	//隠しファイル形式.xxxxxの場合は拡張子しかない。
	if(Name.length) {
		return Name;
	} else {
		return PATH.getFileName(Address);
	}
}

/**
テキストからキーに変換。

Note:
	こいつはConvertFunctionTypeに沿わない。

History:
	1.00β12:
		新規作成。
*/
KEY GetKeyFromText(in Text text) {
	enforce(text.length, new ConvertException("キーの元となる文字列が未入力"));

	/+
	foreach(c; text.text) {
		if(isUniAlpha(c)) {
			return cast(KEY)toUniUpper(c);
		}
	}

	throw new ConvertException(text ~ "には変換可能文字無し");
	+/
	const KeyText=toKeyText(text);

	enforce(KeyText.length, new ConvertException("キー変換文字なし。"));

	return toKey(KeyText[0]);
}

