﻿/**
テスト専用ダイアログ。
*/
module nemuxi.test.tabbbb;

debug import std.stdio: wl = writefln, pl = printf;
debug(tabbbb) void main() {}

import win32.windows;

//import nemuxi.base;
//import nemuxi.image.font;
import nemuxi.negui.system.base;
import nemuxi.negui.system.type.base;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
import nemuxi.negui.window.dialog.dialog;
import nemuxi.negui.layout.panel.line;
import nemuxi.negui.control.control;
import nemuxi.negui.control.button.button;
import nemuxi.negui.control.editbox.editbox;
import nemuxi.negui.control.tab.tab;


debug{} else {static assert(false, "debug only!");}
class TabDialog: ModalDialog {

	Tab tab;

	Push[5] btn;
	EditLine[5] edt;
	this(NeWindow Owner) {
		NEGUIINFO NeGuiInfo;
		NeGuiInfo.owner   = Owner;
		super(NeGuiInfo);
		move(200,200,300,300);
	}
	protected override {
		void OnDestroy() {
			super.OnDestroy();
		}
		void OnCreate() {
			super.OnCreate();
			caption=true;
			systemMenu=true;
			frameSize=true;

			tab = new Tab(this, 10);

			TABITEM ti;
			auto ts=Texts("あ","い","う","え","お");
			auto pos=0;
			with(TABITEM) foreach(i, t; ts) {
				ti.mask = MASK.TEXT;
				ti.text = t;
				pos=tab.insert(pos+1, ti);
			}
			auto tvs=new TABVALUE[5];
			foreach(i, ref tv; tvs) {
				auto panel=new Line(DIRECTION.VERTICAL);
				panel += btn[i] = new Push(tab, cast(ITEM_ID)(100+i));
				panel += edt[i] = new EditLine(tab, cast(ITEM_ID)(200+i));
				panel.sizeInfo(0).percent = 50;
				panel.sizeInfo(1).absolute = 20;
				tv.inItems = [cast(Control)btn[i], edt[i]];
				tv.basePanel = panel;
			}
			tab.values = tvs;
			//tab.lineStyle=Tab.LINESTYLE.MULTI;
			tab.lineStyle=Tab.LINESTYLE.SINGLE;

			auto l=new Line(DIRECTION.HORIZON);
			l += tab;
			l.sizeInfo(0).percent=100;
			layoutManager.basePanel = l;
		}
		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui gui) {
			return false;
		}
		int OnNotify(ITEM_ID Id, NOTIFY* Notify) {
			if(Id == 10) {
				switch(Notify.code) {
					case Tab.EVENT.SELCHANGE:
						auto pos=tab.select;
						tab.change(pos);
					return 1;
					default: return 0;
				}
			}
			return 0;
		}
	}
}


