﻿/**
*/
module nemuxi.system.staticdata;

debug import std.stdio: wl = writefln, pl = printf;
debug(staticdata) void main() {}

import std.uni;
import std.conv;
import std.string;
import std.stream;

import etc.kareki.kareki;


//import nemuxi.base;
import nemuxi.negui.system.text;
import nemuxi.negui.system.literal;
import nemuxi.negui.system.meta.memberproperty;
//import nemuxi.system.log;
import nemuxi.negui.file.file;
//import nemuxi.file.folder;
import nemuxi.file.data;
import nemuxi.negui.environ.variable;
;
//import nemuxi.utility.meta.memberproperty;
//import nemuxi.negui.window.dialog.system;


private string Getter(in string Member) {
	auto Method = cast(char)toUniLower(Member[0]) ~ Member[1..$];
	
	return `
	
	static Text ` ~ Method ~ `() {
		return ` ~ Member ~ `.toText;
	}
	
	`;
}

/**
固定値。

設定ミスによるﾈﾑぃの異常を許可。

Note:
	ループ時のメモリ確保値って徹底されてないからあんまり意味ないんよね。

History:
	1.080:
		[P] sticky関連追加。

	1.050:
		[P] タスクトレイの待ち時間とループ回数追加。

	1.00β17:
		[P] ループ時増加要素と初期要素数の追加。

	1.00β12:
		ログフォルダ・フラグ追加。
*/
static class StaticData {
	
	private static immutable {
		auto DATAFOLDER_AKI = "folder/data";
		auto DATAFOLDER_DEF = `<NEMUXI>\data\%USERNAME%\`;
		auto TEMPORARYFOLDER_AKI = "folder/temp";
		auto TEMPORARYFOLDER_DEF = `%TEMP%\nemuxi\`;
		auto RESOURCEFOLDER_AKI = "folder/res";
		auto RESOURCEFOLDER_DEF = `<NEMUXI>\resource\`;
		auto LANGUAGEFOLDER_AKI = "folder/lang";
		auto LANGUAGEFOLDER_DEF = `<NEMUXI>\resource\language\`;
		auto LOGFOLDER_AKI      = "folder/log";
		auto LOGFOLDER_DEF      = `<NEMUXI>\log\`;

		auto APPLICATIONDATAFILE_AKI = "file/data/application";
		auto APPLICATIONDATAFILE_DEF = `app.aki`;
		auto GROUPDATAFILE_AKI       = "file/data/groups";
		auto GROUPDATAFILE_DEF       = `groups.aki`;
		auto ITEMDATAFILE_AKI        = "file/data/items";
		auto ITEMDATAFILE_DEF        = `items.aki`;
		auto FOLDERNAME_STICKY_AKI   = "file/data/sticky";
		auto FOLDERNAME_STICKY_DEF   = `sticky`;

		auto PLUGINFOLDER_AKI = "folder/plugin";
		auto PLUGINFOLDER_DEF = `<NEMUXI>\plugin\`;
		auto PLUGIN_HOOKER_AKI= "file/plugin/hooker";
		auto PLUGIN_HOOKER_DEF= `Hooker.dll`;

		auto HELPFILE_AKI = "help";
		auto HELPFILE_DEF = `<NEMUXI>\help\help.hta`;

		auto SETTING_LOG_AKI_AKI = "setting/log";
		auto SETTING_LOG_AKI_DEF = 0;
		
		auto SETTING_LOOP_INIT_AKI = "setting/loop/init";
		auto SETTING_LOOP_INIT_DEF = BUFFER.INITIAL;
		auto SETTING_LOOP_PLUS_AKI = "setting/loop/plus";
		auto SETTING_LOOP_PLUS_DEF = BUFFER.INCREMENT;

		auto SETTING_TASKTRAY_RETRY_AKI = "setting/tasktray/retry";
		auto SETTING_TASKTRAY_RETRY_DEF = 10;
		auto SETTING_TASKTRAY_WAIT_AKI = "setting/tasktray/wait";
		auto SETTING_TASKTRAY_WAIT_DEF = 500;
		
		auto SETTING_MUTEX_USE_AKI = "setting/mutex/use";
		auto SETTING_MUTEX_USE_DEF = 1;
		auto SETTING_MUTEX_NAME_AKI = "setting/mutex/name";
		auto SETTING_MUTEX_NAME_DEF = "Nemuxi";
	}
	private static immutable {
		wstring DataFolder;
		wstring TemporaryFolder;
		wstring ResourceFolder;
		wstring LanguageFolder;
		wstring LogFolder;

		wstring ApplicationDataFile;
		wstring GroupDataFile;
		wstring ItemDataFile;
		wstring StickyDataFolder;

		wstring[][] FileFilter;

		wstring DllHooker;

		wstring Help;

		wstring MutexName;

	}
	static immutable {
		bool logEnable;
		size_t loopInit;
		size_t loopPlus;
		size_t taskTrayRetry;
		size_t taskTrayWait;

		size_t mutex;
	}
	mixin(Getter(q{DataFolder}));
	mixin(Getter(q{TemporaryFolder}));
	mixin(Getter(q{ResourceFolder}));
	mixin(Getter(q{LanguageFolder}));
	mixin(Getter(q{LogFolder}));
	
	mixin(Getter(q{ApplicationDataFile}));
	mixin(Getter(q{ItemDataFile}));
	mixin(Getter(q{GroupDataFile}));
	mixin(Getter(q{StickyDataFolder}));
	

	mixin(Getter(q{DllHooker}));

	mixin(Getter(q{Help}));

	mixin(Getter(q{MutexName}));
	
	static Text[][] fileFilter() {
		Text[][] Filters;
		
		foreach(i, filter;FileFilter) {
			Filters ~= Texts(filter);
		}

		return Filters;
	}

	static private {
		/**
		History:
			1.00β11:
				MyPathの埋め合わせ。
		*/
		string NemuxiToPlain(in string src) {
			//auto s=replace(src, "<NEMUXI>", PATH.delFolderSep(MyPath(true)).toString);
			auto s=replace(src, "<NEMUXI>", PATH.delFolderSep(PATH.myFolder).toString);
			return s;
		}

		/**
		History:
			1.00β11:
				MyPathの埋め合わせ。
		*/
		wstring GetPlain(AkiDocument aki, string tree, string def) {
			return toPlain(NemuxiToPlain(aki.defGet(tree, def)).toText).idup;
		}
	}

	
	/**
	History:
		1.080:
			[B] loopInit, loopPlusの値が実質死んでた。
	
		1.070:
			[F] dynamic.aki追加。
	
		1.00β11:
			MyPathの埋め合わせ。
			各変数へのGetPlainの使用。
	*/
	static this() {
		AkiDocument aki;
		scope(exit) delete aki;
		Throwable ReadE;
		//scope(exit) Logger.write(ReadE);
		try {
			auto MyFolder=PATH.myFolder;
			Text DynamicFile;
			debug(staticdata) {
				//auto file=MyFolder ~ `..\static.aki`;
				aki = ReadAkiDocument(MyFolder ~ `..\static.aki`);
				DynamicFile = MyFolder ~ `..\dynamic.aki`;
			} else {
				//auto file=MyFolder ~ `.\static.aki`;
				aki = ReadAkiDocument(MyFolder ~ `.\static.aki`);
				DynamicFile = MyFolder ~ `.\dynamic.aki`;
			}
			if(FILE.isFile(DynamicFile)) {
				aki.importDocument(ReadTextData(DynamicFile));
			}
			/+
			auto data=new BufferedFile(file.toString);
			scope bom=new EndianStream(data);
			bom.readBOM;
			string[] datas;
			foreach(char[] line; data) {
				datas ~= line.idup;
			}
			aki = new AkiDocument(datas);
			+/
		} catch(Throwable e) {
			ReadE = e;
			//aki = new AkiDocument();
		}
		if(!aki) {
			aki = new AkiDocument();
		}

		// データフォルダ
		DataFolder = GetPlain(aki, DATAFOLDER_AKI, DATAFOLDER_DEF);
		
		// 一時フォルダ
		TemporaryFolder = GetPlain(aki, TEMPORARYFOLDER_AKI, TEMPORARYFOLDER_DEF);
		// リソースフォルダ
		ResourceFolder = GetPlain(aki, RESOURCEFOLDER_AKI, RESOURCEFOLDER_DEF);
		// 言語フォルダ
		LanguageFolder = GetPlain(aki, LANGUAGEFOLDER_AKI, LANGUAGEFOLDER_DEF);
		// ログフォルダ
		LogFolder = GetPlain(aki, LOGFOLDER_AKI, LOGFOLDER_DEF);

		// プログラムファイル
		ApplicationDataFile = GetPlain(aki, APPLICATIONDATAFILE_AKI, APPLICATIONDATAFILE_DEF);
		// グループファイル
		GroupDataFile = GetPlain(aki, GROUPDATAFILE_AKI, GROUPDATAFILE_DEF);
		// アイテムファイル
		ItemDataFile = GetPlain(aki, ITEMDATAFILE_AKI, ITEMDATAFILE_DEF);
		// 付箋ファイル
		StickyDataFolder = GetPlain(aki, FOLDERNAME_STICKY_AKI, FOLDERNAME_STICKY_DEF);

		
		if("filter" in aki) {
			auto Filters=aki.defGet!(string[])("filter", ["all"]);
			wstring[][] FilterLines;
			foreach(Filter; Filters) {
				auto Exts=aki[["filter", Filter]].defGet!(string[])(["*"]);
				auto FilterLine=new wstring[Exts.length];
				foreach(i, Ext; Exts) {
					FilterLine[i] = to!(wstring)(Ext);
				}
				FilterLines ~= FilterLine;
			}
			FileFilter= cast(immutable wstring[][])FilterLines;
		} else {
			FileFilter = [["all"w, "*"]];
		}

		// ヘルプファイル
		Help = GetPlain(aki, HELPFILE_AKI, HELPFILE_DEF);

		// 設定
		logEnable = cast(bool)aki.defGet(SETTING_LOG_AKI_AKI, cast(Integer)SETTING_LOG_AKI_DEF);
		
		loopInit = aki.defGet(SETTING_LOOP_INIT_AKI, cast(Integer)SETTING_LOOP_INIT_DEF);
		loopPlus = aki.defGet(SETTING_LOOP_PLUS_AKI, cast(Integer)SETTING_LOOP_PLUS_DEF);
		
		mutex = cast(bool)aki.defGet(SETTING_MUTEX_USE_AKI, cast(Integer)SETTING_MUTEX_USE_DEF);
		MutexName = to!(wstring)(aki.defGet!(string)(SETTING_MUTEX_NAME_AKI, SETTING_MUTEX_NAME_DEF));

		taskTrayRetry = aki.defGet(SETTING_TASKTRAY_RETRY_AKI, cast(Integer)SETTING_TASKTRAY_RETRY_DEF);
		taskTrayWait  = aki.defGet(SETTING_TASKTRAY_WAIT_AKI,  cast(Integer)SETTING_TASKTRAY_WAIT_DEF);

		
		// Plugin -------------------------
		const Plugin = GetPlain(aki, PLUGINFOLDER_AKI, PLUGINFOLDER_DEF);
		
		// フック
		DllHooker = Plugin ~ GetPlain(aki, PLUGIN_HOOKER_AKI, PLUGIN_HOOKER_DEF);

	}

	/**
	History:
		1.081:
			新規作成。
	*/
	static void check() {
	}
}

