﻿/**
Bugs:
	こいつはもう駄目だ…。
*/
module nemuxi.system.log;

debug import std.stdio: wl = writefln, pl = printf;
debug(log) void main() {}

import std.file;
import std.string;
import std.conv;
import std.stream;

import nemuxi.negui.system.base;
import nemuxi.negui.system.meta.basic;
import nemuxi.negui.file.file;
//import nemuxi.system.timer;
//import nemuxi.system.text;
import nemuxi.system.staticdata;
import nemuxi.utility.simple.sysinfo;


/**
help! help! help!
わけわからん
*/
static ~this() {
	if(Logger.flag) Logger.flag = false;
}


/**

Note:
	出力の強化。

History:
	1.021:
		[@] よくわからんけど動いてるからよし。
	
	1.00β19:
		[@] あれ？ うごいてる？ 原因はフックか？
	
	1.00β13:
		[B] β12のHistory項目確実に嘘だろ。夢でも見てたんか？
		    動くようにはした。
		
	1.00β12:
		半ば死んでたログ機能を活性化。
		これに伴い各moduleにて変更部分あり。
		今後ログ機能に関するHistory:の記述は基本的にしない方針。
*/
static struct Logger {
	invariant() {
		if(Flag) assert(fs);
		else     assert(!fs);
	}
	static bool Flag;
	
	static private {
		BufferedFile fs=null;
	}

	static bool flag() {
		return Flag;
	}
	/**
	History:
		1.00β12:
			nemuxi.system.log.writeの引数変更に伴う修正。
	
		1.00β11:
			ログ開始時にシステム情報の書き出し。
	*/
	static void flag(in bool Flag) {
		if(Flag) {
			auto date=new DateTime();
			date.format = "[YYYY]-[M]-[DD]([W]) [hh]-[mm]-[ss].log";
			const path = StaticData.logFolder ~ date.toString();
			//if(!exists(DIR)) mkdir(DIR);
			if(!FILE.isExistence(StaticData.logFolder)) {
				FILE.makeFolder(StaticData.logFolder);
			}
			this.Flag = Flag;
			fs = new BufferedFile(path.toString(), FileMode.OutNew);
			write("Log Start.%s%s", newline[], toTextInformation);
		} else {
			if(fs) {
				write("Log End.");
				fs.close();
			}
			this.Flag = Flag;
			delete fs;
		}
	}

	/**
	History:
		1.00β14:
			修正？
	
		1.00β12:
			引数を変更。
	*/
	static void write(string file=__FILE__, int line=__LINE__, T...)(lazy T msgs) {
		if(!Flag) {
			return;
		} else {
			assert(fs);
		}

		auto date=new DateTime();
		date.format = "[YYYY]/[M]/[D] [h]:[m]:[s].[ms]";
		
		string data;
		static if(msgs.length == 1) {
			data = to!(string)(msgs[0]);
		} else {
			static if(
				is(T[0] == string)  ||
				is(T[0] == wstring) ||
				is(T[0] == dstring) ||
				is(T[0] == Text)
			) {
				string f;
				static if(is(T[0] == string)) {
					f = msgs[0];
				} else static if(is(T[0] == Text)) {
					f = msgs[0].toString;
				} else {
					f = to!(string)(msgs[0]);
				}
				// 第一要素は書式
				data = format(f, msgs[1..$]);
			} else {
				// なんか
				string[] ss;
				foreach(i, value; msgs) {
					static if(is(T[i] == Text)) {
						ss ~= format("<%s: %s> %s", i, T[i].stringof, value.toString);
					} else {
						ss ~= format("<%s: %s> %s", i, T[i].stringof, value);
					}
				}
				data = ss.join(newline);
			}
		}

		auto s=format(
			"<%s> %s(%s)%s%s%s",
			date,
			file,
			line,
			repeat("=", 20),
			newline,
			data
		);
		fs.writeLine(s ~ newline);
		fs.flush;
	}

	static {
		private size_t IncrementNumber;
		static Log log(in Text Name, size_t Number=IncrementNumber++) {
			return new Log(Name, Number);
		}
		static Log log(in string Name, size_t Number=IncrementNumber++) {
			return new Log(Name.toText, Number);
		}
	}
}

/**
関連付けログ。

Loggerから生成して使用。

History:
	1.021:
		新規作成。
*/
class Log {
	private {
		size_t Number;
		Text   Name;
		immutable string LogID;
	}

	private this(in Text Name, size_t Number) {
		this.Name = Name.dup;
		this.Number = Number;

		LogID = Text("%s[%08s] >>%s", Name, Number, newline).text8;
	}

	void write(string file=__FILE__, int line=__LINE__, T...)(lazy T msgs) {
		Logger.write!(file, line, string, T)(LogID, msgs);
	}
}
/**
History:
	1.022:
		新規作成。
*/
pure nothrow string SMixInLog(string log="log")(string LogName, string StartName="")
in {
	assert(log.length);
	assert(LogName.length);
}
body {
	string _name;
	if(StartName.length) {
		_name = StartName ~ ' ';
	}
	
	return `

	scope ` ~ log ~ ` = Logger.log("` ~ LogName ~ `");
	
	` ~ log ~ `.write("` ~ _name ~ `" ~ "start...");
	scope(exit) ` ~ log ~ `.write("` ~ _name ~ `" ~ "exit.");
	scope(success) ` ~ log ~ `.write("` ~ _name ~ `" ~ "success.");
	scope(failure) ` ~ log ~ `.write("` ~ _name ~ `" ~ "failure.");

	`;
}

debug(log) unittest {
	mixin(SMixInLog!("lllll")("asd"));
}

