﻿/**
History:
	1.00β19:
		[P] とりあえず目に着いたところから変換中。
	
	1.00β12:
		packageをnemuxiからnemuxi.systemへ移動。
		module名をlangからlanguageへ変更。
*/
module nemuxi.system.language;

debug import std.stdio: wl = writefln, pl = printf;
debug(language) void main() {}

import etc.kareki.kareki;

import nemuxi.file.items.item;
import nemuxi.file.setting;
import nemuxi.file.exec;
import nemuxi.file.folder;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.type.record;

import nemuxi.negui.negui;
import nemuxi.negui.draw.icon;

//import nemuxi.system.text;
import nemuxi.system.type;
//import nemuxi.system.log;


/**
無駄にでかいなぁ。
*/
static struct LanguageData {
	static:
	AkiDocument Base;

	private alias PAIR!(string, string) TreeDefPair;

	void loadDocument(AkiDocument aki)
	in {
		assert(aki);
	}
	body {
		Base = aki;
	}

	enum DIALOG {
		EX,
		COMMAND,
		INPUT,
		SETTING,
		VERSION,
		ERROR,
	}
	Text dialog(DIALOG Dialog) {
		TreeDefPair pair=void;
		
		with(DIALOG) final switch(Dialog) {
			case EX:      pair = TreeDefPair("Ex",      "ｼﾞﾂｺｳ/ｼﾃｲ-%s");   break;
			case COMMAND: pair = TreeDefPair("Command", "ｺﾏﾝﾄ ﾀﾞｲﾔﾛｸﾞ");  break;
			case INPUT:   pair = TreeDefPair("Input",   "ﾆﾕｳﾘﾖｸ ﾀﾞｲﾔﾛｸﾞ"); break;
			case SETTING: pair = TreeDefPair("Setting", "ｾﾂﾃｲ ﾀﾞｲﾔﾛｸﾞ");   break;
			case VERSION: pair = TreeDefPair("Version", "ﾊﾞｰｼﾞﾖﾝ ｼﾞﾖｳﾎｳ"); break;
			case ERROR:   pair = TreeDefPair("Error",   "ｴﾗｰ ﾀﾞｲﾔﾛｸﾞ");    break;
		}
		
		return Base.defGet("Dialog/" ~ pair.left, pair.right).toText;
	}

	/**
	History:
		1.063:
			[S] COPY, OUTPUT追加。
	*/
	enum MESSAGE {
		OK,
		CANCEL,
		CLOSE,
		EXECUTE,

		COPY,
		OUTPUT,

		INPUT,
		INSERT,
		ADD,
		EDIT,
		DELETE,
		DELETE_ALL,
		SAVE,
		INITIAL,
		NEW,
	}
	/**
	History:
		1.063:
			[P] 文字列追加。
	*/
	Text message(MESSAGE Message) {
		TreeDefPair pair=void;
		
		with(MESSAGE) final switch(Message) {
			case OK:      pair = TreeDefPair("OK",           "ｵｰｹｰ");  break;
			case CANCEL:  pair = TreeDefPair("Cancel",       "ｷｬﾝｾﾙ"); break;
			case CLOSE:   pair = TreeDefPair("Close",        "ﾄｼﾞﾙ");  break;
			case EXECUTE: pair = TreeDefPair("Execute",      "ｼﾞﾂｺｳ"); break;

			case COPY:   pair = TreeDefPair("Copy",      "ｺﾋﾟｰ"); break;
			case OUTPUT: pair = TreeDefPair("Output",    "ｼﾕﾂﾘﾖｸ"); break;
			

			case INPUT:      pair = TreeDefPair("Input",     "ﾆﾕｳﾘﾖｸ");     break;
			case INSERT:     pair = TreeDefPair("Insert",    "ｿｳﾆﾕｳ");      break;
			case EDIT:       pair = TreeDefPair("Edit",      "ﾍﾝｼﾕｳ");      break;
			case ADD:        pair = TreeDefPair("Add",       "ﾂｲｶ");        break;
			case DELETE:     pair = TreeDefPair("Delete",    "ｻｸｼﾞﾖ");      break;
			case DELETE_ALL: pair = TreeDefPair("AllDelete", "ｽﾍﾞﾃ ｻｸｼﾞﾖ"); break;
			case SAVE:       pair = TreeDefPair("Save",      "ｾｰﾌﾞ");       break;
			case INITIAL:    pair = TreeDefPair("Initial",   "ｼﾖｷｼﾞﾖｳﾀｲ");  break;
			case NEW:        pair = TreeDefPair("New",       "ｼﾝｷｻｸｾｲ");    break;
		}
		
		return Base.defGet("Message/" ~ pair.left, pair.right).toText;
	}

	enum WINDOW {
		FRONT,
		FRONT_SETTING,
	}
	Text window(WINDOW Window) {
		TreeDefPair pair=void;
		
		with(WINDOW) final switch(Window) {
			case FRONT:          pair = TreeDefPair("Front",         "ｻｲｾﾞﾝﾒﾝ");       break;
			case FRONT_SETTING:  pair = TreeDefPair("Front/Setting", "ｻｲｾﾞﾝﾒﾝ ﾋﾖｳｼﾞ"); break;
		}
		
		return Base.defGet("Window/" ~ pair.left, pair.right).toText;
	}
	Text windowPosition(Setting.POSITION Position) {
		TreeDefPair pair=void;

		with(Setting.POSITION) final switch(Position) {
			case LEFT:   pair = TreeDefPair("Left",   "ﾊﾞｰ/ﾋﾀﾞﾘ");    break;
			case TOP:    pair = TreeDefPair("Top",    "ﾊﾞｰ/ｳｴ");      break;
			case RIGHT:  pair = TreeDefPair("Right",  "ﾊﾞｰ/ﾐｷﾞ");     break;
			case BOTTOM: pair = TreeDefPair("Bottom", "ﾊﾞｰ/ｼﾀ");      break;
			case FLOAT:  pair = TreeDefPair("Float",  "ｳｲﾝﾄﾞｳ/ﾌﾛｰﾄ"); break;
			case SMALL:  pair = TreeDefPair("Hidden", "ﾋﾖｳｼﾞ ｼﾅｲ");   break;
		}
		
		return Base.defGet("Window/" ~ pair.left, pair.right).toText;
	}

	enum TASKTRAY_MENU {
		WINDOW,
		FOLDER,
		TOOLS,
		SETTING,
		HELP,
		ABOUT,
		QUIT,
	}
	Text taskTrayMenu(TASKTRAY_MENU TaskTrayMenu) {
		TreeDefPair pair;
		
		with(TASKTRAY_MENU) final switch(TaskTrayMenu) {
			case WINDOW:  pair = TreeDefPair("Window",  "ｳｲﾝﾄﾞｳ"); break;
			case FOLDER:  pair = TreeDefPair("Folder",  "ﾃﾞｲﾚｸﾄﾘ");    break;
			case TOOLS:   pair = TreeDefPair("Tools",   "ﾂｰﾙ");    break;
			case SETTING: pair = TreeDefPair("Setting", "ｾﾂﾃｲ");   break;
			case HELP:    pair = TreeDefPair("Help",    "ﾍﾙﾌﾟ");   break;
			case ABOUT:   pair = TreeDefPair("About",   "ｱﾊﾞｳﾄ");  break;
			case QUIT:    pair = TreeDefPair("Quit",    "ｼﾕｳﾘﾖｳ"); break;
		}
		
		return Base.defGet("TaskTray/Menu/" ~ pair.left, pair.right).toText;
	}

	enum BUTTON_MENU {
		NORMAL,
		EX,
		ADDRESS,
		FILE,
	}
	Text buttonMenu(BUTTON_MENU ButtonMenu) {
		TreeDefPair pair=void;
		
		with(BUTTON_MENU) final switch(ButtonMenu) {
			case NORMAL:  pair = TreeDefPair("Normal",  "ｼﾞﾂｺｳ/ﾌﾂｳ"); break;
			case EX:      pair = TreeDefPair("Ex",      "ｼﾞﾂｺｳ/ｼﾃｲ"); break;
			case ADDRESS: pair = TreeDefPair("Address", "ｱﾄﾞﾚｽ");     break;
			case FILE:    pair = TreeDefPair("File",    "ﾌｧｲﾙ");      break;
		}
		
		return Base.defGet("Button/Menu/" ~ pair.left, pair.right).toText;
	}
	enum BUTTON_MENU_ADDRESS {
		OPEN_FOLDER_OWNER,
		OPEN_FOLDER_WORK,
		COPY_ADDRESS,
		COPY_OWNER,
		COPY_WORK,
		COPY_OPTION,
		PROPERTY,
	}
	Text buttonMenuAddress(BUTTON_MENU_ADDRESS ButtonMenuAddress) {
		TreeDefPair pair=void;
		
		with(BUTTON_MENU_ADDRESS) final switch(ButtonMenuAddress) {
			case OPEN_FOLDER_OWNER: pair = TreeDefPair("Open/Owner",   "ｵｰﾌﾟﾝ/ｵｰﾅｰ ﾃﾞｲﾚｸﾄﾘ");  break;
			case OPEN_FOLDER_WORK:  pair = TreeDefPair("Open/Work",    "ｵｰﾌﾟﾝ/ｻｷﾞﾖｳ ﾃﾞｲﾚｸﾄﾘ"); break;
			case COPY_ADDRESS:      pair = TreeDefPair("Copy/Address", "ｺﾋﾟｰ/ｱﾄﾞﾚｽ");          break;
			case COPY_OWNER:        pair = TreeDefPair("Copy/Owner",   "ｺﾋﾟｰ/ｵｰﾅｰ ﾃﾞｲﾚｸﾄﾘ");   break;
			case COPY_WORK:         pair = TreeDefPair("Copy/Work",    "ｺﾋﾟｰ/ｻｷﾞﾖｳ ﾃﾞｲﾚｸﾄﾘ");  break;
			case COPY_OPTION:       pair = TreeDefPair("Copy/Option",  "ｺﾋﾟｰ/ｺﾏﾝﾄﾞﾗｲﾝ ﾋｷｽｳ");  break;
			case PROPERTY:          pair = TreeDefPair("Property",     "ﾌｧｲﾙ ﾉ ｼﾖｳｻｲ");        break;
		}
		
		return Base.defGet("Button/Menu/Address/" ~ pair.left, pair.right).toText;
	}
	enum BUTTON_MENU_FILE {
		THIS,
		OWNER,
	}
	Text buttonMenuFile(BUTTON_MENU_FILE ButtonMenuFile) {
		TreeDefPair pair=void;
		
		with(BUTTON_MENU_FILE) final switch(ButtonMenuFile) {
			case THIS:  pair = TreeDefPair("This",  "ｺﾉ ﾃﾞｲﾚｸﾄﾘ");  break;
			case OWNER: pair = TreeDefPair("Owner", "ｵｰﾅｰ ﾃﾞｲﾚｸﾄﾘ"); break;
		}
		
		return Base.defGet("Button/Menu/File/" ~ pair.left, pair.right).toText;
	}

	enum EX {
		WORK,
		OPTION,
	}
	Text ex(EX Ex) {
		TreeDefPair pair=void;
		
		with(EX) final switch(Ex) {
			case WORK:   pair = TreeDefPair("Work",   "ｻｷﾞﾖｳ ﾃﾞｲﾚｸﾄﾘ...");   break;
			case OPTION: pair = TreeDefPair("Option", "ｺﾏﾝﾄﾞﾗｲﾝ ﾋｷｽｳ..."); break;
		}
		
		return Base.defGet("Ex/" ~ pair.left, pair.right).toText;
	}
	//SHOW
	Text show(SHOW Show) {
		TreeDefPair pair=void;
		
		with(SHOW) final switch(Show) {
			case HIDE:            pair = TreeDefPair("Hide",            "ﾋﾋﾖｳｼﾞ");                        break;
			case SHOWNORMAL:      pair = TreeDefPair("Shownormal",      "ﾋﾖｳｼﾞ/ﾌﾂｳ");                     break;
			case SHOWMINIMIZED:   pair = TreeDefPair("Showminimized",   "ｻｲｼﾖｳｶ/ﾌﾂｳ");                    break;
			case SHOWMAXIMIZED:   pair = TreeDefPair("Showmaximized",   "ｻｲﾀﾞｲｶ/ﾌﾂｳ");                    break;
			case SHOWNOACTIVATE:  pair = TreeDefPair("Shownoactivate",  "ﾋﾖｳｼﾞ/ﾋ ｱｸﾃｲﾌﾞ");                break;
			case SHOW:            pair = TreeDefPair("Show",            "ﾋﾖｳｼﾞ/ｲﾏ ﾉ ｼﾞﾖｳﾀｲ");             break;
			case MINIMIZE:        pair = TreeDefPair("Minimize",        "ｻｲｼﾖｳｶ/ﾂｷﾞ ｦ ｱｸﾃｲﾌﾞ");           break;
			case SHOWMINNOACTIVE: pair = TreeDefPair("Showminnoactive", "ｻｲｼﾖｳｶ/ﾋ ｱｲﾃｲﾌﾞ");               break;
			case SHOWNA:          pair = TreeDefPair("Showna",          "ﾋﾖｳｼﾞ/ﾋ ｱｸﾃｲﾌﾞ ﾃﾞ ｲﾏ ﾉ ｼﾞﾖｳﾀｲ"); break;
			case RESTORE:         pair = TreeDefPair("Restore",         "ﾓﾄﾆﾓﾄﾞｽ");                       break;
			case SHOWDEFAULT:     pair = TreeDefPair("Showdefault",     "ﾋﾖｳｼﾞ/ｼﾃｲ");                     break;
			case FORCEMINIMIZE:   pair = TreeDefPair("Forceminimize",   "ﾌﾌﾌﾌﾌﾌﾌﾌﾌﾌﾌ");                   break;
		}
		
		return Base.defGet("Show/" ~ pair.left, pair.right).toText;
	}

	Text icon(Icon.FIXED IconFixed) {
		TreeDefPair pair=void;
		
		with(Icon.FIXED) final switch(IconFixed) {
			case SMALL:  pair = TreeDefPair("Small",  "ｼﾖｳ/16PX"); break;
			case NORMAL: pair = TreeDefPair("Normal", "ﾁﾕｳ/32PX"); break;
		}
		
		return Base.defGet("Icon/" ~ pair.left, pair.right).toText;
	}

	Text folder(FOLDER Folder) {
		TreeDefPair pair=void;
		
		with(FOLDER) final switch(Folder) {
			case NORMAL:   pair = TreeDefPair("Default",  "ﾌﾂｳ");       break;
			case EXPLORER: pair = TreeDefPair("Explorer", "ｴｸｽﾌﾟﾛｰﾗｰ"); break;
			case PROGRAM:  pair = TreeDefPair("Item",     "ｱｲﾃﾑ");      break;
		}
		
		return Base.defGet("Folder/" ~ pair.left, pair.right).toText;
	}

	Text itemType(Item.TYPE Type) {
		TreeDefPair pair=void;
		
		with(Item.TYPE) final switch(Type) {
			case NORMAL: pair = TreeDefPair("Normal", "ﾌﾂｳ");   break;
			case URI:    pair = TreeDefPair("URI",    "URI");   break;
			case MULTI:  pair = TreeDefPair("Multi",  "ﾌｸｽｳ");  break;
			case LINK:   pair = TreeDefPair("Link",   "ｻﾝｼﾖｳ"); break;
		}
		
		return Base.defGet("Item/Type/" ~ pair.left, pair.right).toText;
	}

	enum SETTING {
		APPLICATION,
		ITEM,
		GROUP,
	}
	Text setting(SETTING Setting) {
		TreeDefPair pair=void;
		
		with(SETTING) final switch(Setting) {
			case APPLICATION: pair = TreeDefPair("Application", "ﾌﾟﾛｸﾞﾗﾑ"); break;
			case ITEM:        pair = TreeDefPair("Item",        "ｱｲﾃﾑ");    break;
			case GROUP:       pair = TreeDefPair("Group",       "ｸﾞﾙｰﾌﾟ");  break;
		}
		
		return Base.defGet("Setting/" ~ pair.left, pair.right).toText;
	}

	enum SETTING_APPLICATION {
		APP,
		APP_SHORTCUT,
		WINDOW,
		FOLDER,
		BUTTON,
		BUTTON_TEXT,
		BUTTON_LIST,
		BUTTON_DROP,
		MENU,
		MENU_TEXT,
		MENU_DESKTOP,
		COMMAND,
		COMMAND_HOTKEY,
		COMMAND_HIDDEN,
		COMMAND_LIST_ID,
		COMMAND_LIST_NAME,
		COMMAND_LIST_TAG,
		COMMAND_LIST_COLOR_FORE,
		COMMAND_LIST_COLOR_BACK,
	}
	Text settingApplication(SETTING_APPLICATION SettingApplication) {
		TreeDefPair pair=void;
		
		with(SETTING_APPLICATION) final switch(SettingApplication) {
			case APP:          pair = TreeDefPair("Application",         "ﾌﾟﾛｸﾞﾗﾑ");           break;
			case APP_SHORTCUT: pair = TreeDefPair("Application/Shorcut", "ｼﾖｰﾄｶﾂﾄ ｻｷ ｵｰﾌﾟﾝ");  break;
			
			case FOLDER:       pair = TreeDefPair("Window", "ｳｲﾝﾄﾞｳ");  break;
			
			case WINDOW:       pair = TreeDefPair("Folder", "ﾃﾞｲﾚｸﾄﾘ"); break;
			
			case BUTTON:       pair = TreeDefPair("Button",      "ﾎﾞﾀﾝ");                    break;
			case BUTTON_TEXT:  pair = TreeDefPair("Button/Text", "ﾓｼﾞ ｦ ﾋﾖｳｼﾞ ｽﾙ");          break;
			case BUTTON_LIST:  pair = TreeDefPair("Button/List", "ﾖｺ ﾆ ﾋﾖｳｼﾞｽﾙ");           break;
			case BUTTON_DROP:  pair = TreeDefPair("Button/Drop", "D&&D ｻﾚﾀﾗ ﾀﾞｲﾔﾛｸﾞ ｵｰﾌﾟﾝ"); break;
			
			case MENU:         pair = TreeDefPair("Menu",         "ﾒﾆﾕｰ");              break;
			case MENU_TEXT:    pair = TreeDefPair("Menu/Text",    "ﾓｼﾞ ﾉ ﾅｶﾞｻ:");       break;
			case MENU_DESKTOP: pair = TreeDefPair("Menu/Desktop", "ﾃﾞｽｸﾄﾂﾌﾟ ﾃﾞ ｼﾖｳｽﾙ"); break;
			
			case COMMAND:                 pair = TreeDefPair("Command",                 "ｺﾏﾝﾄﾞ");          break;
			case COMMAND_HOTKEY:          pair = TreeDefPair("Command/Hotkey",          "ﾎﾂﾄ ｷｰ:");        break;
			case COMMAND_HIDDEN:          pair = TreeDefPair("Command/Hidden",          "ﾋﾖｳｼﾞ ﾏﾁ ｼﾞｶﾝ:"); break;
			case COMMAND_LIST_ID:         pair = TreeDefPair("Command/List/ID",         "ID");             break;
			case COMMAND_LIST_NAME:       pair = TreeDefPair("Command/List/Name",       "ﾅﾏｴ");            break;
			case COMMAND_LIST_TAG:        pair = TreeDefPair("Command/List/Tag",        "TAG");            break;
			case COMMAND_LIST_COLOR_FORE: pair = TreeDefPair("Command/List/Color/Fore", "ﾓｼﾞ");            break;
			case COMMAND_LIST_COLOR_BACK: pair = TreeDefPair("Command/List/Color/Back", "ﾊｲｹｲ");           break;
		}
		
		return Base.defGet("Setting/Application/" ~ pair.left, pair.right).toText;
	}

	enum SETTING_ITEM {
		ID,
		TYPE,
		NAME,
		ADDRESS,
		WORK,
		OPTION,
		ICON,
		SHOW,
		KEY,

		INFO,
		INFO_TAG,
		INFO_MEMO,

		HISTORY,
		HISTORY_NOWDATE,
		HISTORY_REGIST,
		HISTORY_LAST,
		HISTORY_LAST_COUNT,
		HISTORY_WORKS,
		HISTORY_OPTIONS,

		MENU_ID,
		MENU_NAME,
		MENU_ADDRESS,
		MENU_ADDRESS_ALL,
		MENU_FILE,
		MENU_FOLDER,
		MENU_ICON,
	}
	Text settingItem(SETTING_ITEM SettingItem) {
		TreeDefPair pair=void;
		
		with(SETTING_ITEM) final switch(SettingItem) {
			case ID:                 pair = TreeDefPair("ID",                 "ID");            break;
			case TYPE:               pair = TreeDefPair("Type",               "ｶﾀ");            break;
			case NAME:               pair = TreeDefPair("Name",               "ﾅﾏｴ");           break;
			case ADDRESS:            pair = TreeDefPair("Address",            "ｱﾄﾞﾚｽ");         break;
			case WORK:               pair = TreeDefPair("Work",               "ｻｷﾞﾖｳ ﾃﾞｲﾚｸﾄﾘ"); break;
			case OPTION:             pair = TreeDefPair("Option",             "ｺﾏﾝﾄﾞﾗｲﾝ ﾋｷｽｳ"); break;
			case ICON:               pair = TreeDefPair("Icon",               "ｱｲｺﾝ");          break;
			case SHOW:               pair = TreeDefPair("Show",               "ﾋﾖｳｼﾞ");         break;
			case KEY:                pair = TreeDefPair("Key",                "ｷｰ");            break;
			
			case INFO:               pair = TreeDefPair("Information",        "ｼﾞﾖｳﾎｳ"); break;
			case INFO_TAG:           pair = TreeDefPair("Information/Tag",    "TAG");    break;
			case INFO_MEMO:          pair = TreeDefPair("Information/Memo",   "ﾒﾓ");     break;
			
			case HISTORY:            pair = TreeDefPair("History",            "ﾘﾚｷ");           break;
			case HISTORY_NOWDATE:    pair = TreeDefPair("History/NowDate",    "ｲﾏ");            break;
			case HISTORY_REGIST:     pair = TreeDefPair("History/Regist",     "ﾄｳﾛｸ ﾆﾁｼﾞ");     break;
			case HISTORY_LAST:       pair = TreeDefPair("History/Last",       "ｼﾖｳ ﾆﾁｼﾞ");      break;
			case HISTORY_LAST_COUNT: pair = TreeDefPair("History/Last/Count", "ｶｳﾝﾄ ﾘｾﾂﾄ");     break;
			case HISTORY_WORKS:      pair = TreeDefPair("History/Works",      "ｻｷﾞﾖｳ ﾃﾞｲﾚｸﾄﾘ"); break;
			case HISTORY_OPTIONS:    pair = TreeDefPair("History/Options",    "ｺﾏﾝﾄﾞﾗｲﾝ ﾋｷｽｳ"); break;

			case MENU_ID:            pair = TreeDefPair("Menu/ID",            "ID ﾆ ｱﾜｽ");         break;
			case MENU_NAME:          pair = TreeDefPair("Menu/Name",          "ﾅﾏｴ ﾆ ｱﾜｽ");        break;
			case MENU_ADDRESS:       pair = TreeDefPair("Menu/Address",       "ｱﾄﾞﾚｽ ﾆ ｱﾜｽ");      break;
			case MENU_ADDRESS_ALL:   pair = TreeDefPair("Menu/AllAddress",    "ｽﾍﾞﾃ ｱﾄﾞﾚｽ ﾆ ｱﾜｽ"); break;
			case MENU_FILE:          pair = TreeDefPair("Menu/File",          "ﾌｧｲﾙ ｾﾝﾀｸ");        break;
			case MENU_FOLDER:        pair = TreeDefPair("Menu/Folder",        "ﾃﾞｲﾚｸﾄﾘ ｾﾝﾀｸ");     break;
			case MENU_ICON:          pair = TreeDefPair("Menu/Icon",          "ｱｲｺﾝ ｾﾝﾀｸ");        break;
		}
		
		return Base.defGet("Setting/Item/" ~ pair.left, pair.right).toText;
	}

	enum SETTING_GROUP {
		UP,
		DOWN,
		MAIN_INSERT,
		MAIN_ADD,
		SUB_INSERT,
		SUB_ADD,
		ITEM_INSERT,
		ITEM_ADD,
	}
	Text settingGroup(SETTING_GROUP SettingGroup) {
		TreeDefPair pair=void;
		
		with(SETTING_GROUP) final switch(SettingGroup) {
			case UP:          pair = TreeDefPair("Up",          "ｳｴ ﾍ");       break;
			case DOWN:        pair = TreeDefPair("Down",        "ｼﾀ ﾍ");       break;
			case MAIN_INSERT: pair = TreeDefPair("Main/Insert", "ﾒｲﾝG ｿｳﾆﾕｳ"); break;
			case MAIN_ADD:    pair = TreeDefPair("Main/Add",    "ﾒｲﾝG ﾂｲｶ");   break;
			case SUB_INSERT:  pair = TreeDefPair("Sub/Insert",  "ｻﾌﾞG ｿｳﾆﾕｳ"); break;
			case SUB_ADD:     pair = TreeDefPair("Sub/Add",     "ｻﾌﾞG ﾂｲｶ");   break;
			case ITEM_INSERT: pair = TreeDefPair("Item/Insert", "ｱｲﾃﾑ ｿｳﾆﾕｳ"); break;
			case ITEM_ADD:    pair = TreeDefPair("Item/Add",    "ｱｲﾃﾑ ﾂｲｶ");   break;
		}
		
		return Base.defGet("Setting/Group/" ~ pair.left, pair.right).toText;
	}

	enum NEMUXI_FOLDER {
		NEMUXI,
		USER,
	}
	Text nemuxiFolder(NEMUXI_FOLDER NemuxiFolder) {
		TreeDefPair pair=void;
		with(NEMUXI_FOLDER) final switch(NemuxiFolder) {
			case NEMUXI: pair = TreeDefPair("Nemuxi", "ﾎﾝﾀｲ");  break;
			case USER  : pair = TreeDefPair("User",   "ﾕｰｻﾞｰ"); break;
		}
		
		return Base.defGet("Folder/Nemuxi/" ~ pair.left, pair.right).toText;
	}

	Text allUser() {
		auto pair = TreeDefPair("Folder/AllUser", "ALLUSER");
		return Base.defGet("Folder/" ~ pair.left, pair.right).toText;
	}
	Text systemFolder(SYSTEM_FOLDER SystemFolder) {
		TreeDefPair pair=void;
		with(SYSTEM_FOLDER) final switch(SystemFolder) {
			case COMPUTER                 : pair = TreeDefPair("Computer",        "ｺﾝﾋﾟﾕｰﾀ");    break;
			case CONTROLPANEL             : pair = TreeDefPair("ControlPanel",    "ｺﾝﾄﾛｰﾙﾊﾟﾈﾙ"); break;
			
			case TRASH                    : pair = TreeDefPair("Trash",           "ｺﾞﾐ");          break;
			case NETWORK                  : pair = TreeDefPair("Network",         "ﾈﾂﾄﾜｰｸ");       break;
			case NETWORK_CONNECT          : pair = TreeDefPair("Network/Connect", "ﾈﾂﾄﾜｰｸ/ｾﾂｿﾞｸ"); break;
			case CAMERA_SCANNER           : pair = TreeDefPair("CameraScanner",   "ｶﾒﾗ/ｽｷｬﾅ");     break;
			case PRINTER_FAX              : pair = TreeDefPair("PrinterFax",      "ﾌﾟﾘﾝﾀ/FAX");    break;
			case TASK                     : pair = TreeDefPair("Task",            "ﾀｽｸ");          break;
			case FONTS                    : pair = TreeDefPair("Fonts",           "ﾌｵﾝﾄ");         break;
			case ADMINTOOLS               : pair = TreeDefPair("AdminTool",       "ｶﾝﾘﾂｰﾙ");       break;
			
			case _PADDING_VIRTUAL_        : assert(false);

			case STARTMENU                : pair = TreeDefPair("StartMenu",        "ｽﾀｰﾄﾒﾆﾕｰ"); break;
			case PROGRAMS                 : pair = TreeDefPair("Programs",         "ﾌﾟﾛｸﾞﾗﾑ");  break;
			case STARTUP                  : pair = TreeDefPair("Startup",          "ｽﾀｰﾄｱﾂﾌﾟ"); break;
			case DESKTOPDIRECTORY         : pair = TreeDefPair("DesktopDirectory", "ﾃﾞｽｸﾄﾂﾌﾟ"); break;
			case FAVORITES                : pair = TreeDefPair("Favorites",        "ﾌﾞﾂｸﾏｰｸ");  break;
			case RECENT                   : pair = TreeDefPair("Recent",           "ｻｲｷﾝｼﾖｳ");  break;
			case SENDTO                   : pair = TreeDefPair("Sendto",           "ｵｸﾙ");      break;
			
			case PROFILE                  : pair = TreeDefPair("Profile",   "ﾌﾟﾛﾌｱｲﾙ");      break;
			case DOCUMENTS                : pair = TreeDefPair("Documents", "ﾕｰｻﾞｰﾃﾞｲﾚｸﾄﾘ"); break;
			case PICTURES                 : pair = TreeDefPair("Pictures",  "ｶﾞｿﾞｳ");        break;
			case MUSIC                    : pair = TreeDefPair("Music",     "ｵﾝｶﾞｸ");        break;
			case VIDEO                    : pair = TreeDefPair("Video",     "ﾄﾞｳｶﾞ");        break;
			
			case APPDATA                  : pair = TreeDefPair("Appdata",       "ｱﾌﾟﾘｹｰｼﾖﾝ");      break;
			case APPDATA_LOCAL            : pair = TreeDefPair("Appdata/Local", "ｱﾌﾟﾘｹｰｼﾖﾝ/ﾛｰｶﾙ"); break;
			case TEMPLATES                : pair = TreeDefPair("Templates",     "ﾃﾝﾌﾟﾚｰﾄ");        break;
			
			case INTERNET_CACHE           : pair = TreeDefPair("Cache",   "ｷﾔﾂｼﾕ"); break;
			case INTERNET_COOKIES         : pair = TreeDefPair("Cookies", "ｸﾂｷｰ");  break;
			case INTERNET_HISTORY         : pair = TreeDefPair("History", "ﾘﾚｷ");   break;
			
			case WINDOWS                  : pair = TreeDefPair("Windows",             "WINDOWS");             break;
			case SYSTEM                   : pair = TreeDefPair("System",              "SYSTEM");              break;
			case PROGRAM_FILES            : pair = TreeDefPair("ProgramFiles",        "PROGRAMFILES");        break;
			case PROGRAM_FILES_COMMON     : pair = TreeDefPair("ProgramFiles/Common", "PROGRAMFILES/COMMON"); break;
			
			case ALLUSER_STARTMENU        : pair = TreeDefPair("AllUser/StartMenu",        "ALLUSER/ｽﾀｰﾄﾒﾆﾕｰ");  break;
			case ALLUSER_PROGRAMS         : pair = TreeDefPair("AllUser/Programs",         "ALLUSER/ﾌﾟﾛｸﾞﾗﾑ");   break;
			case ALLUSER_STARTUP          : pair = TreeDefPair("AllUser/Startup",          "ALLUSER/ｽﾀｰﾄｱﾂﾌﾟ");  break;
			case ALLUSER_DESKTOPDIRECTORY : pair = TreeDefPair("AllUser/DesktopDirectory", "ALLUSER/ﾃﾞｽｸﾄﾂﾌﾟ");  break;
			case ALLUSER_FAVORITES        : pair = TreeDefPair("AllUser/Favorites",        "ALLUSER/ﾌﾞﾂｸﾏｰｸ");   break;
			case ALLUSER_APPDATA          : pair = TreeDefPair("AllUser/Appdata",          "ALLUSER/ｱﾌﾟﾘｹｰｼﾖﾝ"); break;
			case ALLUSER_TEMPLATES        : pair = TreeDefPair("AllUser/Templates",        "ALLUSER/ﾃﾝﾌﾟﾚｰﾄ");   break;
			case ALLUSER_DOCUMENTS        : pair = TreeDefPair("AllUser/Documents",        "ALLUSER/ﾃﾞｲﾚｸﾄﾘ");   break;
			case ALLUSER_PICTURES         : pair = TreeDefPair("AllUser/Pictures",         "ALLUSER/ｶﾞｿﾞｳ");     break;
			case ALLUSER_MUSIC            : pair = TreeDefPair("AllUser/Music",            "ALLUSER/ｵﾝｶﾞｸ");     break;
			case ALLUSER_VIDEO            : pair = TreeDefPair("AllUser/Video",            "ALLUSER/ﾄﾞｳｶﾞ");     break;
		}
		
		return Base.defGet("Folder/" ~ pair.left, pair.right).toText;
	}
}
/// 主に列挙体アクセスに使用。
alias LanguageData LD;



