﻿/**
History:
	1.00β19:
		新規作成。
*/
module nemuxi.system.exception;

debug import std.stdio: wl = writefln, pl = printf;
//debug(exception) void main() {}

import std.string: format;
import std.conv;

import nemuxi.negui.system.base;
/+
public import nemuxi.negui.system.text;
public import nemuxi.negui.system.timer;
public import nemuxi.negui.system.exception;
+/

/**
あんまし継承関係にないんだけどこの逆よりかはマシ。

History:
	1.032:
		[P] NeGuiExceptionにあわせる。
*/
class NemuxiException: NeGuiException {
	enum CODE {
		NONE = 0,

		PROCCESS,
		PROCCESS_CREATE,
		
		FILE,
		FILE_EXECUTE_PATH,
		FILE_EXECUTE_FOLDER,
		FILE_EXECUTE_PROPERTY,

		ITEM,
		ITEM_DATE_LENGTH,
		ITEM_DATE_SPLIT,
		ITEM_DATE,
		ITEM_DATE_INFO,
	}
	private {
		CODE Code;
	}
	final const CODE code() {
		return Code;
	}
	this(in Text msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, next, file, line);
		Code = code;
	}
	this(string msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg.toText, code, next, file, line);
	}
	this(Object msg, CODE code=CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		this(msg ? msg.toString(): "*Object is null", code, next, file, line);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	protected override string ExceptionMessage() {
		return format(
			"%s@%s(%s): %s [CODE = %s(%s), %s]",
			this.classinfo.name,
			file,
			line,
			msg,
			code,
			to!(string)(code),
			time
		);
	}
}
///
alias NemuxiException.CODE EC;

template MixInNemuxiException() {
	override this(in Text msg, NemuxiException.CODE code=NemuxiException.CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
	override this(string msg, NemuxiException.CODE code=NemuxiException.CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
	override this(Object msg, NemuxiException.CODE code=NemuxiException.CODE.NONE, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, code, next, file, line);
	}
}

__EOF__;

///
class Exception: NeGuiException {
	mixin MixInNeGuiException;
}

///
class Exception: NemuxiException {
	mixin MixInNemuxiException;
}





