﻿/**
ﾈﾑぃ

Authors:
	sk

License:
	NYSL, NYSDL

Version:
	History参照。

Date:
	History参照。

Note:
	当初の目標から外れてNeGuiが変な方向に走ってる。
	GUIより普通のライブラリっぽくなってきてるんでどうせだしﾈﾑぃから移行できるやつは移行してみる。

	そろそろコメント消してー。

Bugs:
	NeGuiとか識別子ぐちゃぐちゃ。

	NeGuiはある程度修正したけどﾈﾑぃの方がぐちゃぐちゃ。

History:
	<ul>
		<li>機能追加/実装/変更/停止/廃止: [F]eatures</li>
		<li>バグ修正: [B]ug</li>
		<li>プログラム的な変更(なんだこれ): [P]rogram</li>
		<li>ソース上の変更: [S]ource</li>
		<li>↑以外のこと: [@]</li>
	</ul>

	1.090, 2009/12/27:
		[B] 設定ダイアログで設定を保存し再初期化を実行した際にコマンド入力ダイアログの影響で落ちるバグ(いつからあったのか不明)。
		[F] resource\language\日本語.aki変更。
		[B] その他ちまちまとバグ修正。

	1.081, 2009/12/12:
		[F] static.akiの有無で標準のsetting/mutex/nameを一致させるように変更。
		[P] 秋文書パース時のエラーをログ出力。
		[S] 設定ファイル読み込みから整形における処理を統一。

	1.080, 2009/12/05:
		[S] deprecatedコード削除。
		[S] 過去コードを目に付いたところから削除。
		[B] static.akiの確保メモリの値が反映されずに死んでいた。

	1.070, 2009/12/01:
		[B] ショートカット読み込みエラー時に本体が落ちる処理を暫定対処。
		[F] static.akiのユーザー用にdynamic.akiを使用可能に。
		[@] static.akiにスペルミスがあったので修正。
		[B] エラーダイアログ「出力」のフィルタが不思議なことになっていた。
		[P] エラーダイアログ例外クラス名の表示からpackageを省略。
		[B] グループ設定にて設定していないメニューグループの失敗となる不具合修正。

	1.063, 2009/11/30:
		[F] エラーダイアログにおいて「コピー」「出力」を実装。
		[F] resource\language\日本語.aki変更。
		[F] グループ設定が不完全な状態では保存できないように変更。
		[F] グループ設定でツリービュー選択時にアイテム表示リストの該当アイテムを表示するように変更。
		[F] コマンド入力時に同一アイテム内の重複を表示しないように変更。
		[F] タグ入力を若干改善。
		[B] 特定の文字列に対して特定の処理を行うと絶対に失敗する問題の修正。
		[P] メインウィンドウのサイズ取得方法を変更、Window 7(RCで確認)でも有効っぽい。

	1.062, 2009/11/29:
		[S] 識別子をある程度修正。
		[@] ヘルプファイル「コンパイル方法」の記入漏れ修正。

	1.061, 2009/11/29:
		[S] 識別子調整中。
		[F] メインウィンドウのツールチップを内部的に修正。
		[B] アイテムメニューにて環境変数を考慮。
		[F] アイテム設定でファイルのD&D時に例外ダイアログを表示させないように。

	1.060, 2009/11/26:
		[S] 識別子調整中。
		[B] オーナードローメニューのアイコン余白部分を片方しか考慮していなかった。
		[F] メインウィンドウタイトルバーのミドルクリックでシステムメニューの表示機能追加。

	1.051, 2009/11/24:
		[S] 識別子調整中。
		[B] アイテム設定時に「全てアドレスに合わせる」が「名前に合わせる」と同じ動作をしていたのを修正。
		[@] アイテムのキーに[0-9]を追加。
		[B] 指定して実行ダイアログの高さを変更できた不具合の修正。
		[B] アイテム設定等で使用するNeGuiControlクラスの登録処理がデッドコードになっていたバグ修正。
		[B] 例外ダイアログでNeGuiExceptionを捕まえた際に「Assertion failure」で落ちていたバグの修正。

	1.050, 2009/11/22:
		[S] 識別子調整中。
		[B] スタートアップからの起動時にウィンドウ生成に失敗するバグの修正。
		[B] スタートアップからの起動時にタスクトレイアイコンが設定されないバグの修正。
		[F] 環境情報でOSエディション追加。
	
	1.032, 2009/11/21:
		[S] 識別子調整中。
		[@] 「1.031:スタートアップから起動～」がまだ死んでる。
		[F] エラーコードの扱い変更。
		[P] タスクトレイの生成・追加の処理を変更。
		[F] static.aki変更。

	1.031, 2009/11/18:
		[B] クライアント座標以外(タイトルバーとか)にファイルをD&Dした際にDropFileExceptionが発生する不具合の修正。
		[B] 本体ウィンドウの最小サイズ制限処理がデッドコードになっていた。
		[B] スタートアップから起動させた場合に本体ウィンドウの初期化で失敗、「Gui生成失敗」で落ちていた不具合への対処。

	1.030, 2009/11/17:
		[F] ログ出力を若干増加。
		[@] ↑どう考えてもいらないだろうっていうところまである。要調整。
		[P] ちまちまいろいろ。

	1.022, 2009/11/16:
		[F] 関連付けログ出力の結果を若干変更。
		[S] NeGuiがﾈﾑぃから完全な独立。

	1.021, 2009/11/14:
		[F] 設定画面等におけるアイテムをソートするように変更。
		[@] NeGuiの方針。
		[F] コマンド入力ダイアログの横幅を保持するように変更。
		[B] システム終了時に設定を保存するように設定。

	1.020, 2009/11/09:
		[@] ヘルプファイル(help.hta)にBOMを設定。
		[S] ﾈﾑぃから独立可能なmoduleをNeGuiへ。
		[B] 設定画面にてアイテムを一度も保存せずに設定を保存するとアイテムのメモが書き込まれなかった不具合の解決。

	1.010, 2009/11/08:
		[F] アイテム登録時にD&Dしたファイルがショートカットだった場合に登録されるIDを名前からアドレス基準に変更。
		[B] グループ設定でグループ名の重複した場合に設定ファイルがバグっていたのを修正。
		[@] DMD 2.036でコンパイル。
		[F] フォルダメニューに本体フォルダと設定フォルダの追加。
		[F] アイテム設定画面のUIを変更。
		[F] グループ設定のコンテキストメニュー表示方法を若干変更。

	1.000, 2009/11/03:
		[@] β版終了。
		[S] どうせDMD2.033でコンパイル通らないんだし今のうちにソース整理。
		[S] 続・ソースが大変な混乱状態、Historyを書く余裕なし。
		[S] NeGuiがﾈﾑぃから独立できたような気がした。
		[@] DMD最新版でコンパイルできない。
		[B] リソースフォルダ/言語リソースフォルダが存在しない場合に設定画面を開くと落ちていた不具合の修正。
		[B] グループ設定において同列グループ間での重複名登録が可能だった処理を修正。
		[F] タスクトレイ右クリックメニューにフォルダを追加。
		[@] メインアイコンの変更。

	1.00β20, 2009/10/11:
		[@] 配布用ファイル等をバッチ処理化。これに伴いパッケージ版のみUPXを使用、フォルダのウィルスチェック。
		[@] リソース強化。マニフェスト/バージョン情報を追加。
		[@] アイコンの書き換え。
		[S] ソースが大変な混乱状態、Historyを書く余裕なし。
		[F] グループ設定画面にツールバー設置。暫定につき不安定かも。
		[P] バージョン情報の表示バージョンの取得方法変更。
		[@] ヘルプファイルにスタイルシート適用。
		[@] 全体的に何をやったのかよく分からんけどいっぱいソース弄った。
	
	1.00β19, 2009/10/03:
		[F] 設定値がシステムのもの(初期値)と同等であれば値をそのまま保存しないように変更。
		[B] (debug)本体設定→ボタン型の「リスト表示」が原因で設定後にAssertion failureで落ちる設計ミスの修正。
		[F] 本体設定→コマンド型のフォント選択画面で水平方向のフォントのみ選択可能に変更。
		[F] 文字列リソースの暫定外部化、目に見える範囲のみ。
		[F] 「指定して実行」ダイアログの横幅を若干拡張。
		[F] 「エラー発生」ダイアログのサイズを拡張。
		[S] NeGuiとNemuxiの若干の切り離し。無くそう癒着。
		[F] 癒着をなくそうとしたら例外のコード値が面白いことになった。
		[F] 二重起動の禁止フラグを追加。
		[B] 選択中のメイングループに無効なサブグループが選択可能で選択すると落ちるバグの修正。

	1.00β18, 2009/09/23:
		[B] mainが公開版なのにversion(none)だったのを修正。
		[F] 「指定して実行」のダイアログがD&Dに対応。
		[P] UIを強化。nemuxi.negui.layout.*が色々と。
		[B] 設定ダイアログで項目移動時にコンボボックスやリストビューで選択されているアイテムが変更される不具合の修正。
		[B] フォルダオープンアイテムが無効な場合にUI及びプログラムが異常なことになる不具合の修正。
		[B] コマンド入力ダイアログのリストをマウス選択できなかった不具合の修正。
		[F] コマンド入力ダイアログに「消滅時間」の反映。
		[B] 設定画面のアイコンを解放出来ていなかったバグの修正(まだちょっと怪しい)。
		[@] 1.00β13未満のHistory(nemuxi.nemuxiのみ)にも印付け。

	1.00β17, 2009/09/21:
		[@] Hooker.dll差し替え(1.010 -> 1.100)
		[F] コマンド型をとりあえずの実装、「消滅時間」未実装。
		[B] ホットキー登録の登録時の不具合を修正。
		[P] アイテムIDの使用不可文字追加。
		[B] 何かがバグってた。
		[P] プラグイン仕様の変更。
		[B] アイテム一覧表示で使用されたアイコンを解放していないバグの修正。
		[B] アイテム設定時にアイテム未登録状態で複数アイテムにアイテムタイプを変更した際に落ちていたバグを修正。
	
	1.00β16, 2009/09/12:
		[@] Hooker.dll差し替え(1.000 -> 1.010)
		[S] ソースコードの整理。
		[B] アイテム描画用イメージリストを解放していなかったバグを修正。
		[B] Hooker.dllの解放処理が怪しかったので差し替え。
	
	1.00β15, 2008/09/09:
		[S] nemuxi.file.items.groupのText置き換え作業によりメソッド等変更。影響packageへのHistory記述無し。
		[S] Textへの置き換え運動は多分終了。
		[P] グループ設定のUI変更。
		[P] 設定部分のキーボードアクセラレータ使用準備。
		[P] アイテム設定のダイアログ表示に初期値を設定。
		[P] アイテム選択時にアイコンを表示するように変更。
	
	1.00β14, 2008/09/01:
		[F] アイテム設定時にアドレスが環境変数を含んでいる場合に登録できない不具合を修正。
		[F] グループ設定の項目ダブルクリックを無視するように修正。
		[P] アイテム設定時にD&Dした時の挙動を変更。ポインタがアイテムリストの上にあれば新規作成、なければ通常の設定。
		[B] アイテムの作業フォルダに環境変数が含まれていた場合にそのアイテムを実行できないバグを修正。
		[S] 大部分のstringからTextへの置き換え運動開始。修正箇所が多いので該当部分へのHistory記述無し。diffでもしてくれ。
	
	1.00β13, 2009/08/29:
		[@] 今バージョンからHistoryに修正箇所の目印を追加するように心に決めた。
		[F] アイテム設定においてショートカットファイル(*.lnk)に対応。
		[P] D&D処理を一部実装。
		[P] バージョン情報ダイアログにユーザー環境ではなく作者の環境を表示するように変更。
		[S] Historyがあまりにも残念だったのを修正。

	1.00β12, 2009/08/27:
		[P] 設定画面における「OK」と「CANCEL」の位置を入れ替え。
		[B] メインウィンドウがバー状態でもタイトルバーD&Dによる移動が許可されていたバグの修正。
		[F] メインウィンドウがバー状態の際に特定方向のみへサイズ変更するようにヒットテスト修正。
		[F] アイテムの設定で「アドレスに合わせる」を実装。

	1.00β11, 2009/08/24:
		[B] アイコン取得時にアドレスがDLLだった場合にアイコンインデックスが無視される不具合を修正。
		[F] アイコン入力欄を入力可能に変更。
		[B] アイテムメニューにおいて拡張子無しのファイル(と.無しフォルダ)が存在する場合に落ちるバグを修正。
		[F] バージョン情報ダイアログ暫定実装。
		[B] フォルダオープン時にエクスプローラ表示が無視されていた不具合を修正。
	
	1.00β10, 2009/08/19:
		[@] 公開。

*/
module nemuxi.nemuxi;

version(build) {
	pragma(build_def, "EXETYPE NT");
	pragma(build_def, "SUBSYSTEM WINDOWS,5.0");
}

import win32.windows;
import win32.commctrl;

import nemuxi.base;
import nemuxi.negui.window.dialog.system;
import nemuxi.system.application;
import nemuxi.gui.window.nemuxiwindow.nemuxiwindow;
import nemuxi.gui.window.dialog.exceptiondialog.exceptiondialog;
import nemuxi.negui.mutex;

import nemuxi.negui.neguiinitialize;
import nemuxi.negui.draw.color;


/**

Bugs:
	WinMainに変えなきゃいかんはず。

History:
	1.00β19:
		[P] 実行前に少し処理追加。

	1.00β17:
		[S] 試験的なことする時用にコード分離。
	
	1.00β12:
		設定ファイルの書き込みタイミングを変更。

	1.00β11:
		例外catchの悪足掻きを追加。
*/
int main(string[] args) {
	mixin(SMixInNeGuiInitialize());
	
	//Logger.flag=true;
	version(all) {
		debug {
			Logger.flag=true;
		} else {
			Logger.flag=StaticData.logEnable;
		}
		//scope log=Logger.log(Text("Nemuxi"));
		mixin(SMixInLog("Nemuxi"));
		
		try {
			scope Mutex mutex;
			//前検査
			try {
				if(StaticData.mutex) {
					debug {
						mutex = new Mutex(Text(__TIMESTAMP__));
					} else {
						mutex = new Mutex(StaticData.mutexName);
					}
				}
				StaticData.check();
			} catch(Exception e) {
				throw new NemuxiException("前検査", EC.NONE, e);
			}
			scope(success) delete mutex;

			//実行
			//Logger.write("Nemuxi Start ->");
			//log.write("start");
			
			auto hWnd=new NemuxiWindow(MakeApplication());
			try {
				scope(success) {
					SaveApplication(hWnd.application);
				}
				//Logger.write("args -> %s", args);
				log.write("args -> %s", args);
				hWnd.dataLoad;
				return hWnd.execute();
			} catch(NemuxiException e) {
				//Logger.write(e);
				log.write(e);
				ShowExceptionDialog(hWnd, e);
				return e.code;
			}
		} catch (Throwable e) {
			//Logger.write(e);
			log.write(e);
			ShowExceptionDialog(null, e);
			debug wl("%s", e);
			return -1;
		} catch(Object o) {
			Logger.write(o);
			MessageDialog.show(o.toString.toText);
			debug wl("%s", o);
			return -2;
		} finally {
			//Logger.write("<- Nemuxi End.");
			//log.write("end");
		}
		
	} else {
		debug {
			auto hWnd=new NemuxiWindow(MakeApplication());
			scope(success) {
				SaveApplication(hWnd.application);
			}
			Logger.write("args -> %s", args);
			hWnd.dataLoad;
			return hWnd.execute();
		} else {
			static assert(false, "ON -release!");
		}
	}
}

