﻿/**

*/
module nemuxi.negui.window.window;

debug import std.stdio: wl = writefln, pl = printf;
debug(window) void main() {}

import win32.windows;

//import nemuxi.base;
public import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
import nemuxi.negui.window.menu.menu;

///
class WindowException: NeGuiException {
	mixin MixInNeGuiException;
}

///
class Window: NeGui {

	protected override this(HWND hWnd) {
		super(hWnd);
	}

	/**
	History:
		1.022:
			新規作成。
	*/
	protected this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.eventLoop =  true;
		NeGuiInfo.exStyle   |= WS_EX_CONTROLPARENT;
		NeGuiInfo.style     |= WS_POPUP | WS_CLIPCHILDREN;
		
		super(NeGuiInfo);
	}
	
	mixin(SMixInItemExStyleGetSet("contextHelp", q{WS_EX_CONTEXTHELP}));
	mixin(SMixInItemExStyleGetSet("taskBar", q{WS_EX_APPWINDOW}));
	mixin(SMixInItemExStyleGetSet("tab", q{WS_EX_CONTROLPARENT}, false));
	
	mixin(SMixInItemStyleGetSet("caption", q{WS_CAPTION}));
	mixin(SMixInItemStyleGetSet("clipChildren", q{WS_CLIPCHILDREN}));
	mixin(SMixInItemStyleGetSet("systemMenu", q{WS_SYSMENU}));

	mixin(SMixInItemStyleGetSet("frameThick", q{WS_THICKFRAME}));
	mixin(SMixInItemStyleGetSet("frameSize", q{WS_SIZEBOX}));
	
	mixin(SMixInItemStyleGetSet("maxButton", q{WS_MAXIMIZEBOX}));
	mixin(SMixInItemStyleGetSet("minButton", q{WS_MINIMIZEBOX}));
	

	const bool isSmall() {
		return cast(bool)IsIconic(hWnd);
	}
	bool openSmall() {
		return cast(bool)OpenIcon(hWnd);
	}
	bool toSmall() {
		return cast(bool)CloseWindow(hWnd);
	}
	
	const bool isZoom() {
		return cast(bool)IsZoomed(hWnd);
	}

	Window toActive() {
		auto hOldActiveWnd=SetActiveWindow(hWnd);
		if(auto OldGui=NeGui.getGuiObject(hOldActiveWnd)) {
			return cast(Window)OldGui;
		} else {
			return new OtherWindow(hOldActiveWnd);
		}
	}
	

	static enum CENTER {
		DESKTOP,
		WORKAREA,
		WINDOW
	}
	/**
	History:
		1.021:
			[S] 引数属性変更。
	*/
	bool toCenter(CENTER Center, in NeGui OwnerWindow=null)
	in {
		if(Center == CENTER.WINDOW) {
			assert(OwnerWindow.isAlive);
		}
	}
	body {
		auto WindowRect=itemRect();
		
		with(CENTER) final switch(Center) {
			case DESKTOP: {
				RECT DeskTop=void;
				GetWindowRect(GetDesktopWindow(), &DeskTop);
				return super.move(
					DeskTop.right  / 2 - (WindowRect.right  - WindowRect.left) / 2,
					DeskTop.bottom / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			// あわせねば
			case WORKAREA: {
				RECT WorkArea=void;
				SystemParametersInfo(SPI_GETWORKAREA, 0, &WorkArea, 0);
				return super.move(
					WorkArea.left + (WorkArea.right  - WorkArea.left) / 2 - (WindowRect.right  - WindowRect.left) / 2,
					WorkArea.top  + (WorkArea.bottom - WorkArea.top)  / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			case WINDOW: {
				auto OwnerRect=OwnerWindow.itemRect();
				
				return super.move(
					OwnerRect.left + (OwnerRect.right  - OwnerRect.left) / 2 - (WindowRect.right  - WindowRect.left) / 2,
					OwnerRect.top  + (OwnerRect.bottom - OwnerRect.top)  / 2 - (WindowRect.bottom - WindowRect.top)  / 2,
					WindowRect.right  - WindowRect.left,
					WindowRect.bottom - WindowRect.top,
					true
				);
			}
			//default:
			//	assert(false);
		}
	}
	/**
	クライアント領域を指定サイズに変更。

	Params:
		Width = 横幅。
		Hwight = 縦幅。

	Return:
		最終的なサイズ変更が成功すればtrue、失敗すればfalse。

	Exception:
		初っ端から失敗すればWindowException。
	*/
	bool adjustSize(in int Width, in int Height) {
		RECT Rect;
		Rect.right  = Width;
		Rect.bottom = Height;
		if(
			AdjustWindowRectEx(
				&Rect,
				this.getItemInfo(GWL.STYLE),
				GetMenu(hWnd) ? true: false,
				this.getItemInfo(GWL.EXSTYLE)
			)
		) {
			auto ItemRect=itemRect();
			return this.move(
				ItemRect.left, ItemRect.top,
				Rect.right - Rect.left, Rect.bottom - Rect.top,
				true
			);
		}
		
		throw new WindowException(Text("AdjustWindowRectEx"));
	}
	bool adjustSize(SIZE* Size) {
		return adjustSize(Size.cx, Size.cy);
	}

	static Window find(in Text ClassName, in Text TitleName) {
		wchar* pTitle  = TitleName.length ? TitleName.ptr: null;
	
		if(auto hWnd=FindWindow(ClassName.ptr, pTitle)) {
			if(auto gui=cast(Window)NeGui.getGuiObject(hWnd)) {
				return gui;
			} else {
				return new OtherWindow(hWnd);
			}
		} else {
			return null;
		}
	}
	static Window find(in Text ClassName) {
		return Window.find(ClassName, Text.emptyText);
	}

	mixin(SMixInItemExStyleGetSet("alphaStyle", q{WS_EX_LAYERED}));
	/**
	History:
		1.070:
			新規作成。
	*/
	enum ALPHA_TYPE {
		COLOR = LWA_COLORKEY, /// 透明色として crKey を使います。
		BLEND = LWA_ALPHA,    /// bAlpha を使って、レイヤードウィンドウの不透明度を決定します。
	}
	/**
	History:
		1.070:
			新規作成。
	*/
	bool alpha(in COLOR Color, ubyte Blend, ALPHA_TYPE AlphaType) {
		auto NowAlphaStyle=alphaStyle;
		bool AlphaFlag=true;
		/// 
		if((AlphaType & ALPHA_TYPE.BLEND) == ALPHA_TYPE.BLEND) {
			if(Blend == 255 && NowAlphaStyle) {
				AlphaFlag = AlphaType != ALPHA_TYPE.BLEND;
			}
		}
		if(!NowAlphaStyle && AlphaFlag) {
			alphaStyle = true;
		}
		if(AlphaFlag) {
			return cast(bool)SetLayeredWindowAttributes(hWnd, Color.code, Blend, AlphaType);
		} else {
			alphaStyle = false;
			return false;
		}
	}
	/**
	History:
		1.070:
			新規作成。
	*/
	bool alphaColor(in COLOR Color) {
		return alpha(Color, 0, ALPHA_TYPE.COLOR);
	}
	/**
	History:
		1.070:
			新規作成。
	*/
	bool alphaBlend(ubyte Blend) {
		return alpha(COLOR.init, Blend, ALPHA_TYPE.BLEND);
	}
}

/***/
final class OtherWindow: Window {
	this(HWND hWnd) {
		super(hWnd);
	}
}

Window GetParentWindow(NeGui base) {
	if(cast(Window)base) {
		return cast(Window)base;
	}
	auto gui=base;
	
	while(!cast(Window)gui.parent) {
		gui = gui.parent;
	}

	return cast(Window)gui.parent;
}

