﻿/**

*/
module nemuxi.negui.window.tooltip.tooltip;

debug import std.stdio: wl = writefln, pl = printf;

debug(tooltip) void main() {}

import win32.windows;
import win32.commctrl;

import nemuxi.negui.system.base;
import nemuxi.negui.negui;
import nemuxi.negui.window.window;

class ToolTip: Window {
	/**
	History:
		1.022:
			新規作成。
	*/
	protected this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.style     = TTS_ALWAYSTIP;
		NeGuiInfo.className = TOOLTIPS_CLASS;
		super(NeGuiInfo);
	}

	mixin(SMixInItemStyleGetSet("always", q{TTS_ALWAYSTIP}));

	/**
	現在の横幅取得。
	
	Return:
		現在の横幅。
		設定されていない場合は-1.
	
	History:
		1.022:
			新規作成。
	*/
	size_t width() {
		return send(TTM_GETMAXTIPWIDTH, NONE, NONE);
	}
	/**
	現在の横幅設定。

	Params:
		Width = 設定する横幅。
		        -1にするとたぶん未設定になるんじゃないかなぁ。
	
	Return:
		以前の横幅。
		設定されていない場合は-1.
	
	History:
		1.022:
			新規作成。
	*/
	size_t width(size_t Width) {
		return send(TTM_SETMAXTIPWIDTH, NONE, Width);
	}
}




