﻿/**

*/
module nemuxi.negui.window.newindow;

debug import std.stdio: wl = writefln, pl = printf;
debug(newindow) void main() {}

import std.contracts;

import win32.windows;

public import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
import nemuxi.negui.layout.layout;
public import nemuxi.negui.window.window;
public import nemuxi.negui.input.keyboard.accelerator;
public import nemuxi.negui.event.event;

///
class NeWindowException: WindowException {
	mixin MixInNeGuiException;
}
private immutable NEGUICLASS = "NeGuiWindow"w;

/**
History:
	1.032:
		[P] アトムを返す。

	1.021:
		新規作成。
*/
ATOM NeWindowInitialize() {
	WNDCLASSEX WndClass;

	with(WndClass) {
		cbSize          = WndClass.sizeof;
		style           = CS_HREDRAW | CS_SAVEBITS | CS_VREDRAW;
		lpfnWndProc     = &NeWindow.NeGuiEventProc;
		cbClsExtra      = 0;
		//cbWndExtra      = DLGWINDOWEXTRA;
		hInstance       = GetModuleHandle(null);
		hIcon = hIconSm = LoadIcon(hInstance, IDI_APPLICATION);
		hCursor         = LoadCursor(NULL, IDC_ARROW);
		hbrBackground   = cast(HBRUSH)COLOR_BTNFACE+1;
		lpszMenuName    = null;
		lpszClassName   = NEGUICLASS.ptr;
	}
	auto Atom=RegisterClassEx(&WndClass);
	enforce(Atom, new NeWindowException(Text("ウィンドウクラス登録失敗, %s", ERR.toText)));

	return Atom;
}

/**
History:
	1.000:
		[P] キーボードアクセラレータ引越し。
*/
abstract class NeWindow: Window {

	/**
	History:
		1.022:
			新規作成。
	*/
	protected override this(ref NEGUIINFO NeGuiInfo) {
		NeGuiInfo.className = NEGUICLASS;
		super(NeGuiInfo);
	}
	
	protected Accelerator AccelObject;
	Accelerator accelerator() {
		return AccelObject;
	}
	/**
	アクセラレータ。

	基本的にDialog以下で使用することを前提に設計してMainWindowで使えるようにNeWindowに格上げしたけどやっぱり使用はDialogが無難。

	Params:
		Accel = このダイアログに設定するアクセラレータ。
		        nullを設定すればアクセラレータを削除するが、killされない。

	--------------------------------
	class MyDialog: Dialog {
		enum ACCEL_COMMAND: COMMAND_ID {
			OK = Dialog.ACCELERATOR_DEFKEY.SAFE_START,
			CANCEL,
		}
		unittest {
			assert(ACCEL_COMMAND.max <= Dialog.ACCELERATOR_DEFKEY.SAFE_END);
		}
		
		void AccelSetting() {
			// Shift + A
			ACCELERATOR Shift_A;
			with(Shift_A) {
				command = ACCEL_COMMAND.OK;
				type    = cast(ACCELERATOR.TYPE)(ACCELERATOR.TYPE.SHIFT | ACCELERATOR.TYPE.VIRTKEY);
				key     = KEY.A;
			}
			
			// B
			ACCELERATOR B;
			with(B) {
				command = ACCEL_COMMAND.CANCEL;
				type    = ACCELERATOR.TYPE.VIRTKEY;
				key     = KEY.B;
			}
			
			// 現在ダイアログに設定されている
			// アクセラレータの参照取得。
			auto NowAccel = accelerator;

			if(NowAccel) {
				// 現在設定されていればマージ。
				NowAccel += [Shift_A, B];
			} else {
				// 設定されていなければ設定。
				accelerator = new Accelerator(Shift_A, B);
			}
		}
		protected override bool OnAccelerator(COMMAND_ID Id) {
			switch(Id) {
				case ACCEL_COMMAND.OK:
					text = Text("OK");
					return true;
				case ACCEL_COMMAND.CANCEL:
					text = Text("CANCEL");
					return true;
				default:
					return super.OnAccelerator(Id);
			}
		}
	}
	--------------------------------
	
	History:
		1.00β15:
			整理用にサンプルソース追記。
	*/
	void accelerator(Accelerator Accel) {
		if(cast(bool)(AccelObject = Accel)) {
			Accelerator.idRegist(this, AccelObject);
		} else {
			Accelerator.idUnRegist(this);
		}
	}

	mixin NeGuiDestructor;

	mixin MixInNeGuiEvent;

	mixin MixInNeGuiEventProc!(NeWindow);
}


