﻿/**
ポップアップメニュー。


*/
module nemuxi.negui.window.menu.popup;

debug import std.stdio: wl = writefln, pl = printf;

debug(popup) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.input.mouse.mouse;
public import nemuxi.negui.window.menu.menu;
import nemuxi.negui.negui;

///
class PopUpException: MenuException {
	mixin MixInNeGuiException;
}

enum {
	TPM_HORNEGANIMATION = 0x800,
	TPM_HORPOSANIMATION = 0x400,
	TPM_VERPOSANIMATION = 0x1000L,
	TPM_NOANIMATION     = 0x4000L,
	TPM_VERNEGANIMATION = 0x2000,
}

/// ポップアップメニュークラス。
class PopUp: Menu {
	/**
	コンストラクタ。

	CreatePopupMenuで生成されたメニューハンドルをラップ。

	Exception:
		ポップアップメニュー作成に失敗した場合はPopUpExceptionを投げる。
	*/
	this() {
		auto hMenu=CreatePopupMenu();
		
		if(!hMenu) {
			throw new PopUpException(Text("メニュー作成に失敗"));
		}
		super(hMenu, true);
	}

	/// ポップアップ表示フラグ。
	static enum FLAG {
		BOTTOMALIGN  = TPM_BOTTOMALIGN  , /// メニューの下端を、y パラメータの位置に合わせます。 
		CENTERALIGN  = TPM_CENTERALIGN  , /// メニューの水平方向の中心を、x パラメータの位置に合わせます。 
		LEFTALIGN    = TPM_LEFTALIGN    , /// メニューの左端を、x パラメータの位置に合わせます。 
		LEFTBUTTON   = TPM_LEFTBUTTON   , /// マウスの左ボタンをトラックします、 
		NONOTIFY     = TPM_NONOTIFY     , /// 通知メッセージを送らないようにします。 
		RETURNCMD    = TPM_RETURNCMD    , /// 関数の戻り値に、ユーザーがクリックしたメニュー項目のIDがセットされます。 
		RIGHTALIGN   = TPM_RIGHTALIGN   , /// メニューの右端を、x パラメータの位置に合わせます。 
		RIGHTBUTTON  = TPM_RIGHTBUTTON  , /// マウスの右ボタンをトラックします。 
		TOPALIGN     = TPM_TOPALIGN     , /// メニューの上端を、y パラメータの位置に合わせます。 
		VCENTERALIGN = TPM_VCENTERALIGN , /// メニューの垂直方向の中心を、y パラメータの位置に合わせます。

		//Windows 98 と Windows 2000：
		HORNEGANIMATION = TPM_HORNEGANIMATION , /// 左から右へ向かってメニューのアニメーション表示を行います。
		HORPOSANIMATION = TPM_HORPOSANIMATION , /// 右から左へ向かってメニューのアニメーション表示を行います。
		NOANIMATION     = TPM_NOANIMATION     , /// アニメーションなしでメニューを表示します。
		VERNEGANIMATION = TPM_VERNEGANIMATION , /// 下から上へ向かってメニューのアニメーション表示を行います。
		VERPOSANIMATION = TPM_VERPOSANIMATION , /// 上から下へ向かってメニューのアニメーション表示を行います。
		RECURSE         = TPM_RECURSE         , /// メニュー内で、特定のメニュー項目に関するチップヘルプの表示を有効にします。
	}
	deprecated alias FLAG TPM;
	/**
	ポップアップ表示。

	Params:
		Flags = ポップアップ表示フラグ。

		Point = 表示座標。

		hWnd = 表示する際の親ウィンドウ。

		Rect = 未だにコレの使い方が分からん。

	Return:
		FLAG.RETURNCMDが使用されていた場合は選択されたメニューID。
		それ以外は知らん。
	*/
	COMMAND_ID show(in NeGui Owner, FLAG Flags, ref const(POINT) Point, in RECT* Rect=null) {
		TPMPARAMS TpmParams=void;
		if(Rect) {
			TpmParams.cbSize    = TpmParams.sizeof;
			TpmParams.rcExclude = *Rect;
		}
		return cast(COMMAND_ID)TrackPopupMenuEx(
			hMenu,
			Flags,
			Point.x,
			Point.y,
			Owner(),
			Rect ? &TpmParams: null
		);
	}
	COMMAND_ID show(in NeGui Owner, FLAG Flags, in RECT* Rect=null) {
		//auto Point=Cursor.getPos();
		auto Point=MOUSE.position();

		return show(Owner, Flags, Point, Rect);
	}

	enum ATTACH {
		RIGHT,
		BOTTOM,
	}
	enum MESSAGE: FLAG {
		OWNER  = cast(FLAG)0,
		NONE   = FLAG.NONOTIFY,
		RETURN = FLAG.RETURNCMD,
	}
	COMMAND_ID attach(in NeGui Owner, in NeGui Target, ATTACH Attach, MESSAGE Message) {
		FLAG Flags=FLAG.LEFTALIGN | FLAG.TOPALIGN | FLAG.LEFTBUTTON | FLAG.RIGHTBUTTON | Message;

		POINT Point=void;
		auto Rect=Target.itemRect();

		final switch(Attach) {
			case ATTACH.RIGHT:
				Point.x = Rect.right+1;
				Point.y = Rect.top;
				break;
			case ATTACH.BOTTOM:
				Point.x = Rect.left;
				Point.y = Rect.bottom+1;
				break;
			//default:
			//	assert(false);
		}
		
		return show(Owner, Flags, Point, &Rect);
	}
}



