﻿/**

*/
module nemuxi.negui.window.menu.ownerdraw;

debug import std.stdio: wl = writefln, pl = printf;
debug(ownerdraw) void main() {}

debug import std.string;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.draw.canvas;
import nemuxi.negui.draw.color;
import nemuxi.negui.draw.font;
import nemuxi.negui.draw.brush;
import nemuxi.negui.draw.unit;
import nemuxi.negui.draw.icon;
import nemuxi.negui.draw.unit;
import nemuxi.negui.input.keyboard.keyboard;
import nemuxi.negui.system.type.record;
import nemuxi.negui.negui;
public import nemuxi.negui.window.menu.menu;
public import nemuxi.negui.window.menu.popup;

///
struct DRAWMENUITEM {
	Text text; /// 表示文字列
	Icon icon; /// 表示アイコン
	//wchar key; /// アクセスキー。
	KEY key; /// アクセスキー。

	debug string toString() {
		return format("[%s]%s", key, text);
	}
}

/**
オーナードローを少しだけ補助。
描画に必要そうなDRAWMENUITEMをIDと関連付けて保持と共にdwTypeDataにDRAWMENUITEMを設定。

History:
	1.060:
		[B] たぶんIcon.FIXEDの依存から脱却。
	1.021:
		[P] Icon.FIXEDに依存しすぎ。
*/
class OwnerDrawMenu: PopUp {
	protected {
		/// 対GC。Killの対象注意
		DRAWMENUITEM[COMMAND_ID] DrawItems;

		/// アイコンサイズに対応するピクセルサイズ。
		SIZE IconSize;
	}

	
	DRAWMENUITEM[] GetKeyItem(wchar c) {
		DRAWMENUITEM[] items;
		foreach(DrawItem; DrawItems) {
			if(DrawItem.key == c) {
				items ~= DrawItem;
			}
		}
		return items;
	}

	/**
	History:
		1.021:
			新規作成。
	*/
	this(const ref SIZE IconSize) {
		this.IconSize = IconSize;
		super();
	}

	this(Icon.FIXED IconFixed) {
		this(Icon.fixedToSizeEx(IconFixed));
	}

	void iconSize(const ref SIZE IconSize) {
		this.IconSize = IconSize;
	}
	const SIZE iconSize() {
		return IconSize;
	}

	override void Kill() {
		if(super.Suicide) {
			auto Values=this.DrawItems.values;
			foreach(key; this.DrawItems.keys) {
				this.DrawItems.remove(key);
			}
			foreach(DrawItem; Values) {
				delete DrawItem.icon;
				delete DrawItem.text.text;
			}
			this.DrawItems = null;
			
		}
		super.Kill();
	}

	///
	bool insert(ref const(MENUITEM) MenuItem, DRAWMENUITEM* DrawItem) {
		if(super.insert(MenuItem)) {
			if(DrawItem) {
				DrawItems[MenuItem.id] = *DrawItem;
			}
			
			return true;
		}

		return false;
	}

	/**
	History:
		1.060:
			[P] 戻り値の型変更。
	*/
	DRAWMENUITEM* isDrawItem(COMMAND_ID Id) {
		return Id in DrawItems;
	}
	// 保持しているDRAWMENUITEMの参照。
	DRAWMENUITEM* opIndex(COMMAND_ID Id)
	in {
		assert(isDrawItem(Id));
	}
	body {
		return &DrawItems[Id];
	}

	/**
	オーナードロー描画準備。
	*/
	void measureItem(NeGui gui, MEASUREITEM* MeasureItem) {
		assert(this.isDrawItem(MeasureItem.commandID), "設計ミス１");

		immutable IconArea=GetIconControlSize(IconSize);
		
		auto ItemData  =DrawItems[MeasureItem.commandID];

		scope font=new Font(Font.STOCK.MENU);
		scope canvas=gui.canvas();
		canvas.setFont(font);
		SIZE Size=void;
		Size=canvas.getTextArea(ItemData.text);
		MeasureItem.width  = IconArea.cx+ Size.cx;
		MeasureItem.height = GetMenuHeight(IconArea.cy);
	}
	/**
	オーナードロー描画。

	Bugs:
		無効アイテムの描画。
	*/
	void drawItem(DRAWITEM* DrawItem) {
		assert(this.isDrawItem(DrawItem.commandID), "設計ミス２");

		immutable IconArea=GetIconControlSize(IconSize);
		invariant IconWidth =IconArea.cx;
		invariant IconHeight=IconArea.cy;
		
		
		auto ItemData  =DrawItems[DrawItem.commandID];

		SYSTEMCOLOR TextColor;
		SYSTEMCOLOR BackColor;

		if(DrawItem.state & DRAWITEM.STATE.SELECTED) {
			if(DrawItem.state & DRAWITEM.STATE.DISABLED) {
				TextColor = SYSTEMCOLOR.MenuBack();
			} else {
				TextColor = SYSTEMCOLOR.SelectedText();
			}
			BackColor = SYSTEMCOLOR.SelectedBack();
		} else {
			TextColor = SYSTEMCOLOR.MenuText();
			BackColor = SYSTEMCOLOR.MenuBack();
		}
		
		scope back=new Brush(BackColor);
		scope font=new Font(Font.STOCK.MENU);
		scope canvas=DrawItem.canvas;
		canvas.textColor(cast(COLOR)TextColor);
		canvas.backMode(Canvas.BACKMODE.TR);
		canvas.setBrush(back);
		canvas.setFont(font);

		canvas.fillRect(DrawItem.rect);

		auto LineHeight=DrawItem.rect.bottom - DrawItem.rect.top;
		POINT IconPos=void;
		IconPos.x = DrawItem.rect.left + GetSystemMetrics(SM_CXEDGE);
		IconPos.y = DrawItem.rect.top  + LineHeight/2 - IconHeight/2 + GetSystemMetrics(SM_CYEDGE); // あとでかいぜん
		if(ItemData.icon) {
			SIZE Size;
			Size=IconSize;
			canvas.drawIcon(ItemData.icon, IconPos, Size, null);
		}

		IconPos.x += GetIconControlPadding.cx + IconSize.cx;
		IconPos.y =  DrawItem.rect.top  + LineHeight/2 + (PointToPixel(font.height()))/2;
		canvas.drawState(
			ItemData.text,
			IconPos,
			!(DrawItem.state & DRAWITEM.STATE.DISABLED),
			false
		);
	}

	/**
	History:
		1.060:
			[S] 名前変更。
	*/
	static enum CLOSE {
		IGNORE  = MNC_IGNORE , /// 押されたキーを破棄し、警告音を鳴らす(デフォルト)
		CLOSE   = MNC_CLOSE  , /// アクティブなメニューをクローズする
		EXECUTE = MNC_EXECUTE, /// 戻り値の下位ワードで指定するメニュー項目を破棄しオーナーウィンドウにWM_COMMANDを送る
		SELECT  = MNC_SELECT , /// 戻り値の下位ワードで指定するメニュー項目を選択する
	}
}


