﻿/**

*/
module nemuxi.negui.test;

import nemuxi.negui.allimport;

version(build) {
	pragma(build_def, "EXETYPE NT");
	pragma(build_def, "SUBSYSTEM WINDOWS,5.0");
}

void main() {
	auto aaa=new TestNeGui;
	aaa.execute;
}

class TestNeGui: MainWindow {
	enum CTRL: ITEM_ID {
		HELLO=1,
		EDIT,
		MSGBOX
	}
	private {
		TextLabel label;
		MultiEdit edit;
		Push button;
		
		Font CtrlFont, EditFont;
	}
	this() {
		NEGUIINFO g;
		super(&g);
	}
	protected override {
		void OnCreate() {
			// メインウィンドウ処理 -------------------------------
			// タイトルバーあり
			caption = true;
			// システムメニューあり
			systemMenu = true;
			// サイズ変更用境界線あり
			frameSize = true;
			// 表示状態
			setShow(SHOW.SHOWNORMAL);
			// 位置とサイズの設定
			move(0, 0, 200, 200);

			// メインウィンドウを親としてラベル作成 ---------------
			label = new TextLabel(this, CTRL.HELLO);
			// 水平位置設定
			label.horizonAlign   = HORIZON_ALIGN.CENTER;
			// 縦位置
			label.verticalCenter = true;
			// 文字設定
			label.text = Text("はろー わーるど");

			// メインウィンドウを親としてエディットボックス作成 ---
			edit = new MultiEdit(this, CTRL.EDIT);
			// 空白にしておく
			edit.text = Text.emptyText;

			// メインウィンドウを親としてボタン作成 ---------------
			button = new Push(this, CTRL.MSGBOX);
			// 文字設定
			button.text = Text("メッセージ表示");

			// フォント生成 ---------------------------------------
			CtrlFont = new Font(Font.STOCK.MESSAGE);
			EditFont = new Font(Font.STOCK.SYSTEM);
			EditFont.pitchAndFamily(Font.PITCH_FAMILY.MODERN);

			// 一括してフォントの設定 -----------------------------
			auto ctrls = new ControlGroup(label, edit, button);
			ctrls.font = CtrlFont;
			// エディットボックスは等幅
			edit.font = EditFont;

			// パネルの設定 ---------------------------------------
			auto panel = new Line(DIRECTION.VERTICAL);
			// ラベルの設定、 あまりの領域
			panel += label;
			panel.sizeInfo(0).absolute = -1;
			// エディットボックスの設定、50%
			panel += edit;
			panel.sizeInfo(1).percent = 50;
			// ボタンの設定、最低限の高さ
			panel += button;
			panel.sizeInfo(2).absolute = button.minContentHeight;
			// それぞれをウィンドウのパネルに設定
			layoutManager.basePanel = panel;
		}

		bool OnCommand(ITEM_ID Id, MESSAGETYPE MessageType, NeGui Sender) {
			if(Sender is button) {
				if(MessageType == Button.EVENT.CLICKED) {
					// メッセージボックス表示
					ShowMessage();
					return true;
				}
			}

			return false;
		}
	}

	private void ShowMessage() {
		// エディットボックスの文字列取得
		auto EditText = edit.text;
		// エディットボックスの改行数取得
		auto LineCount = edit.lineCount-1;
		// 取得文字列から文字列長取得
		auto TextLength = edit.textLength;

		// ダイアログ生成
		auto dialog = new MessageDialog();
		// 表示メッセージを書式付で
		dialog.message = Text(
			"文字列%s%s%s", Text.newline, EditText, Text.newline,
			"%s%s\n", Text.repeat(Text('-'), 40), Text.newline,
			"改行数 = %s\n", LineCount,
			"文字数 = %s\n", TextLength
		);
		// タイトルバーを日時に
		auto time = new DateTime();
		time.format = "[YY]/[M]/[D], [hh]:[mm]:[ss]";
		dialog.text = Text(time);
		// 表示アイコン
		dialog.icon = MessageDialog.ICON.INFORMATION;
		// ボタンの種類
		dialog.button = MessageDialog.BUTTON.OK;
		// 表示
		dialog.show;
	}
}


