﻿/**
タスクトレイ関連。

packageどこにしたらいいのか。
*/
module nemuxi.negui.tasktray;

debug import std.stdio: wl = writefln, pl = printf;

debug(tasktray) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
//import nemuxi.base;
import nemuxi.negui.draw.icon;
import nemuxi.negui.negui;
import nemuxi.negui.window.newindow;
//import nemuxi.negui.system.raii;

///
class TaskTrayException: NeGuiException {
	mixin MixInNeGuiException;
}



///
typedef int TASK_ID;


/**
タスクトレイ用の人。

History:
	1.032:
		[S] memberpropertyの適用。
*/
struct TASKTRAY {
	NOTIFYICONDATA NotifyIcon;
	mixin(SMixInStructHiddenOriginal!(NOTIFYICONDATA)(`NotifyIcon`));

	///
	class TaskTrayTextLengthException: TaskTrayException {
		mixin MixInNeGuiException;
	}

	void initialize() {
		NotifyIcon.cbSize = NotifyIcon.sizeof;
	}
	deprecated alias initialize sizeInit;

	/**
	History:
		1.032:
			[S] 属性変更。
	*/
	const NeWindow window() {
		return NotifyIcon.hWnd
			? cast(NeWindow)NeGui.getGuiObject(NotifyIcon.hWnd)
			: null
		;
	}
	/**
	History:
		1.032:
			[S] 引数属性変更。
	*/
	void window(in NeWindow window) {
		NotifyIcon.hWnd = window();
	}
	
	mixin(SMixInStructGetSet!(DWORD)("id", q{NotifyIcon.uID}));

	/**
	History:
		1.032:
			[S] 名前変更。
	*/
	static enum FLAG {
		MESSAGE = NIF_MESSAGE, /// uCallbackMessage
		ICON    = NIF_ICON, /// hIcon
		TIP     = NIF_TIP, /// szTip
		STATE   = NIF_STATE, /// Version 5.0 以降： dwState, dwStateMask
		INFO    = NIF_INFO, /// Version 5.0 以降： szInfo, uTimeout, szInfoTitle, dwInfoFlags
		GUID    = NIF_GUID, ///Version 6.0 以降： 予約されています。
	}
	mixin(SMixInStructGetSet!(FLAG)("flags", q{NotifyIcon.uFlags}));

	mixin(SMixInStructGetSet!(DWORD)("message", q{NotifyIcon.uCallbackMessage}));

	/**
	History:
		1.032:
			[S] 属性変更。
	*/
	const Icon icon() {
		return NotifyIcon.hIcon
			? new Icon(NotifyIcon.hIcon, false)
			: null
		;
	}
	/**
	History:
		1.032:
			[S] 引数属性変更。
	*/
	void icon(in Icon icon) {
		NotifyIcon.hIcon = icon();
	}

	static invariant auto TEXT_MAX = 128;
	Text tips()
	out(r) {
		assert(r.length < TEXT_MAX);
	}
	body {
		Text text=NotifyIcon.szTip.ptr;
		return text;
	}
	/**
	History:
		1.032:
			[P] 例外出力内容変更。
			[S] 引数属性変更。
	*/
	void tips(in Text text) {
		if(text.length >= TEXT_MAX) {
			throw new TaskTrayTextLengthException(Text("tool tip length over[%s]", text));
		}
		//NotifyIcon.szTip = text.text;
		lstrcpy(NotifyIcon.szTip.ptr, text.ptr);
	}

	/**
	History:
		1.032:
			[S] 名前変更。
	*/
	static enum STATE {
		NONE       = 0,
		HIDDEN     = NIS_HIDDEN, /// アイコンは非表示です。
		SHAREDICON = NIS_SHAREDICON, /// アイコンは共有されます。
	}
	deprecated alias STATE NIS;
	mixin(SMixInStructGetSet!(STATE)("state", q{NotifyIcon.dwState}));
	mixin(SMixInStructGetSet!(STATE)("stateMask", q{NotifyIcon.dwStateMask}));

	static invariant auto INFO_MAX = 255;
	Text infoTips()
	out(r) {
		assert(r.length < INFO_MAX);
	}
	body {
		Text text=NotifyIcon.szInfo.ptr;
		return text;
	}
	/**
	History:
		1.032:
			[P] 例外出力内容変更。
			[S] 引数属性変更。
	*/
	void infoTips(in Text text) {
		if(text.length >= INFO_MAX) {
			throw new TaskTrayTextLengthException(Text("info tip length over[%s]", text));
		}
		//NotifyIcon.szTip = text.text;
		lstrcpy(NotifyIcon.szInfo.ptr, text.ptr);
	}

	mixin(SMixInStructGetSet!(UINT)("timeOut", q{NotifyIcon.uTimeout}));
	
	static enum VER {
		WIN95 = 0,
		WIN2K = NOTIFYICON_VERSION
	}
	mixin(SMixInStructGetSet!(VER)("ver", q{NotifyIcon.uVersion}));

	static invariant auto TITLE_MAX = 64;
	Text infoTitle()
	out(r) {
		assert(r.length < TITLE_MAX);
	}
	body {
		Text text=NotifyIcon.szInfoTitle.ptr;
		return text;
	}
	/**
	History:
		1.032:
			[P] 例外出力内容変更。
			[S] 引数属性変更。
	*/
	void infoTitle(in Text text) {
		if(text.length >= TITLE_MAX) {
			throw new TaskTrayTextLengthException(Text("info title length over[%s]", text));
		}
		lstrcpy(NotifyIcon.szInfoTitle.ptr, text.ptr);
	}
	/**
	History:
		1.032:
			[S] 名前変更。
	*/
	static enum INFORMATION {
		NONE      = NIIF_NONE,      /// アイコンなし
		INFO      = NIIF_INFO,      /// 「情報」アイコン
		WARNING   = NIIF_WARNING,   /// 「警告」アイコン
		ERROR     = NIIF_ERROR,     /// 「エラー」アイコン
		ICON_MASK = NIIF_ICON_MASK, /// Version 6.0 以降： 予約されています。
		NOSOUND   = NIIF_NOSOUND,   /// Version 6.0 以降： 関連サウンドを鳴らさないようにします。バルーンツールチップにのみ適用されます。
	}
	deprecated alias INFORMATION NIIF;
	mixin(SMixInStructGetSet!(INFORMATION)("infoFlag", q{NotifyIcon.dwInfoFlags}));
}

enum {
	NIN_BALLOONSHOW      = 0x402, /// バルーンが表示されたとき
	NIN_BALLOONHIDE      = 0x403, /// バルーンが消えたとき（アイコンが消えたときなど）
	NIN_BALLOONTIMEOUT   = 0x404, /// タイムアウトによりバルーンが消えたとき
	NIN_BALLOONUSERCLICK = 0x405, /// ユーザーのマウスクリックによってバルーンが消えたとき
}

/**
タスクトレイ。

<del>
	これなんで抽象クラスなんだろ。
	もう忘れたなぁ。
<del>

History:
	1.000:
		[S] 抽象クラスじゃなくした。だけ。
*/
class TaskTray: Raii {
	/**
	Note:
		MOUSEMOVE-MBUTTONDBLCLKは無くてもいいかも。
	
	History:
		1.032:
			新規作成。
	*/
	enum EVENT: MESSAGETYPE {
		MOUSEMOVE     = WM_MOUSEMOVE,
		LBUTTONDOWN   = WM_LBUTTONDOWN,
		LBUTTONUP     = WM_LBUTTONUP,
		LBUTTONDBLCLK = WM_LBUTTONDBLCLK,
		RBUTTONDOWN   = WM_RBUTTONDOWN,
		RBUTTONUP     = WM_RBUTTONUP,
		RBUTTONDBLCLK = WM_RBUTTONDBLCLK,
		MBUTTONDOWN   = WM_MBUTTONDOWN,
		MBUTTONUP     = WM_MBUTTONUP,
		MBUTTONDBLCLK = WM_MBUTTONDBLCLK,

		BALLOONSHOW      = NIN_BALLOONSHOW,      /// バルーンが表示されたとき
		BALLOONHIDE      = NIN_BALLOONHIDE,      /// バルーンが消えたとき（アイコンが消えたときなど）
		BALLOONTIMEOUT   = NIN_BALLOONTIMEOUT,   /// タイムアウトによりバルーンが消えたとき
		BALLOONUSERCLICK = NIN_BALLOONUSERCLICK, /// ユーザーのマウスクリックによってバルーンが消えたとき
	}
	/**
	History:
		1.032:
			[S] 属性変更。
	*/
	static immutable UINT WM_TASKBAR_CREATED;
	deprecated alias WM_TASKBAR_CREATED TaskBar;
	/**
	History:
		1.050:
			[S] deprecated修正。
	*/
	static this() {
		WM_TASKBAR_CREATED = RegisterWindowMessage(Text("TaskbarCreated").ptr);
		auto Code=ERR.code;
		///
		class TaskTrayTaskbarCreatedException: TaskTrayException {
			mixin MixInNeGuiException;
		}
		enforce(WM_TASKBAR_CREATED, new TaskTrayTaskbarCreatedException(ERR.toText(Code)));
	}
	/**
	History:
		1.032:
			[S] 名前変更。
	*/
	private static enum MESSAGE: UINT {
		ADD    = NIM_ADD, /// ステータスエリアにアイコンを追加します。
		MODIFY = NIM_MODIFY, /// アイコンを変更します。
		DELETE = NIM_DELETE, /// アイコンを削除します。
		SETFOCUS = NIM_SETFOCUS, /// Version 5.00 以降： タスクバー通知エリアにフォーカスを返します。タスクバーアイコンは、ユーザーインターフェース操作が完了したときにこのメッセージを送るべきです。例えば、タスクバーアイコンにショートカットメニューを表示して、ユーザーが ESC キーを押してキャンセルしたときに、このメッセージを送信してフォーカスをタスクバー通知エリアに返すべきです。
		SETRVERSION = NIM_SETVERSION, /// Version 5.00 以降： pnid パラメータで指定される NOTIFYICONDATA 構造体の uVersion メンバで指定されるバージョンに従って振舞うようにタスクバーに指定します。このメンバのデフォルト値は 0 であり、原型の Windows 95 の通知アイコンにおける振舞いになります。
	}
	deprecated alias MESSAGE NIM;
	
	this(bool Suicide=false) {
		super(Suicide);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	private bool Notify(MESSAGE Message, const ref TASKTRAY Tray) {
		return cast(bool)Shell_NotifyIcon(Message, Tray.ptr);
	}

	/**
	History:
		1.050:
			[S] deprecated修正。
	
		1.032:
			新規作成。
	*/
	final bool addTray(const ref TASKTRAY Tray, bool WaitFlag=false, uint WaitTime=500, size_t LoopCount=5)
	in {
		if(WaitFlag) {
			assert(WaitTime);
			assert(LoopCount);
		}
	}
	body {
		if(!WaitFlag) {
			return Notify(MESSAGE.ADD, Tray);
		} else {
			size_t i=0;
			try {
				do {
					ERR.initialize;
					if(Notify(MESSAGE.ADD, Tray)) {
						return true;
					} else if(ERR.code != ERROR_TIMEOUT) {
						///
						class TaskTrayTimeOutException: TaskTrayException {
							mixin MixInNeGuiException;
						}
						throw new TaskTrayTimeOutException(ERR.toText);
					} else if(this.modifyTray(Tray)) {
						return true;
					} else {
						Sleep(WaitTime);
					}
				} while(LoopCount > i++)

				throw new TaskTrayException(Text("?"));
				
			} catch(TaskTrayException e) {
				///
				class TaskTrayAddFailureException: TaskTrayException {
					mixin MixInNeGuiException;
				}
				throw new TaskTrayAddFailureException(Text("failure."), e);
			}
		}
	}
	
	/**
	History:
		1.032:
			新規作成。
	*/
	final bool modifyTray(const ref TASKTRAY Tray) {
		return Notify(MESSAGE.MODIFY, Tray);
	}
	
	/**
	History:
		1.032:
			新規作成。
	*/
	final bool deleteTray(const ref TASKTRAY Tray) {
		return Notify(MESSAGE.DELETE, Tray);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	final bool focusTray(const ref TASKTRAY Tray) {
		return Notify(MESSAGE.SETFOCUS, Tray);
	}

	/**
	History:
		1.032:
			新規作成。
	*/
	final bool versionTray(const ref TASKTRAY Tray) {
		return Notify(MESSAGE.SETRVERSION, Tray);
	}
}



