﻿/**

*/
module nemuxi.negui.system.type.record;

debug import std.stdio: wl = writefln, pl = printf;
debug(record) void main() {}

import std.bitmanip;
import std.string;
//import std.contracts;

import win32.core;
import win32.shellapi;
import win32.commctrl;

import nemuxi.negui.system.type.basic;
import nemuxi.negui.system.type.enumerated;
import nemuxi.negui.system.meta.memberproperty;
import nemuxi.negui.negui;
import nemuxi.negui.draw.canvas;

/**
History:
	1.022:
		[S] 構造体が共用体をメンバにして構造体が定義してあった。書いてる自分もよくわからん。
*/
union NEGUIPOINT {
	//union {
		LPARAM lParam;
		struct {
			short x;
			short y;
		}
	//}
}



unittest {
	assert(NMHDR.sizeof == NOTIFY.sizeof);
}
///
struct NOTIFY {
	NMHDR Nmhdr;
	mixin(SMixInStructHiddenOriginal!(void*)(q{Nmhdr}));

	//mixin(SMixInStructGetSet!(HWND)("handle", q{Nmhdr.hwndFrom}));
	NeGui sender() {
		return NeGui.getGuiObject(Nmhdr.hwndFrom);
	}
	mixin(SMixInStructGetSet!(ITEM_ID)("id", q{Nmhdr.idFrom}));
	mixin(SMixInStructGetSet!(MESSAGETYPE)("code", q{Nmhdr.code}));
}

unittest {
	assert(MEASUREITEMSTRUCT.sizeof == MEASUREITEM.sizeof);
}
/***/
struct MEASUREITEM {
	MEASUREITEMSTRUCT MeasureItem;
	mixin(SMixInStructHiddenOriginal!(MEASUREITEMSTRUCT)(q{MeasureItem}));

	mixin(SMixInStructGetSet!(CONTROL_TYPE)("type", q{MeasureItem.CtlType}));
	mixin(SMixInStructGetSet!(ITEM_ID)("id", q{MeasureItem.CtlID}));

	mixin(SMixInStructGetSet!(COMMAND_ID)("commandID", q{MeasureItem.itemID}));
	
	mixin(SMixInStructGetSet!(int)("width", q{MeasureItem.itemWidth}));
	mixin(SMixInStructGetSet!(int)("height", q{MeasureItem.itemHeight}));

	mixin(SMixInStructGetSet!(void*)("data", q{MeasureItem.itemData}));
}
unittest {
	assert(DRAWITEMSTRUCT.sizeof == DRAWITEM.sizeof);
}
/***/
struct DRAWITEM {
	DRAWITEMSTRUCT DrawItem;
	mixin(SMixInStructHiddenOriginal!(DRAWITEMSTRUCT)(q{DrawItem}));

	mixin(SMixInStructGetSet!(CONTROL_TYPE)("type", q{DrawItem.CtlType}));
	mixin(SMixInStructGetSet!(ITEM_ID)("id", q{DrawItem.CtlID}));
	mixin(SMixInStructGetSet!(COMMAND_ID)("commandID", q{DrawItem.itemID}));

	///
	enum ACTION {
		DRAWENTIRE = ODA_DRAWENTIRE, /// コントロール全体を描画する必要がある場合は、このビットが設定されます。
		FOUCS      = ODA_FOCUS     , /// コントロールが入力フォーカスを取得したり失ったりするときに、このビットが設定されます。itemState メンバをチェックして、コントロールがフォーカスを持っているかどうかを調べる必要があります。
		SELECT     = ODA_SELECT    , /// 選択項目のステータスが変更されたときにだけ、このビットが設定されます。itemState メンバをチェックして、新しい選択項目のステータスを調べる必要があります。
	}
	mixin(SMixInStructGetSet!(ACTION)("action", q{DrawItem.itemAction}));

	/// 現在の描画動作が行われた後の項目の表示状態を指定します。
	enum STATE {
		CHECKED      = ODS_CHECKED     , /// メニュー項目をチェックする場合は、このビットが設定されます。このビットはメニューだけで使われます。
		DISABLED     = ODS_DISABLED    , /// 項目を使用できない状態で描画する場合は、このビットが設定されます。
		FOCUS        = ODS_FOCUS       , /// 項目が入力フォーカスを持つ場合は、このビットが設定されます。
		GRAYED       = ODS_GRAYED      , /// 項目を淡色表示する場合は、このビットが設定されます。このビットはメニューだけで使われます。
		SELECTED     = ODS_SELECTED    , /// 項目が選択されている場合は、このビットが設定されます。
		COMBOBOXEDIT = ODS_COMBOBOXEDIT, /// 描画が、オーナー描画コンボ ボックスの選択フィールド (エディット コントロール) で行われます。
		DEFAULT      = ODS_DEFAULT     , /// 項目は既定の項目です。
	}
	mixin(SMixInStructGetSet!(STATE)("state", q{DrawItem.itemState}));

	Canvas canvas() {
		return new Canvas(DrawItem.hDC, false);
	}

	// これどうしよ
	mixin(SMixInStructGetSet!(HWND)("handle", q{DrawItem.hwndItem}));
	
	ref RECT rect() {
		return DrawItem.rcItem;
	}
	mixin(SMixInStructGetSet!(void*)("data", q{DrawItem.itemData}));
}


