﻿/**
配列。

たいそうな名前だけどしょうもないことをやってるだけ。
可能な限りpublic importされるstd.arrayで済ませたい。
Rengeすらつかわない。

History:
	1.000:
		新規作成。
*/
module nemuxi.negui.system.small.array;

debug import std.stdio: wl = writefln, pl = printf;
debug(array) void main() {}

import algorithm=std.algorithm;
public import std.array;
import std.contracts;


public import nemuxi.negui.system.text;
public import nemuxi.negui.system.exception;
public import nemuxi.negui.system.literal;

///
class NeGuiArrayException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
要素が使用可能か。

History:
	1.021:
		[S] 名前変更(isSafe -> isSafe)。
*/
bool isSafe(T)(in T[] Array, size_t Index) {
	return Array.length && Array.length > Index;
}
/// ditto
bool isSafe(T)(in T[] Array, size_t From, size_t Size) {
	return Array.isSafe(From) && Array.isSafe(From + Size);
}
debug(array) unittest {
	int[5] a;
	assert(isSafe(a, 4));
	assert(!isSafe(a, 5));
	assert(!isSafe(a, 10));
	assert(isSafe(a, 0, 2));
	assert(isSafe(a, 0, 4));
	assert(!isSafe(a, 0, 5));
	assert(isSafe(a, 2, 2));
	assert(!isSafe(a, 5, 0));
	assert(isSafe(a, 0, 0));

	assert(a.isSafe(1));
	assert(!a.isSafe(10));
	assert(a.isSafe(0, 1));
	assert(!a.isSafe(0, 10));
}

/**
削除。

むかしPhobosにあったような気がしたんだけどなぁ。
*/
T[] erase(T)(ref T[] Array, size_t Index) {
	///
	class NeGuiArrayEraseException: NeGuiArrayException {
		mixin MixInNeGuiException;
	}
	enforce(Array.isSafe(Index), new NeGuiArrayEraseException(Text("Array.length == %s <= Index == %s", Array.length, Index)));

	if(Array.length == 1) {
		assert(Index == 0);
		Array.length = 0;
	} else if(Array.length-1 == Index) {
		Array.length = Array.length - 1;
	} else {
		if(Index) {
			Array = Array[0 .. Index] ~ Array[Index+1 .. Array.length];
		} else {
			Array = Array[1 .. Array.length];
		}
	}

	return Array;
}
debug(array) unittest {
	int[] fa1() { return [1,2,4,8,16];}
	int[][] fa2() { return [
		[2,4,8,16],
		[1,4,8,16],
		[1,2,8,16],
		[1,2,4,16]
	];}
	int[] a;
	
	a=fa1;
	assert(a.length == 5);
	a.erase(4);
	assert(a.length == 4);
	assert(a[$-1] == 8);
	a=fa1;
	a.erase(0);
	assert(a[0] == 2);

	
	foreach(index; 0 .. fa1.length-1) {
		a=fa1;
		assert(a.erase(index)==fa2[index]);
	}
}

T[] autoIncrement(T)(ref T[] Array, in size_t Index, in size_t Increment=BUFFER.INCREMENT)
out(r) {
	assert(r.isSafe(Index));
}
body {
	if(Array.length <= Index) {
		Array.length = Array.length + Increment;
	}
	
	return Array;
}


/**
最終要素の取得。
ただのlength-1を返すだけ。

Exception:
	配列が空だったらNeGuiArrayException。

History:
	1.022:
		新規作成。
*/
size_t lastIndex(T)(in T[] Array) {
	///
	class NeGuiArrayLastIndexException: NeGuiArrayException {
		mixin MixInNeGuiException;
	}
	
	if(auto Length=Array.length) {
		return Length - 1;
	}
	throw new NeGuiArrayLastIndexException(Text("Array.length == 0"));
}
debug(array) unittest {
	int[5] a;
	assert(a.lastIndex == 4);
	int[0] b;
	try {
		b.lastIndex;
		assert(false);
	} catch(NeGuiArrayException e) {
		assert(true);
	}
}
///
interface IArrayLastIndex {
	/**
	最終要素を返す。

	Return:
		最終要素の添え字。

	Exception:
		要素が無ければNeGuiExceptionっぽいのを投げる。
	*/
	const size_t lastIndex();
}

/**
検索。

History:
	1.051:
		新規作成。
*/
size_t indexOf(T)(in T[] Array, in T SearchValue) {
	foreach(i, ref Value; Array) {
		if(SearchValue == Value) {
			return i;
		}
	}
	return -1;
}
/**
検索。

History:
	1.051:
		新規作成。
*/
size_t lastIndexOf(T)(in T[] Array, in T SearchValue) {
	foreach_reverse(i, ref Value; Array) {
		if(SearchValue == Value) {
			return Array.lastIndex - i;
		}
	}
	return -1;
}

debug(array) unittest {
	int[5] a;
	assert(a.indexOf(0) == 0);
	a = [1,2,3,4,5];
	assert(a.indexOf(0) == -1);
	assert(a.indexOf(1) == 0);
	assert(a.lastIndexOf(1) == 4);
	assert(a.lastIndexOf(0) == -1);

}

