﻿/**

*/
module nemuxi.negui.system.meta.memberproperty;

debug import std.stdio: wl = writefln, pl = printf;
debug(memberproperty) void main() {}

pure nothrow string SMixInClassGet(T)(in string Method, in string Member, bool Override)
in {
	assert(Method.length);
	assert(Member.length);
}
body {
	return `

	` ~ (Override ? "override": "") ~ ` const  ` ~ (T).stringof ~ ` ` ~ Method ~ `() {
		return cast(` ~ (T).stringof ~ `)` ~ Member ~ `;
	}

	`;
}
pure nothrow string SMixInClassSet(T)(in string Method, in string Member, bool Override)
in {
	assert(Method.length);
	assert(Member.length);
}
body {
	invariant Arg = Method ~ "Arg";
	
	return `

	` ~ (Override ? "override": "") ~ ` void ` ~ Method~ `(in ` ~ (T).stringof ~ ` ` ~ Arg ~ `) {
		` ~ Member ~ ` = cast(typeof(` ~ Member ~ `))` ~ Arg ~ `;
	}

	`;
}

pure nothrow string SMixInStructGet(T)(in string Method, in string Member) {
	return SMixInClassGet!(T)(Method, Member, false);
}
pure nothrow string SMixInStructSet(T)(in string Method, in string Member) {
	return SMixInClassSet!(T)(Method, Member, false);
}

pure nothrow string SMixInClassGetSet(T)(in string Method, in string Member, bool Override) {
	return
	SMixInClassGet!(T)(Method, Member, Override)
	~
	SMixInClassSet!(T)(Method, Member, Override)
	;
}

///
pure nothrow string SMixInStructGetSet(T)(in string Method, in string Member) {
	return SMixInClassGetSet!(T)(Method, Member, false);
}

/**
History:
	1.061:
		[S] あまりにもvoid*がキモかったんで修正。

	1.00β15:
		[S] なんとなーくTをポインタの型じゃなくて元の型に変更。void*が微妙な記述になった。
*/
pure nothrow string SMixInStructHiddenOriginal(T)(in string Member)
in {
	assert(Member.length);
}
body {
	string TYPE;
	if(is(T == void*)) {
		TYPE = void.stringof;
	} else {
		TYPE = T.stringof;
	}
	
	return `
	const ` ~ TYPE ~ `* ptr() {
		return cast(` ~ TYPE ~ `*)&` ~ Member ~ `;
	}

	const ` ~ TYPE ~ `* opDot() {
		return cast(` ~ TYPE ~ `*)&` ~ Member ~ `;
	}
	
	`;
}

