﻿/**
NeGuiの例外クラス。

NeGuiはException投げてもErrorは投げない。
※あくまで明示的にだけど。

History:
	1.00β19:
		新規作成。
*/
module nemuxi.negui.system.exception;

debug import std.stdio: wl = writefln, pl = printf;
debug(exception) void main() {}

import std.contracts;
import std.date;
import std.date;
import std.string;

import nemuxi.negui.system.base;

/**
History:
	1.032:
		[F] NeGui自体にエラーコードいらねーや。
*/
class NeGuiException: Exception {
	private {
		d_time  Time;
	}
	this(in Text msg, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg.text8, file, line, next);
		Time = UTCtoLocalTime(getUTCtime());
	}
	final const DateTime time() {
		return new DateTime(Time);
	}

	/**
	Note:
		Throwable.toStringと組み合わせて使用するためconstでない。
	
	History:
		1.032:
			新規作成。
	*/
	protected string ExceptionMessage() {
		return format(
			"%s@%s(%s): %s [%s]",
			this.classinfo.name,
			file,
			line,
			msg,
			time
		);
	}
	/**
	History:
		1.032:
			[P] 処理内容変更。
	*/
	override string toString() {
		auto s=ExceptionMessage();
		
		if(next) {
			s ~= newline ~ next.toString;
		}

		return s;
	}
}
template MixInNeGuiException() {
	override this(in Text msg, Throwable next=null, string file=__FILE__, int line=__LINE__) {
		super(msg, next, file, line);
	}
}


