﻿/**
Windowsエラー

とりあえずErr構造体が何とかしてくれる。

Bugs:
	NeGuiに統合すべき。

History:
	1.00β20:
		[S] package, module, その他色々変更。
*/
module nemuxi.negui.system.error;

debug(error) void main() {}

import std.windows.syserror;

import win32.windows;

import nemuxi.negui.system.text;

/**
エラー表示のためのnamespaceっぽいの。

ErrだとNeGuiの構造体じゃなくなるからERRORにしてみたらwin32.wingdiとがっちんこ。
Errorにするとこれまた構造体じゃなくなるからERRで。

History:
	1.032:
		[S] 名前変更。
		[P] I/Fを若干変更。
*/
static struct ERR {
static:
	/// エラーコード設定。
	void code(DWORD ErrCode) {
		SetLastError(ErrCode);
	}
	/// エラーコード取得。
	DWORD code() {
		return GetLastError();
	}

	/**
	非エラーのエラーコード取得。
	
	History:
		1.032:
			新規作成。
	*/
	DWORD init() {
		return NO_ERROR;
	}
	
	/// エラーコード初期化。
	void initialize() {
		code(init);
	}

	
	/**
	エラー文字列を取得。
	
	History:
		1.032:
			[S] 名前変更(text -> toText)
	*/
	Text toText(DWORD Code=code()) {
		return sysErrorString(Code).toText;
	}
	/// ditto
	deprecated alias toText text;
	
	/// ditto
	string toString(DWORD Code=code()) {
		return sysErrorString(Code);
	}
}


