﻿/**
NeGui初期化。

ホントはmainとかWinMainにラップできればよかったんだかどなー。

History:
	1.031:
		新規作成。
*/
module nemuxi.negui.neguiinitialize;

debug import std.stdio: wl = writefln, pl = printf;
debug(neguiinitialize) void main() {}

import std.contracts;

import nemuxi.negui.system.base;
import nemuxi.negui.com.com;
import nemuxi.negui.window.newindow;
import nemuxi.negui.control.control;

///
class NeGuiInitializeException: NeGuiException {
	mixin MixInNeGuiException;
}


private version(unittest) {
	bool NoCall=true;
}

/**
History:
	1.051:
		[B] NeControlInitialize忘れ。
*/
void NeGuiInitialize() {
	version(unittest) assert(NoCall);
	scope(exit) version(unittest) NoCall = false;

	try {
		NeWindowInitialize();
		NeControlInitialize();
		CommonControlInitialize();
		ComInitialize();
	} catch(Exception e) {
		throw new NeGuiInitializeException(Text("negui initialize"), e);
	}
}

void NeGuiUnInitialize() {
	ComUnInitialize();
}

string SMixInNeGuiInitialize() {
	return `

	NeGuiInitialize();
	scope(exit) {
		NeGuiUnInitialize();
	}

	`;
}

