﻿/**
Note:
	NeGuiへ移動すべき。
	移動したけど要調整。

History:
	1.00β19:
		新規作成。
*/
module nemuxi.negui.mutex;

debug import std.stdio: wl = writefln, pl = printf;
debug(mutex) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;

import nemuxi.system.exception;

///
class MutexException: NeGuiException {
	mixin MixInNeGuiException;
}

class Mutex: HandleRaii {
	protected HANDLE hMutex;
	mixin KillResource!("ミューテックス", hMutex, CloseHandle, 0);
	
	this(in Text MutexName) {
		try {
			ERR.initialize;
			auto mutex=CreateMutex(null, 0, MutexName.ptr);
			enforce(ERR.code != ERROR_ALREADY_EXISTS, new MutexException(Text("%s[MutexName = %s]", ERR.toText.text8, MutexName.text8)));
			super(mutex, true);
		} catch(Throwable e) {
			throw new MutexException(Text("Mutex"), e);
		}
	}
}

