﻿/**
パネル。

テーブルみたいなんを作りたかったけどLineとかTansu使えば補完できたのでもはややる気なっしんぐ。
*/
module nemuxi.negui.layout.panel.panel;

debug import std.stdio: wl = writefln, pl = printf;
debug(panel) void main() {}

import std.math;
import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.layout.layout;

///
class PanelException: LayoutException {
	mixin MixInNeGuiException;
}

/// 方向。
enum DIRECTION {
	HORIZON,  /// 水平
	VERTICAL, /// 垂直
}

/***/
struct CONTENT {
	invariant() {
		if(type == TYPE.NONE) {
			assert(!None);
		} else {
			if(type == TYPE.GUI) {
				assert(cast(NeGui)gui.guiObject());
			}
		}
	}
	///
	enum TYPE {
		NONE,  ///
		GUI,   ///
		PANEL, ///
	}
	///
	TYPE type;
	
	/**
	なんとなく共用体。後悔してる。

	History:
		1.030:
			[S] 不要になったstructの排除。
	
		1.00β18:
			[S] dockがあまりにも不憫だったので介錯。
	*/
	union {
		void* None=null; /// 何にも保持してない。
		union {
			NeGui   gui;   /// 内部コントロール。将来的にControlに置き換えたい。
			Panel panel; /// 内部パネル。
		}
	}
	

	/***/
	void set(NeGui gui, Panel panel)
	in {
		if(gui)   assert(!panel);
		if(panel) assert(!gui);
	}
	body {
		if(gui) {
			type = TYPE.GUI;
			this.gui = gui;
		} else if(panel) {
			type = TYPE.PANEL;
			this.panel = panel;
		} else {
			type = TYPE.NONE;
			None = null;
		}
	}

	/**
	サイズ変更を実行。

	Layout.onSizeでLayout.Contentsから呼び出す。
	TYPE.PANELはpanelに任せてTYPE.GUIの処理を行う。

	Params:
		ContentSize = 自身が使用できる領域。
		              Layout.onSizeと違い、こちらはpadding, marginが考慮されたコンテンツ領域。
		              margin等の計算はLayout.onSizeで行う。

	History:
		1.030:
			[S] final switchの導入。
	*/
	package void onSize(ref const(RECT) ContentSize) {
		with(TYPE) final switch(type) {
			case GUI:
				gui.move(ContentSize.left, ContentSize.top, ContentSize.right - ContentSize.left, ContentSize.bottom - ContentSize.top);
				break;
			case PANEL:
				panel.onSize(ContentSize);
				break;
			case NONE:
				break;
		}
	}
}

package enum {
	ABSOLUTE_SIZE = 40,
}
struct SIZEINFO {
	enum TYPE {
		ABSOLUTE,
		PERCENT,
	}
	TYPE type = TYPE.ABSOLUTE;
	union {
		int  Absolute = ABSOLUTE_SIZE;
		real Percent;
	}
	/// 微調整用。使用注意。
	int absolute() const {
		if(type != TYPE.ABSOLUTE) {
			throw new PanelException(Text("type != ABSOLUTE"));
		}
		return Absolute;
	}
	void absolute(int Absolute) {
		type = TYPE.ABSOLUTE;
		this.Absolute = Absolute;
	}
	real percent() const {
		if(type != TYPE.PERCENT) {
			throw new PanelException(Text("type != PERCENT"));
		}
		return Percent;
	}
	void percent(real Percent) {
		type = TYPE.PERCENT;
		this.Percent = Percent;
	}
}

/***/
abstract class Panel: Layout {
	protected {
		CONTENT[] Contents;
	}

	///
	size_t length() const {
		return Contents.length;
	}
	/// ditto
	void length(in size_t Length) {
		Contents.length = Length;
	}
	
	/***/
	ref CONTENT opIndex(in size_t Index) const {
		return cast(CONTENT)Contents[Index];
	}
	/***/
	void opIndexAssign(CONTENT Content, in size_t Index) {
		Contents[Index] = Content;
	}
	/// ditto
	void opIndexAssign(NeGui gui, in size_t Index) {
		Contents[Index].set(gui, null);
	}
	/// ditto
	void opIndexAssign(Panel panel, in size_t Index) {
		Contents[Index].set(null, panel);
	}
	void opIndexAssign(void* None, in size_t Index)
	in {
		assert(!None);
	}
	body {
		Contents[Index].set(null, null);
	}
	
	private static void OpAddAssign(ref CONTENT[] Contents, NeGui gui, Panel panel) {
		try {
			CONTENT Content;
			
			Content.set(gui, panel);
			
			Contents ~= Content;
		} catch(Error e) {
			throw new PanelException(Text("OpAddAssign"), e);
		}
	}
	/***/
	void opAddAssign(CONTENT Content) {
		Contents ~= Content;
	}
	/// ditto
	void opAddAssign(NeGui gui) {
		OpAddAssign(Contents, gui, null);
	}
	/// ditto
	void opAddAssign(Panel panel) {
		OpAddAssign(Contents, null, panel);
	}
	/// ditto
	void opAddAssign(void* None)
	in {
		assert(!None);
	}
	body {
		OpAddAssign(Contents, null, null);
	}
	/***/
	NeGui gui(in size_t Index) const {
		try {
			return cast(NeGui)Contents[Index].gui;
		} catch(Error e) {
			throw new PanelException(Text("gui"), e);
		}
	}
	/***/
	Panel panel(in size_t Index) const {
		try {
			return cast(Panel)Contents[Index].panel;
		} catch(Error e) {
			throw new PanelException(Text("panel"), e);
		}
	}

	/**
	パディング領域を含む領域の取得。

	History:
		1.00β18:
			[S] protected属性に変更。
	*/
	final protected ref RECT GetInPaddingSize(ref const(RECT) TotalSize) {
		auto InPaddingSize=new RECT;
		
		InPaddingSize.left   = TotalSize.left   + margin.left;
		InPaddingSize.top    = TotalSize.top    + margin.top;
		InPaddingSize.right  = TotalSize.right  - margin.right;
		InPaddingSize.bottom = TotalSize.bottom - margin.bottom;

		return *InPaddingSize;
	}

	/**
	有効なコンテント領域の取得。

	History:
		1.00β18:
			[S] protected属性に変更。
	*/
	final protected ref RECT GetContentSize(ref const(RECT) InPaddingSize) {
		auto ContentSize=new RECT;
		
		ContentSize.left   = InPaddingSize.left   + padding.left;
		ContentSize.top    = InPaddingSize.top    + padding.top;
		ContentSize.bottom = InPaddingSize.bottom - padding.bottom;
		ContentSize.right  = InPaddingSize.right  - padding.right;
	
		return *ContentSize;
	}

	/**
	History:
		1.00β18:
			新規作成。
	*/
	final protected const size_t GetTotalPaddingSize(in DIRECTION Direction, const ref RECT InPaddingSize) {
		final switch(Direction) {
			case DIRECTION.HORIZON:
				return InPaddingSize.right - InPaddingSize.left - ((padding.left + padding.right) * Contents.length);
			case DIRECTION.VERTICAL:
				return InPaddingSize.bottom - InPaddingSize.top - ((padding.bottom + padding.top) * Contents.length);
		}
	}


}

interface IDirection {
	const DIRECTION direction();
	const int GetElemntSize(in DIRECTION Direction, ref const(SIZEINFO) SizeInfo, ref const(RECT) InPaddingSize);
}
template TDirection() {
	protected DIRECTION Direction;
	override const DIRECTION direction() {
		return Direction;
	}
	/**
	History:
		1.00β18:
			[S] 余白計算部分分散化。
	*/
	override const int GetElemntSize(in DIRECTION Direction, ref const(SIZEINFO) SizeInfo, ref const(RECT) InPaddingSize) {
		final switch(SizeInfo.type) {
			case SIZEINFO.TYPE.ABSOLUTE:
				return SizeInfo.absolute;
			case SIZEINFO.TYPE.PERCENT:
				return cast(int)lrint((cast(real)(GetTotalPaddingSize(Direction, InPaddingSize)) / 100) * SizeInfo.percent);
		}
	}
}

