﻿/**
ライン。
*/
module nemuxi.negui.layout.panel.line;

debug import std.stdio: wl = writefln, pl = printf;
debug(line) void main() {}

import std.math;
import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.negui;
public import nemuxi.negui.layout.layout;
public import nemuxi.negui.layout.panel.panel;


///
class LineException: PanelException {
	mixin MixInNeGuiException;
}


/**
ライン型パネル。

Tansuに似てるけどこっちはセル幅を各要素毎に設定可能。

<del>最終要素のSIZEINFOに対してSizeInfos[$-1].absolute = -1を設定しておくと残りのコンテント領域を埋めようとする。</del>
要素のSIZEINFOにabsolute=-1が設定されていれば最後に設定。
*/
class Line: Panel, IDirection, IArrayLastIndex {
	protected {
		/**
		History:
			1.00β18:
				[S] SizeInfoからSizeInfosに改名。
		*/
		SIZEINFO[] SizeInfos;
	}
	mixin TDirection;

	this(DIRECTION Direction, size_t Length=0) {
		this.Direction = Direction;
		if(Length) {
			length = Length;
		}
	}
	///
	alias Panel.length length;
	/// ditto
	override void length(in size_t Length) {
		super.length(SizeInfos.length = Length);
	}
	
	///
	override void opAddAssign(CONTENT Content) {
		super.opAddAssign(Content);
		SizeInfos ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(NeGui gui) {
		super.opAddAssign(gui);
		SizeInfos ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(Panel panel) {
		super.opAddAssign(panel);
		SizeInfos ~= SIZEINFO.init;
	}
	/// ditto
	override void opAddAssign(void* None) {
		super.opAddAssign(None);
		SizeInfos ~= SIZEINFO.init;
	}

	ref SIZEINFO sizeInfo(in size_t Index) const {
		return SizeInfos[Index];
	}

	
	/**
	History:
		1.030:
			新規作成。
	*/
	override const size_t lastIndex() {
		///
		class LineArrayLastIndexException: LineException{
			mixin MixInNeGuiException;
		}
		
		try {
			return SizeInfos.lastIndex;
		} catch(NeGuiArrayException e) {
			throw new LineArrayLastIndexException(Text("SizeInfos.length == null"), e);
		}
	}

	/**
	History:
		1.00β18:
			[P] -1の取り扱いを拡張。
	*/
	override void onSize(ref const(RECT) TotalSize) {
		if(!Contents.length) {
			return;
		}
		auto FreeSize=new bool[Contents.length];
		auto ElementsSize=new size_t[Contents.length];
		
		immutable InPaddingSize=GetInPaddingSize(TotalSize);
		auto ContentSize=GetContentSize(InPaddingSize);

		size_t ClientTotalSize;
		size_t RestValues;

		// 各領域のサイズ計算。
		foreach(i, SizeInfo; SizeInfos) {
			if(SizeInfo.type == SIZEINFO.TYPE.ABSOLUTE && SizeInfo.absolute == -1) {
				FreeSize[i] = true;
				RestValues++;
			} else {
				ElementsSize[i]=GetElemntSize(Direction, SizeInfo, InPaddingSize);
				ClientTotalSize += ElementsSize[i];
			}
		}
		// -1があればその計算と設定。
		if(RestValues) {
			immutable TotalFreeSize= GetTotalPaddingSize(Direction, InPaddingSize) - ClientTotalSize;
			
			// 一要素の大きさ
			immutable RestSize=TotalFreeSize / RestValues;
			foreach(i; 0 .. Contents.length) {
				if(FreeSize[i]) {
					ElementsSize[i] = RestSize;
				}
			}
		}

		// むーぶ
		size_t IncrementElementSize=0;
		foreach(i, Content; Contents) {
			final switch(Direction) {
				case DIRECTION.HORIZON:
					ContentSize.left  = InPaddingSize.left + padding.left * (i + 1) + padding.right * i + IncrementElementSize;
					ContentSize.right = ContentSize.left + ElementsSize[i];
					break;
				case DIRECTION.VERTICAL:
					ContentSize.top  = InPaddingSize.top + padding.top * (i + 1) + padding.bottom * i + IncrementElementSize;
					ContentSize.bottom = ContentSize.top + ElementsSize[i];
					break;
			}
			IncrementElementSize += ElementsSize[i];
			
			Content.onSize(ContentSize);
		}
	}
}









