﻿/**
デュアル。
*/
module nemuxi.negui.layout.panel.dual;

debug import std.stdio: wl = writefln, pl = printf;
debug(dual) void main() {}

import std.math;
import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.negui;
public import nemuxi.negui.layout.layout;
public import nemuxi.negui.layout.panel.panel;


/**
二画面型パネル。

領域を二分割。

Bugs:
	縦方向未チェック。

History:
	1.062:
		[P] やっぱり中央線を変数からメソッドに。
	
	1.050:
		[P] 中央線をメソッドから変数に。
*/
class Dual: Panel, IDirection {
	invariant() {
		assert(Contents.length == 2);
	}
	mixin TDirection;
	
	SIZEINFO sizeInfo;
	
	this(DIRECTION Direction) {
		this.Direction = Direction;
		Contents.length = 2;
	}
	
	protected int CenterSize;
	mixin(SMixInStructGetSet!(int)("centerSize", q{CenterSize}));
	/**
	History:
		1.030:
			[S] final switchの導入。
			[P] 内部処理一部変更。
	*/
	override void onSize(ref const(RECT) TotalSize) {
		if(!Contents.length) {
			return;
		}
		
		SIZEINFO[2] SizeInfos;
		SizeInfos[0] = sizeInfo;
		SizeInfos[1].absolute = -1;
		
		int IncrementElementSize=0;

		foreach(i, Content; Contents) {
			auto InPaddingSize=GetInPaddingSize(TotalSize);
			
			bool LoopLast() {
				return i == Contents.lastIndex;
			}
			
			auto ContentSize=GetContentSize(InPaddingSize);
			
			final switch(Direction) {
				case DIRECTION.HORIZON:
					if(LoopLast()) {
						InPaddingSize.left += CenterSize - CenterSize/2;
					} else {
						InPaddingSize.right += CenterSize/2;
					}
					break;
				case DIRECTION.VERTICAL:
					if(LoopLast()) {
						InPaddingSize.top += CenterSize - CenterSize/2;
					} else {
						InPaddingSize.bottom += CenterSize/2;
					}
					break;
			}
			
			
			immutable ElementSize = GetElemntSize(Direction, SizeInfos[i], InPaddingSize);
			
			
			final switch(Direction) {
				case DIRECTION.HORIZON:
					ContentSize.left  = InPaddingSize.left + padding.left * (i + 1) + padding.right * i + IncrementElementSize;
					ContentSize.right = ContentSize.left + ElementSize;
				
					if(LoopLast()) {
						ContentSize.right = InPaddingSize.right  - padding.right;
					}
					break;
				
				case DIRECTION.VERTICAL:
					ContentSize.top    = InPaddingSize.top + padding.top * (i + 1) + padding.bottom * i + IncrementElementSize;
					ContentSize.bottom = ContentSize.top + ElementSize;
				
					if(LoopLast()) {
						ContentSize.bottom = InPaddingSize.bottom  - padding.bottom;
					}
					break;
			}
			IncrementElementSize += ElementSize;
			
			Content.onSize(ContentSize);
		}
	}
}

