﻿/**
レイアウト。

NeGuiを見下ろしている感じなのでこいつや配下のpackageはNeGuiオブジェクトを使用可能。
*/
module nemuxi.negui.layout.layout;

debug import std.stdio: wl = writefln, pl = printf;
debug(layout) void main() {}

import win32.windows;

//import nemuxi.base;
import nemuxi.negui.system.base;
import nemuxi.negui.negui;
import nemuxi.negui.layout.panel.panel;
import nemuxi.negui.window.window;

///
class LayoutException: NeGuiException {
	mixin MixInNeGuiException;
}


/**
レイアウト基盤。

CSSのボックスモデルっぽく。
----------------------------------------

+-----------------------------+
| margin                      |
| +-------------------------+ |
| | padding                 | |
| | +---------------------+ | |
| | | content             | | |
| | |                     | | |
| | +---------------------+ | |
| +-------------------------+ |
+-----------------------------+

----------------------------------------

Bugs:
	パーセント指定は非常に怪しい。
*/
abstract class Layout {
	RECT margin;
	RECT padding;

	/**
	サイズ変更。

	親の許可した範囲内でサイズ変更を行う。

	Params:
		BoxRange = 自身が使用できる領域。
		           自身のmargin, paddingが含まれている状態。
	*/
	abstract void onSize(ref const(RECT) TotalSize);
}

/**
こいつの上に重ねて使用。
*/
class LayoutManager: Layout {
	private NeGui Owner;
	Panel basePanel;

	this(NeGui Owner)
	in {
		assert(Owner);
	}
	body {
		this.Owner = Owner;

		padding.left = padding.right  = GetSystemMetrics(SM_CXDLGFRAME);
		padding.top  = padding.bottom = GetSystemMetrics(SM_CYDLGFRAME);
	}

	/**
	無理やり更新。

	History:
		1.010:
			[F] 挙動を変更。
	*/
	void reLoad() {
		auto Size=Owner.itemSize;
		Owner.reDraw(false);
		Owner.size(Size.cx, Size.cy+1);
		Owner.reDraw(true);
		Owner.size(Size.cx, Size.cy);
	}


	/// 親のOnSizeで呼び出し。
	void onSize(in int Width, in int Height) {
		// コンテント領域の取得
		RECT ContentSize=void;
		
		ContentSize.left = margin.left + padding.left;
		ContentSize.top  = margin.top  + padding.top;

		ContentSize.right  = Width  - ContentSize.left - margin.right  - padding.right;
		ContentSize.bottom = Height - ContentSize.top  - margin.bottom - padding.bottom;

		onSize(ContentSize);
	}
	///
	final protected override void onSize(ref const(RECT) ContentSize) {
		if(basePanel) {
			basePanel.onSize(ContentSize);
		}
	}
}

