﻿/**
History:
	1.010:
		新規作成。
*/
module nemuxi.negui.input.mouse.mouse;

debug import std.stdio: wl = writefln, pl = printf;
debug(mouse) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;
public import nemuxi.negui.negui;
public import nemuxi.negui.input.inputif;

///
class MouseException: InputException {
	mixin MixInNeGuiException;
}

struct MOUSE {
	static:
	
	/// カーソル位置設定。
	bool position(in int x, in int y) {
		return cast(bool)SetCursorPos(x, y);
	}
	/// ditto
	bool position(const ref POINT Point) {
		return position(Point.x, Point.y);
	}

	/***/
	ref POINT position() {
		auto Point=new POINT;

		enforce(GetCursorPos(Point), new MouseException(ERR.toText));

		return *Point;
	}

	enum {
		SPI_GETSNAPTODEFBUTTON = 95,
	}
	bool over(in NeGui gui) {
		try {
			auto Rect=gui.itemRect();

			with(Rect) return position(
				left + (right  - left) / 2,
				top  + (bottom - top)  / 2
			);
		} catch(Throwable e) {
			return false;
		}
	}
	bool overAuto(lazy NeGui gui) {
		BOOL Move;
		
		if(!SystemParametersInfo(SPI_GETSNAPTODEFBUTTON, 0, &Move, 0)) {
			return false;
		}
		
		if(Move) {
			return over(gui);
		}
		
		return false;
	}
	
}

