﻿/**
キーボードアクセラレータ。
*/
module nemuxi.negui.input.keyboard.accelerator;

debug import std.stdio: wl = writefln, pl = printf;
debug(accelerator) void main() {}

import std.string;
import std.contracts;

import win32.core;

import nemuxi.negui.system.base;
import nemuxi.negui.system.type.basic;
public import nemuxi.negui.input.inputif;
public import nemuxi.negui.input.keyboard.keyboard;
public import nemuxi.negui.window.newindow;

///
class AcceleratorException: KeyBoardException {
	mixin MixInNeGuiException;
}


struct ACCELERATOR {
	ACCEL Accel;
	mixin(SMixInStructHiddenOriginal!(ACCEL)(`Accel`));
	
	///
	static enum TYPE: byte {
		ALT     = FALT,     /// [ALT]キー
		CONTROL = FCONTROL, /// [Ctrl]キー
		SHIFT   = FSHIFT,   /// [Shift]キー
		VIRTKEY = FVIRTKEY, /// 仮想キーコード
	}
	mixin(SMixInStructGetSet!(TYPE)("type", q{Accel.fVirt}));
	mixin(SMixInStructGetSet!(KEY)("key", q{Accel.key}));
	mixin(SMixInStructGetSet!(COMMAND_ID)("command", q{Accel.cmd}));

	string toString() {
		return toText.text8;
	}
	const Text toText() {
		return Text(
			"[ACCELERATOR]"
			"  type = %s",    type,
			" ,key = %s",     key,
			" ,command = %s", command
		);
	}
}
unittest {
	assert(ACCEL.sizeof == ACCELERATOR.sizeof);
}
class Accelerator: HandleRaii {
	static {
		private struct ACCELTABLE {
			NeWindow window;
			Accelerator accel;

			static ACCELTABLE opCall(NeWindow window, Accelerator Accel)
			in {
				assert(window);
				assert(Accel);
			}
			body {
				ACCELTABLE Table;
				Table.window = window;
				Table.accel  = Accel;
				return Table;
			}
		}
		private ACCELTABLE[NeWindow] AccelTable;

		void idRegist(NeWindow window, Accelerator Accel)
		in {
			assert(window);
			assert(Accel);
		}
		body {
			AccelTable[window] = ACCELTABLE(window, Accel);
		}
		/**
		History:
			1.00β15:
				[B] 二回目にnull入れたときにバーンってなるバグ修正。
		*/
		Accelerator idUnRegist(NeWindow window) {
			if(window in AccelTable) {
				auto Accel = AccelTable[window].accel;
				AccelTable.remove(window);
				return Accel;
			}
			return null;
		}
		// すっげー重そう。
		bool isTranslateAccelerator(NeWindow window, MSG* Message)
		in {
			assert(Message);
		}
		body {
			if(AccelTable && window in AccelTable) {
				assert(AccelTable[window].window.isAlive);
				assert(AccelTable[window].accel());
				return cast(bool)TranslateAccelerator(AccelTable[window].window(), AccelTable[window].accel(), Message);
			}
			return false;
		}
	}
	
	protected alias Handle hAccel;
	mixin KillResource!("キーボードアクセラレータ", hAccel, DestroyAcceleratorTable, 0);

	this(ACCELERATOR[] Accels)
	in {
		assert(Accels.length);
	}
	body {
		super(CreateAcceleratorTable(cast(ACCEL*)Accels.ptr, Accels.length), true);
		if(!hAccel) {
			throw new AcceleratorException(Text(Accels));
		}
	}
	this(ACCELERATOR Accels[] ...) {
		this(Accels);
	}

	const ACCELERATOR[] get() {
		if(auto Length=CopyAcceleratorTable(hAccel, NULL, 0)) {
			auto Accels=new ACCELERATOR[Length];
			enforce(CopyAcceleratorTable(hAccel, cast(ACCEL*)Accels.ptr, Length), new AcceleratorException(ERR.toText));

			return Accels;
		}
		
		return null;
	}

	void opAddAssign(const ref ACCELERATOR Accel) {
		opAddAssign([Accel]);
	}
	void opAddAssign(in Accelerator Accel) {
		opAddAssign(Accel.get());
	}
	void opAddAssign(in ACCELERATOR[] Accels) {
		ACCELERATOR[] NowAccels=get();
		
		NowAccels ~= Accels;
		
		delete this;
		this = new Accelerator(NowAccels);
	}

}

