﻿/**
History:
	1.010:
		新規作成。
*/
module nemuxi.negui.input.input;

debug import std.stdio: wl = writefln, pl = printf;

debug(input) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
public import nemuxi.negui.input.inputif;
import nemuxi.negui.input.keyboard.keyboard;

///
enum {
	MOUSEEVENTF_MOVE            = 0x0001,
	MOUSEEVENTF_LEFTDOWN        = 0x0002,
	MOUSEEVENTF_LEFTUP          = 0x0004,
	MOUSEEVENTF_RIGHTDOWN       = 0x0008,
	MOUSEEVENTF_RIGHTUP         = 0x0010,
	MOUSEEVENTF_MIDDLEDOWN      = 0x0020,
	MOUSEEVENTF_MIDDLEUP        = 0x0040,
	MOUSEEVENTF_XDOWN           = 0x0080,
	MOUSEEVENTF_XUP             = 0x0100,
	MOUSEEVENTF_WHEEL           = 0x0800,
	MOUSEEVENTF_HWHEEL          = 0x00001000,
	MOUSEEVENTF_MOVE_NOCOALESCE = 0x00002000,
	MOUSEEVENTF_VIRTUALDESK     = 0x4000,
	MOUSEEVENTF_ABSOLUTE        = 0x8000,
}

/***/
struct MOUSEEVENTINPUT {
	MOUSEINPUT MouseInput;
	mixin(SMixInStructHiddenOriginal!(MOUSEINPUT)(`MouseInput`));
	
	mixin(SMixInStructGetSet!(int)("x", q{MouseInput.dx}));
	mixin(SMixInStructGetSet!(int)("y", q{MouseInput.dy}));
	
	alias MouseInput.mouseData wheel;
	
	enum FLAG {
		ABSOLUTE        = MOUSEEVENTF_ABSOLUTE,
		MOVE            = MOUSEEVENTF_MOVE,
		MOVE_NOCOALESCE = MOUSEEVENTF_MOVE_NOCOALESCE,
		LEFTDOWN        = MOUSEEVENTF_LEFTDOWN,
		LEFTUP          = MOUSEEVENTF_LEFTUP,
		RIGHTDOWN       = MOUSEEVENTF_RIGHTDOWN,
		RIGHTUP         = MOUSEEVENTF_RIGHTUP,
		MIDDLEDOWN      = MOUSEEVENTF_MIDDLEDOWN,
		MIDDLEUP        = MOUSEEVENTF_MIDDLEUP,
		VIRTUALDESK     = MOUSEEVENTF_VIRTUALDESK,
		WHEEL           = MOUSEEVENTF_WHEEL,
		HWHEEL          = MOUSEEVENTF_HWHEEL,
		XDOWN           = MOUSEEVENTF_XDOWN,
		XUP             = MOUSEEVENTF_XUP,
	}
	mixin(SMixInStructGetSet!(FLAG)("flags", q{MouseInput.dwFlags}));
	
	mixin(SMixInStructGetSet!(void*)("data", q{MouseInput.dwExtraInfo}));
}

/***/
struct KEYBOARDEVENTINPUT {
	KEYBDINPUT KeyBdInput;
	mixin(SMixInStructHiddenOriginal!(KEYBDINPUT)(`KeyBdInput`));
	
	mixin(SMixInStructGetSet!(KEY)("key", q{KeyBdInput.wVk}));
	
	alias KeyBdInput.wScan scan;

	enum FLAG {
		EXTENDEDKEY = KEYEVENTF_EXTENDEDKEY,
		KEYUP       = KEYEVENTF_KEYUP,
		SCANCODE    = KEYEVENTF_SCANCODE,
		UNICODE     = KEYEVENTF_UNICODE,
	}
	mixin(SMixInStructGetSet!(FLAG)("flags", q{KeyBdInput.dwFlags}));
	
	mixin(SMixInStructGetSet!(void*)("data", q{KeyBdInput.dwExtraInfo}));
}

/***/
struct HARDWAREEVENTINPUT {
	HARDWAREINPUT HardWareInput;
	mixin(SMixInStructHiddenOriginal!(HARDWAREINPUT)(`HardWareInput`));
	
	alias HardWareInput.uMsg message ;
}


/***/
struct EVENTINPUT {
	INPUT Input;
	mixin(SMixInStructHiddenOriginal!(INPUT)(`Input`));

	///
	enum TYPE {
		MOUSE    = INPUT_MOUSE   , /// マウスイベント
		KEYBOARD = INPUT_KEYBOARD, /// キーボードイベント
		HARDWARE = INPUT_HARDWARE, /// ハードウェアイベント
	}
	mixin(SMixInStructGet!(TYPE)("type", q{Input.type}));

	/***/
	void event(ref MOUSEEVENTINPUT MouseEventInput) {
		Input.mi   = *MouseEventInput.ptr;
		Input.type = TYPE.MOUSE;
	}
	/// ditto
	void event(ref KEYBOARDEVENTINPUT KeyBoardEventInput) {
		Input.ki   = *KeyBoardEventInput.ptr;
		Input.type = TYPE.KEYBOARD;
	}
	/// ditto
	void event(ref HARDWAREEVENTINPUT HardWareEventInput) {
		Input.hi   = *HardWareEventInput.ptr;
		Input.type = TYPE.HARDWARE;
	}

	/// ditto
	MOUSEEVENTINPUT mouseEvent() {
		return cast(MOUSEEVENTINPUT)Input.mi;
	}
	/// ditto
	KEYBOARDEVENTINPUT keyBoardEvent() {
		return cast(KEYBOARDEVENTINPUT)Input.ki;
	}
	/// ditto
	HARDWAREEVENTINPUT hardWareEvent() {
		return cast(HARDWAREEVENTINPUT)Input.hi;
	}
	debug(input) unittest {
		EVENTINPUT         ei;
		MOUSEEVENTINPUT    mi;
		KEYBOARDEVENTINPUT ki;
		HARDWAREEVENTINPUT hi;
		ei.event(mi);
		assert(ei.type == TYPE.MOUSE);
		ei.event(ki);
		assert(ei.type == TYPE.KEYBOARD);
		ei.event(hi);
		assert(ei.type == TYPE.HARDWARE);
	}
}
//SendInput
int SendEventInput(EVENTINPUT[] EventInputs)
in {
	assert(EventInputs);
}
body {
	assert(0);
}


