﻿/**
ファイル検索。

Phobosはちっと使わない。
*/
module nemuxi.negui.file.find;

debug import std.stdio: wl = writefln, pl = printf;

debug(find) void main() {}

import win32.windows;

import nemuxi.negui.system.base;
import nemuxi.negui.file.file;

/**
History:
	1.081:
		[S] 色々拡張。

	1.00β13:
		[S] 隠蔽用ptrメソッド実装。
		[S] 構造体変数を改名。
*/
struct FILEITEM {
	WIN32_FIND_DATA FindData;
	mixin(SMixInStructHiddenOriginal!(WIN32_FIND_DATA)(q{FindData}));

	/// ファイル属性。
	const FILE.ATTRIBUTE attributes() {
		return cast(FILE.ATTRIBUTE)FindData.dwFileAttributes;
	}

	/// 時間。てけとう。
	//alias FindData.ftCreationTime   createTime;
	const DateTime createTime() {
		return new DateTime(FindData.ftCreationTime);
	}
	
	/// ditto
	//alias FindData.ftLastAccessTime lastAccessTime;
	const DateTime lastAccessTime() {
		return new DateTime(FindData.ftLastAccessTime);
	}

	/// ditto
	//alias FindData.ftLastWriteTime  lastWriteTime;
	const DateTime lastWriteTime() {
		return new DateTime(FindData.ftLastWriteTime);
	}

	/**
	History:
		1.081:
			[B] サイズ求めれてなかった。
	*/
	const ulong size() {
		return (FindData.nFileSizeHigh << DWORD.sizeof) + FindData.nFileSizeLow;
	}

	/// ファイル名。
	Text name() {
		return Text(FindData.cFileName.ptr);
	}
	/// 8.3文字ファイル名。
	Text shortName() {
		return Text(FindData.cAlternateFileName.ptr);
	}

	/**
	History:
		1.00β14:
			[P] const属性追加。
	*/
	const bool isFolder() {
		return (FindData.dwFileAttributes & FILE.ATTRIBUTE.FOLDER) == FILE.ATTRIBUTE.FOLDER;
	}

	const bool isParentFolder() {
		return FindData.cFileName[0] == '.' && FindData.cFileName[1] == '\0';
	}
	const bool isBaseFolder() {
		return FindData.cFileName[0] == '.' && FindData.cFileName[1] == '.' && FindData.cFileName[2] == '\0';
	}

	Text toText() {
		Text Format = "[YYYY]/[M]/[DD]  [hh]:[mm]";
		auto Month  = Texts("01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12");
		Text Folder = isFolder ? "<DIR>": "     ";
		auto CreateTime=createTime;
		CreateTime.format = Format.text8;
		CreateTime.monthList = Strings(Month);
		return Text(
			`%s %s %8s %s`,
			CreateTime,
			Folder,
			size,
			name
		);
	}
	string toString() {
		return toText.text8;
	}
}

/**
ファイル検索。

History:
	1.081:
		[S] 継承元変更。

	1.00β14:
		[S] 使い道の無いであろうnewPatternメソッドを非推奨に。
*/
class Finder: HandleRaii {
	protected alias Handle hFind;
	mixin KillResource!("ファイル検索", hFind, FindClose, 0);

	protected bool NextFind;

	protected wchar* FilePattern;
	protected size_t Count;
	
	this(in Text FilePattern) {
		super(null, false);
		this.FilePattern = FilePattern.ptr;
	}

	/**
	History:
		1.050:
			[S] deprecated修正。
	*/
	bool find(ref FILEITEM FileItem) {
		if(NextFind) {
			if(FindNextFile(hFind, FileItem.ptr)) {
				Count++;
				return true;
			} else {
				NextFind=false;
				return false;
			}
		} else {
			//auto FileFind=FindFirstFile(FilePattern, &FileItem.info);
			auto FileFind=FindFirstFile(FilePattern, FileItem.ptr);
			if(FileFind == INVALID_HANDLE_VALUE) {
				super.Suicide = false;
				return false;
			} else {
				super.Suicide = true;
				NextFind = true;
				hFind = FileFind;
				Count++;
				return true;
			}
		}
	}

	const size_t count() {
		return Count;
	}
}

/**
Finderの定型取得。

History:
	1.090:
		[S] 名前変更(FINDER -> FIND)

	1.081:
		新規作成。
*/
static struct FIND {
	static:

	/**
	History:
		1.090:
			新規作成。
	*/
	FILEITEM[] find(in Text Pattern, FILE.ATTRIBUTE Attribute, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		scope finder=new Finder(Pattern);
		auto FileItems=new FILEITEM[InitialValue];
		FILEITEM FileItem;
		size_t i=0;
		
		while(finder.find(FileItem)) {
			if(Attribute == FILE.ATTRIBUTE.NONE || (FileItem.attributes & Attribute) == Attribute) {
				FileItems.autoIncrement(i, Increment);
				FileItems[i++] = FileItem;
			}
		}
		return FileItems[0 .. i];
	}
	
	/**
	指定フォルダ、指定パターンからファイル検索。
	
	History:
		1.090:
			[S] 属性も考慮。
	*/
	FILEITEM[] list(in Text FolderPath, in Text Pattern, FILE.ATTRIBUTE Attribute, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		return find(PATH.join(FolderPath, Pattern), Attribute, InitialValue, Increment);
	}
	/**
	*/
	FILEITEM[] dir(in Text FolderPath, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		return list(FolderPath, Text('*'), FILE.ATTRIBUTE.NONE, InitialValue, Increment);
	}
	/**
	*/
	FILEITEM[] files(in Text FolderPath, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		auto List=list(FolderPath, Text('*'), FILE.ATTRIBUTE.NONE, InitialValue, Increment);
		auto Result=new FILEITEM[List.length];
		size_t i;
		foreach(Value; List) {
			if(!Value.isFolder) {
				Result[i++] = Value;
			}
		}
		return Result[0 .. i];
	}
	/**
	*/
	FILEITEM[] folders(in Text FolderPath, size_t InitialValue=BUFFER.INITIAL, size_t Increment=BUFFER.INCREMENT) {
		return list(FolderPath, Text('*'), FILE.ATTRIBUTE.FOLDER, InitialValue, Increment);
	}
	
	debug(find) unittest {
		auto list=FIND.dir(Text(`C:\`));
		foreach(file; list) {
			wl("%s", file);
		}
		wl("---------");
		list=FIND.files(Text(`C:\`));
		foreach(file; list) {
			wl("%s", file);
		}
		wl("---------");
		list=FIND.folders(Text(`C:\`));
		foreach(file; list) {
			wl("%s", file);
		}
	}
}

