﻿/**
バージョン情報用。
*/
module nemuxi.negui.file.exever;
debug import std.stdio: wl = writefln, pl = printf;
debug(exever) void main() {}

import std.contracts;

import win32.windows;
import win32.winver;

import nemuxi.negui.system.base;
import nemuxi.negui.file.file;

pragma(lib, "Version.Lib");

///
class VersionException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
History:
	1.061:
		[S] IText継承。
*/
class Version: IText {
	enum TYPE {
		COMMENTS,
		INTERNALNAME,
		PRODUCTNAME,
		COMPANYNAME,
		LEGALCOPYRIGHT,
		PRODUCTVERSION,
		FILEDESCRIPTION,
		LEGALTRADEMARKS,
		PRIVATEBUILD,
		FILEVERSION,
		ORIGINALFILENAME,
		SPECIALBUILD,
	}
	private static struct DEF {
		static immutable wstring COMMENTS          = "Comments";
		static immutable wstring INTERNALNAME      = "InternalName";
		static immutable wstring PRODUCTNAME       = "ProductName";
		static immutable wstring COMPANYNAME       = "CompanyName";
		static immutable wstring LEGALCOPYRIGHT    = "LegalCopyright";
		static immutable wstring PRODUCTVERSION    = "ProductVersion";
		static immutable wstring FILEDESCRIPTION   = "FileDescription";
		static immutable wstring LEGALTRADEMARKS   = "LegalTrademarks";
		static immutable wstring PRIVATEBUILD      = "PrivateBuild";
		static immutable wstring FILEVERSION       = "FileVersion";
		static immutable wstring ORIGINALFILENAME  = "OriginalFilename";
		static immutable wstring SPECIALBUILD      = "SpecialBuild";

		pure nothrow static wstring typeToDef(TYPE Type) {
			final switch(Type) {
				case TYPE.COMMENTS:         return DEF.COMMENTS;
				case TYPE.INTERNALNAME:     return DEF.INTERNALNAME;
				case TYPE.PRODUCTNAME:      return DEF.PRODUCTNAME;
				case TYPE.COMPANYNAME:      return DEF.COMPANYNAME;
				case TYPE.LEGALCOPYRIGHT:   return DEF.LEGALCOPYRIGHT;
				case TYPE.PRODUCTVERSION:   return DEF.PRODUCTVERSION;
				case TYPE.FILEDESCRIPTION:  return DEF.FILEDESCRIPTION;
				case TYPE.LEGALTRADEMARKS:  return DEF.LEGALTRADEMARKS;
				case TYPE.PRIVATEBUILD:     return DEF.PRIVATEBUILD;
				case TYPE.FILEVERSION:      return DEF.FILEVERSION;
				case TYPE.ORIGINALFILENAME: return DEF.ORIGINALFILENAME;
				case TYPE.SPECIALBUILD:     return DEF.SPECIALBUILD;
			}
		}
	}
	private {
		immutable size_t DataSize;
		immutable void[] VersionData;
	}
	this(in Text FilePath) {
		try {
			enforce(FILE.isFile(FilePath), new VersionException(Text("%sはフォルダ", FilePath)));

			DWORD Handle;
			DataSize = GetFileVersionInfoSize(FilePath.ptr, &Handle);
			enforce(DataSize, new VersionException(ERR.toText));
			{
				scope TempData = new void[DataSize];
				GetFileVersionInfo(FilePath.ptr, Handle, DataSize, TempData.ptr);
				VersionData = TempData.idup;
			}
			
		} catch(Exception e) {
			throw new VersionException(Text("失敗"), e);
		}
	}
	struct LANGANDCODEPAGE {
		WORD Language;
		WORD CodePage;
		const Text toText() {
			return Text("%04x%04x", Language, CodePage);
		}
	}
	private const size_t Query(in Text SubBlock, void* Data) {
		size_t DataLength;
		
		if(VerQueryValue(cast(void*)VersionData.ptr, SubBlock.ptr, cast(void**)Data, &DataLength)) {
			return DataLength;
		}

		return 0;
	}
	const immutable(LANGANDCODEPAGE[]) langAndCode() {
		LANGANDCODEPAGE* LangCode;
		auto Size=Query(Text(`\VarFileInfo\Translation`), &LangCode);
		return cast(immutable)LangCode[0..Size];
	}
	
	private const Text FileInfo(in wstring Define, in LANGANDCODEPAGE LangAndCode) {
		const SubBlock=Text(`\StringFileInfo\%s\%s`, LangAndCode.toText, Define);
		
		wchar* Data;
		auto DataLength=Query(SubBlock, &Data);

		if(DataLength) {
			return Text(Data[0 .. DataLength-1]);
		} else {
			return Text.emptyText;
		}
	}
	const Text fileInfo(TYPE Type, in LANGANDCODEPAGE LangCode) {
		return FileInfo(DEF.typeToDef(Type), LangCode);
	}

	/**
	History:
		1.061:
			[S] ITextにあわせる。
	*/
	override const Text toText() {
		immutable LangAndCodes=langAndCode;
		
		Text[] infos;
		foreach(LangAndCode; LangAndCodes) {
			for(TYPE Type=TYPE.min; Type < TYPE.max; Type++) {
				immutable s=DEF.typeToDef(Type);
				const t=FileInfo(s, LangAndCode);
				if(t.length) {
					infos ~= Text("%s: %s", s, t);
				}
			}
		}
		return infos.join(Text.newline);
	}
	override string toString() {
		return toText.text8;
	}
}
debug(exever) unittest {
	auto v=new Version(Text(`C:\Program Files\Internet Explorer\iexplore.exe`));
	//wl("%s", v.fileInfo(v.langAndCode, Version.TYPE.FILEVERSION));
	wl("%s",v.toText);
}

