﻿/**

History:
	1.000:
		packageをnemuxi.dllからnemuxi.negui.fileへ移動。

	1.00β11:
		packageをnemuxi.utilityからnemuxi.dllへ移動。
*/
module nemuxi.negui.file.dll;

debug import std.stdio: wl = writefln, pl = printf;
debug(dll) void main() {}

import std.contracts;

import win32.windows;

import nemuxi.negui.system.base;

class DllException: NeGuiException {
	mixin MixInNeGuiException;
}

/**
*/
class DLL: HandleRaii {
	protected alias Handle hDLL;
	mixin KillResource!("DLL", hDLL, FreeLibrary, 0);

	this(in Text Path) {
		enforce(hDLL = LoadLibrary(Path.ptr), new DllException(Path));
		super(hDLL, true);
	}

	/**
	History:
		1.00β16:
			[S] Tがよろしくない場合に出力していた文言の出力方式を若干変更。
	*/
	RET address(RET, T)(in T Address) const {
		static if(is(T == Text) || is(T == const(Text))) {
			return cast(RET)GetProcAddress(hDLL, Address.toStringz);
		} else static if(is(T == int)) {
			return cast(RET)GetProcAddress(hDLL, cast(LPCSTR)Address);
		} else {
			static assert(false, "oh! " ~ T.stringof);
		}
	}
}

